/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gennbo.NBODialog;
import org.gennbo.NBOUtil;
import org.jmol.i18n.GT;

class NBOFileHandler
extends JPanel {
    protected static final String sep = System.getProperty("line.separator");
    protected static final String EXTENSIONS = "31;32;33;34;35;36;37;38;39;40;41;42;46;nbo";
    protected static final String[] EXT_ARRAY = PT.split("31;32;33;34;35;36;37;38;39;40;41;42;46;nbo", ";");
    protected File inputFile;
    protected JTextField tfDir;
    protected JTextField tfName;
    protected JTextField tfExt;
    JButton btnBrowse;
    protected String fullFilePath;
    protected String jobStem;
    protected String useExt;
    protected NBODialog dialog;
    protected boolean canReRun;
    protected boolean isOpenShell;
    protected static final int MODE_MODEL_USE = 1;
    protected static final int MODE_RUN = 2;
    protected static final int MODE_VIEW = 3;
    protected static final int MODE_SEARCH = 4;
    protected static final int MODE_MODEL_SAVE = 5;

    public NBOFileHandler(String jobName, String ext, int mode, String useExt, NBODialog dialog) {
        this.dialog = dialog;
        this.canReRun = true;
        this.fullFilePath = dialog.getWorkingPath();
        this.useExt = useExt;
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(350, 40));
        this.setPreferredSize(new Dimension(350, 40));
        this.setMinimumSize(new Dimension(350, 40));
        GridBagConstraints c = new GridBagConstraints();
        boolean canEditTextFields = mode == 5 || mode == 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.tfDir = new JTextField();
        this.tfDir.setPreferredSize(new Dimension(110, 20));
        this.tfDir.setEditable(canEditTextFields);
        this.tfDir.setText(this.fullFilePath);
        this.add((Component)this.tfDir, c);
        c.gridx = 1;
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(120, 20));
        this.tfName.setEditable(canEditTextFields);
        this.add((Component)this.tfName, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)new JLabel("         folder"), c);
        c.gridx = 1;
        this.add((Component)new JLabel("          name"), c);
        c.gridx = 2;
        c.gridy = 0;
        this.tfExt = new JTextField();
        this.tfExt.setPreferredSize(new Dimension(40, 20));
        this.tfExt.setEditable(canEditTextFields);
        this.tfExt.setText(ext);
        if (canEditTextFields) {
            this.add((Component)this.tfExt, c);
            c.gridy = 1;
            this.add((Component)new JLabel("  ext"), c);
        }
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 2;
        this.btnBrowse = new JButton(mode == 5 ? "Save" : "Browse");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBOFileHandler.this.doFileBrowsePressed();
            }
        });
        this.add((Component)this.btnBrowse, c);
        this.setJobStemAndTextFieldName(jobName);
        this.setInput(this.fullFilePath, jobName, ext);
    }

    protected boolean doFileBrowsePressed() {
        int i;
        if (this.dialog.nboService.isWorking() && this.dialog.statusLab.getText().startsWith("Running") && (i = JOptionPane.showConfirmDialog(this.dialog, "Warning, changing jobs while running GenNBO can effect output files.\nContinue anyway?")) == 1) {
            return false;
        }
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt));
        myChooser.setFileHidingEnabled(true);
        String folder = this.tfDir.getText();
        String name = this.tfName.getText();
        if (folder.length() > 0) {
            this.fullFilePath = NBOUtil.getWindowsFullNameFor(folder, name.length() == 0 ? " " : name + (this.useExt.equals("47") ? ".47" : ""), null);
        }
        myChooser.setSelectedFile(new File(this.fullFilePath));
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            return this.loadSelectedFile(myChooser.getSelectedFile());
        }
        return true;
    }

    protected boolean loadSelectedFile(File selectedFile) {
        this.dialog.nboService.restartIfNecessary();
        this.inputFile = selectedFile;
        if (this.dialog.dialogMode == 1) {
            return true;
        }
        if (!this.useExt.equals("47")) {
            this.setJobStemAndTextFieldName(NBOUtil.getJobStem(this.inputFile));
            this.dialog.modelPanel.loadModelFromNBO(this.fullFilePath, this.jobStem, this.useExt);
            this.tfExt.setText(this.useExt);
            return true;
        }
        this.canReRun = true;
        this.setInputFile(this.inputFile);
        this.dialog.runPanel.doLogJobName(this.jobStem);
        this.fullFilePath = this.inputFile.getParent();
        this.dialog.saveWorkingPath(this.fullFilePath.toString());
        return true;
    }

    private void setJobStemAndTextFieldName(String name) {
        this.jobStem = name;
        this.tfName.setText(this.jobStem);
    }

    protected void setInputFile(File inputFile) {
        this.dialog.logValue("Input file=" + inputFile);
        this.clearInputFile(false);
        this.inputFile = inputFile;
        if (inputFile.getName().indexOf(".") > 0) {
            this.jobStem = NBOUtil.getJobStem(inputFile);
        }
        if (this.dialog.modelOrigin == 4) {
            this.clearInputFile(true);
        }
        this.setInput(inputFile.getParent(), this.jobStem, this.useExt);
        if (!NBOUtil.getExt(inputFile).equals("47")) {
            return;
        }
        if (NBOUtil.fixPath(inputFile.getParent().toString()).equals(this.dialog.nboService.getServerPath(null))) {
            JOptionPane.showMessageDialog(this, "Select a directory that does not contain the NBOServe executable,\nor select a new location for your NBOServe executable");
            return;
        }
        this.fullFilePath = inputFile.getParent();
        boolean canLoad = true;
        boolean isOK = true;
        String msg = "";
        if (this.dialog.dialogMode != 1) {
            for (String x : EXT_ARRAY) {
                File f3 = this.newNBOFileForExt(x);
                if (f3.exists() && (!x.equals("36") || f3.length() != 0L)) continue;
                msg = "file " + f3 + " is missing or zero length";
                isOK = false;
                break;
            }
        }
        if (!isOK) {
            if (this.dialog.dialogMode != 2) {
                if (this.canReRun) {
                    this.canReRun = false;
                    this.dialog.runPanel.doRunGenNBOJob("PLOT");
                } else {
                    this.dialog.alertError("Error occurred during run: " + msg);
                }
                return;
            }
            canLoad = false;
        }
        if (canLoad) {
            this.dialog.loadNewFile(new File(this.fullFilePath + "/" + this.jobStem + ".47"));
        } else if (this.dialog.dialogMode == 2) {
            this.dialog.modelPanel.loadModelFromNBO(this.fullFilePath, this.jobStem, this.useExt);
            this.setJobStemAndTextFieldName(this.jobStem);
            this.tfExt.setText("47");
        }
    }

    protected String[] read47File(boolean doAll) {
        String[] fileData = new String[]{"", "", "", ""};
        String nboKeywords = "";
        SB data = new SB();
        if (!NBOUtil.read47FileBuffered(this.inputFile, data, doAll)) {
            return fileData;
        }
        String s = PT.trim(data.toString(), "\t\r\n ");
        String[] tokens = PT.split(s, "$END");
        if (tokens.length == 0) {
            return fileData;
        }
        SB preParams = new SB();
        SB postParams = new SB();
        SB params = preParams;
        int n = tokens.length;
        for (int i = 0; i < n; ++i) {
            s = PT.trim(tokens[i], "\t\r\n ");
            if (params == preParams && s.indexOf("$NBO") >= 0) {
                String[] prePost = PT.split(s, "$NBO");
                if (prePost[0].length() > 0) {
                    params.append(s).append(sep);
                }
                nboKeywords = PT.trim(prePost[1], "\t\r\n ");
                params = postParams;
                if (doAll) continue;
                break;
            }
            params.append(s).append(sep).append("$END").append(sep);
        }
        this.dialog.logInfo("$NBO: " + nboKeywords, 4);
        fileData[0] = NBOUtil.fix47File(preParams.toString());
        fileData[1] = NBOUtil.removeNBOFileKeyword(nboKeywords, null);
        fileData[2] = postParams.toString();
        fileData[3] = nboKeywords;
        return fileData;
    }

    public void clear() {
        this.tfName.setText("");
        this.tfExt.setText("");
    }

    protected void clearInputFile(boolean andUserDir) {
        if (this.jobStem.length() == 0) {
            return;
        }
        for (String ext : EXT_ARRAY) {
            try {
                new File(this.dialog.nboService.getServerPath(this.jobStem + "." + ext)).delete();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (andUserDir) {
            for (String ext : EXT_ARRAY) {
                try {
                    NBOUtil.newNBOFile(this.inputFile, ext).delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.inputFile = null;
        if (this.dialog.dialogMode == 3) {
            this.dialog.viewPanel.resetView();
        }
    }

    protected void setInput(String dir, String name, String ext) {
        if (dir != null) {
            this.tfDir.setText(dir);
        }
        if (name != null) {
            this.tfName.setText(name);
        }
        if (this.tfExt != null) {
            this.tfExt.setText(ext);
        }
        if (dir != null && name != null && ext != null) {
            this.dialog.modelPanel.modelSetSaveParametersFromInput(this, dir, name, ext);
            this.inputFile = new File(dir + "\\" + name + "." + ext);
        }
    }

    protected String getFileData(String fileName) {
        return this.dialog.vwr.getAsciiFileOrNull(fileName);
    }

    boolean writeToFile(String fileName, String s) {
        String ret = this.dialog.vwr.writeTextFile(fileName, s);
        return ret != null && ret.startsWith("OK");
    }

    public void setBrowseEnabled(boolean b) {
        this.btnBrowse.setEnabled(b);
    }

    public String getInputFile(String name) {
        return this.getFileData(this.newNBOFileForExt(name).toString());
    }

    public File newNBOFileForExt(String filenum) {
        return NBOUtil.newNBOFile(this.inputFile, filenum);
    }

    public String fixJobName(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            name = this.jobStem;
        }
        int i = name.length();
        while (--i >= 0) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            name = name.substring(0, i) + "_" + name.substring(i + 1);
        }
        return name;
    }

    public String[] update47File(String jobName, String keywords) {
        if (!this.useExt.equals("47")) {
            return null;
        }
        String[] fileData = this.read47File(true);
        if (this.writeToFile(this.inputFile.getAbsolutePath(), fileData[0] + "$NBO\n " + "FILE=" + jobName + " " + keywords + "  $END" + sep + fileData[2])) {
            fileData[1] = keywords;
            fileData[3] = "FILE=" + jobName + " " + keywords;
            this.dialog.runPanel.doLogJobName(jobName);
            this.dialog.runPanel.doLogKeywords(keywords);
            return fileData;
        }
        this.dialog.logInfo("Could not create " + this.inputFile, 2);
        return null;
    }

    public boolean checkSwitch47To(String jobName) {
        if (!jobName.equals(this.jobStem)) {
            int i = JOptionPane.showConfirmDialog(null, "Note: Plot files are being created with name \"" + jobName + "\", which does not match your file name \"" + this.jobStem + "\"\nTo continue, we must create a new .47 file \"" + jobName + ".47\" so that all files related to this job are under the same name. Continue?", "Warning", 0);
            if (i != 0) {
                return false;
            }
            String data = this.dialog.vwr.getAsciiFileOrNull(this.inputFile.getAbsolutePath());
            this.setJobStemAndTextFieldName(jobName);
            this.setInput(this.tfDir.getText(), jobName, "47");
            if (data != null) {
                this.writeToFile(this.inputFile.getAbsolutePath(), data);
            }
        }
        return true;
    }
}

