/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.spartan;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.spartan.SpartanSmolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

class SpartanArchive {
    private int modelCount = 0;
    private int modelAtomCount = 0;
    private int ac = 0;
    private String bondData;
    private int moCount = 0;
    private int coefCount = 0;
    private int shellCount = 0;
    private int gaussianCount = 0;
    private String endCheck;
    private boolean isSMOL;
    private BasisFunctionReader r;
    private String line;

    SpartanArchive(BasisFunctionReader r, String bondData, String endCheck, int smolAtomCount) {
        this.initialize(r, bondData);
        this.modelAtomCount = smolAtomCount;
        this.endCheck = endCheck;
        this.isSMOL = endCheck != null;
    }

    private void initialize(BasisFunctionReader r, String bondData) {
        this.r = r;
        r.moData.put("isNormalized", Boolean.TRUE);
        r.moData.put("energyUnits", "");
        this.bondData = bondData;
    }

    /*
     * Enabled aggressive block sorting
     */
    int readArchive(String infoLine, boolean haveGeometryLine, int ac0, boolean doAddAtoms) throws Exception {
        this.modelAtomCount = this.setInfo(infoLine);
        this.line = haveGeometryLine ? "GEOMETRY" : "";
        boolean haveMOData = false;
        boolean skipping = false;
        while (this.line != null) {
            block15: {
                if (this.line.equals("GEOMETRY")) {
                    if (!this.isSMOL && !this.r.doGetModel(++this.modelCount, null)) {
                        this.readLine();
                        skipping = true;
                        continue;
                    }
                    skipping = false;
                    this.readAtoms(ac0, doAddAtoms);
                    if (doAddAtoms && this.bondData.length() > 0) {
                        this.addBonds(this.bondData, ac0);
                    }
                } else {
                    if (this.line.indexOf("BASIS") == 0) {
                        if (this.r.doReadMolecularOrbitals) {
                            this.readBasis();
                            break block15;
                        } else {
                            this.r.discardLinesUntilContains("ENERGY");
                            this.line = this.r.line;
                            continue;
                        }
                    }
                    if (this.line.indexOf("WAVEFUNC") == 0 || this.line.indexOf("BETA") == 0) {
                        if (this.r.doReadMolecularOrbitals && !skipping) {
                            this.readMolecularOrbital();
                            haveMOData = true;
                        } else {
                            this.r.discardLinesUntilContains("GEOM");
                            this.line = this.r.line;
                        }
                    } else if (this.line.indexOf("ENERGY") == 0 && !skipping) {
                        this.readEnergy();
                    } else if (this.line.equals("ENDARCHIVE") || this.isSMOL && this.line.indexOf(this.endCheck) == 0) break;
                }
            }
            this.readLine();
        }
        if (haveMOData) {
            this.r.finalizeMOData(this.r.moData);
        }
        return this.ac;
    }

    private void readEnergy() throws Exception {
        String[] tokens = PT.getTokens(this.readLine());
        float value = this.parseFloat(tokens[0]);
        this.r.asc.setCurrentModelInfo("energy", Float.valueOf(value));
        if (this.isSMOL) {
            ((SpartanSmolReader)this.r).setEnergy(value);
        }
        this.r.asc.setAtomSetEnergy(tokens[0], value);
    }

    private int setInfo(String info) throws Exception {
        String[] tokens = PT.getTokens(info);
        if (Logger.debugging) {
            Logger.debug("reading Spartan archive info :" + info);
        }
        this.modelAtomCount = this.parseInt(tokens[0]);
        this.coefCount = this.parseInt(tokens[1]);
        this.shellCount = this.parseInt(tokens[2]);
        this.gaussianCount = this.parseInt(tokens[3]);
        this.moCount = this.parseInt(tokens[6]);
        this.r.calculationType = tokens[9];
        String s = (String)this.r.moData.get("calculationType");
        if (s == null) {
            s = this.r.calculationType;
        } else if (s.indexOf(this.r.calculationType) < 0) {
            s = this.r.calculationType + s;
        }
        this.r.calculationType = s;
        this.r.moData.put("calculationType", this.r.calculationType);
        return this.modelAtomCount;
    }

    private void readAtoms(int ac0, boolean doAddAtoms) throws Exception {
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String[] tokens = PT.getTokens(this.readLine());
            Atom atom = doAddAtoms ? this.r.asc.addNewAtom() : this.r.asc.atoms[ac0 - this.modelAtomCount + i];
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(this.parseInt(tokens[0]));
            this.r.setAtomCoordScaled(atom, tokens, 1, 0.5291772f);
        }
        if (doAddAtoms && Logger.debugging) {
            Logger.debug(this.r.asc.ac + " atoms read");
        }
    }

    void addBonds(String data, int ac0) {
        String[] tokens = PT.getTokens(data);
        int i = this.modelAtomCount;
        while (i < tokens.length) {
            int bondOrder;
            int sourceIndex = this.parseInt(tokens[i++]) - 1 + ac0;
            int targetIndex = this.parseInt(tokens[i++]) - 1 + ac0;
            if ((bondOrder = this.parseInt(tokens[i++])) <= 0) continue;
            this.r.asc.addBond(new Bond(sourceIndex, targetIndex, bondOrder < 4 ? bondOrder : (bondOrder == 5 ? 515 : 1)));
        }
        int bondCount = this.r.asc.bondCount;
        if (Logger.debugging) {
            Logger.debug(bondCount + " bonds read");
        }
    }

    void readBasis() throws Exception {
        boolean isD5F7;
        int i;
        Lst<int[]> shells = new Lst<int[]>();
        float[][] gaussians = AU.newFloat2(this.gaussianCount);
        int[] typeArray = new int[this.gaussianCount];
        for (i = 0; i < this.shellCount; ++i) {
            String[] tokens = PT.getTokens(this.readLine());
            boolean isSpherical = tokens[4].charAt(0) == '1';
            int[] slater = new int[4];
            slater[0] = this.parseInt(tokens[3]) - 1;
            int iBasis = this.parseInt(tokens[0]);
            switch (iBasis) {
                case 0: {
                    iBasis = 0;
                    break;
                }
                case 1: {
                    iBasis = isSpherical ? 1 : 2;
                    break;
                }
                case 2: {
                    iBasis = isSpherical ? 3 : 4;
                    break;
                }
                case 3: {
                    iBasis = isSpherical ? 5 : 6;
                }
            }
            slater[1] = iBasis;
            int gaussianPtr = slater[2] = this.parseInt(tokens[2]) - 1;
            int nGaussians = slater[3] = this.parseInt(tokens[1]);
            for (int j = 0; j < nGaussians; ++j) {
                typeArray[gaussianPtr + j] = iBasis;
            }
            shells.addLast(slater);
        }
        for (i = 0; i < this.gaussianCount; ++i) {
            float alpha = this.parseFloat(this.readLine());
            String[] tokens = PT.getTokens(this.readLine());
            int nData = tokens.length;
            float[] data = new float[nData + 1];
            data[0] = alpha;
            switch (typeArray[i]) {
                case 0: {
                    data[1] = this.parseFloat(tokens[0]);
                    break;
                }
                case 1: {
                    data[1] = this.parseFloat(tokens[1]);
                    break;
                }
                case 2: {
                    data[1] = this.parseFloat(tokens[0]);
                    data[2] = this.parseFloat(tokens[1]);
                    if (data[1] != 0.0f) break;
                    data[1] = data[2];
                    typeArray[i] = 2;
                    break;
                }
                case 3: 
                case 4: {
                    data[1] = this.parseFloat(tokens[2]);
                    break;
                }
                case 5: 
                case 6: {
                    data[1] = this.parseFloat(tokens[3]);
                }
            }
            gaussians[i] = data;
        }
        int nCoeff = 0;
        block29: for (int i2 = 0; i2 < this.shellCount; ++i2) {
            int[] slater = (int[])shells.get(i2);
            switch (typeArray[slater[2]]) {
                case 0: {
                    ++nCoeff;
                    continue block29;
                }
                case 1: {
                    slater[1] = 1;
                    nCoeff += 3;
                    continue block29;
                }
                case 2: {
                    nCoeff += 4;
                    continue block29;
                }
                case 3: {
                    nCoeff += 5;
                    continue block29;
                }
                case 4: {
                    nCoeff += 6;
                    continue block29;
                }
                case 5: {
                    nCoeff += 7;
                    continue block29;
                }
                case 6: {
                    nCoeff += 10;
                }
            }
        }
        boolean bl = isD5F7 = nCoeff < this.coefCount;
        if (isD5F7) {
            block30: for (int i3 = 0; i3 < this.shellCount; ++i3) {
                int[] slater = (int[])shells.get(i3);
                switch (typeArray[i3]) {
                    case 4: {
                        slater[1] = 3;
                        continue block30;
                    }
                    case 6: {
                        slater[1] = 5;
                    }
                }
            }
        }
        this.r.moData.put("shells", shells);
        this.r.moData.put("gaussians", gaussians);
        if (Logger.debugging) {
            Logger.debug(shells.size() + " slater shells read");
            Logger.debug(gaussians.length + " gaussian primitives read");
        }
    }

    void readMolecularOrbital() throws Exception {
        int i;
        int tokenPt = 0;
        this.r.orbitals = new Lst();
        String[] tokens = PT.getTokens("");
        float[] energies = new float[this.moCount];
        float[][] coefficients = new float[this.moCount][this.coefCount];
        for (i = 0; i < this.moCount; ++i) {
            if (tokenPt == tokens.length) {
                tokens = PT.getTokens(this.readLine());
                tokenPt = 0;
            }
            energies[i] = this.parseFloat(tokens[tokenPt++]);
        }
        for (i = 0; i < this.moCount; ++i) {
            for (int j = 0; j < this.coefCount; ++j) {
                if (tokenPt == tokens.length) {
                    tokens = PT.getTokens(this.readLine());
                    tokenPt = 0;
                }
                coefficients[i][j] = this.parseFloat(tokens[tokenPt++]);
            }
        }
        for (i = 0; i < this.moCount; ++i) {
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("energy", Float.valueOf(energies[i]));
            mo.put("coefficients", coefficients[i]);
            this.r.setMO(mo);
        }
        if (Logger.debugging) {
            Logger.debug(this.r.orbitals.size() + " molecular orbitals read");
        }
        this.r.moData.put("mos", this.r.orbitals);
    }

    void readProperties() throws Exception {
        if (Logger.debugging) {
            Logger.debug("Reading PROPARC properties records...");
        }
        while (this.readLine() != null && !this.line.startsWith("ENDPROPARC") && !this.line.startsWith("END Directory Entry ")) {
            if (this.line.startsWith("PROP")) {
                this.readProperty();
                continue;
            }
            if (this.line.startsWith("DIPOLE")) {
                this.readDipole();
                continue;
            }
            if (!this.line.startsWith("VIBFREQ")) continue;
            this.readVibFreqs();
        }
        this.setVibrationsFromProperties();
    }

    void readDipole() throws Exception {
        this.setDipole(PT.getTokens(this.readLine()));
    }

    private void setDipole(String[] tokens) {
        if (tokens.length != 3) {
            return;
        }
        V3 dipole = V3.new3(this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]));
        this.r.asc.setCurrentModelInfo("dipole", dipole);
    }

    private void readProperty() throws Exception {
        String[] tokens = PT.getTokens(this.line);
        if (tokens.length == 0) {
            return;
        }
        boolean isString = tokens[1].startsWith("STRING");
        String keyName = tokens[2];
        boolean isDipole = keyName.equals("DIPOLE_VEC");
        Object value = new Object();
        Lst<Object> vector = new Lst<Object>();
        if (tokens[3].equals("=")) {
            value = isString ? this.getQuotedString(tokens[4].substring(0, 1)) : Float.valueOf(this.parseFloat(tokens[4]));
        } else if (tokens[tokens.length - 1].equals("BEGIN")) {
            int nValues = this.parseInt(tokens[tokens.length - 2]);
            if (nValues == 0) {
                nValues = 1;
            }
            boolean isArray = tokens.length == 6;
            Lst<Float> atomInfo = new Lst<Float>();
            int ipt = 0;
            while (this.readLine() != null && !this.line.substring(0, 3).equals("END")) {
                if (isString) {
                    value = this.getQuotedString("\"");
                    vector.addLast(value);
                    continue;
                }
                String[] tokens2 = PT.getTokens(this.line);
                if (isDipole) {
                    this.setDipole(tokens2);
                }
                int i = 0;
                while (i < tokens2.length) {
                    if (isArray) {
                        atomInfo.addLast(Float.valueOf(this.parseFloat(tokens2[i])));
                        if ((ipt + 1) % nValues == 0) {
                            vector.addLast(atomInfo);
                            atomInfo = new Lst();
                        }
                    } else {
                        value = Float.valueOf(this.parseFloat(tokens2[i]));
                        vector.addLast(value);
                    }
                    ++i;
                    ++ipt;
                }
            }
            value = null;
        } else if (Logger.debugging) {
            Logger.debug(" Skipping property line " + this.line);
        }
        if (value != null) {
            this.r.asc.setInfo(keyName, value);
        }
        if (vector.size() != 0) {
            this.r.asc.setInfo(keyName, vector);
        }
    }

    void readVibFreqs() throws Exception {
        this.readLine();
        String label = "";
        int frequencyCount = this.parseInt(this.line);
        Lst vibrations = new Lst();
        Lst freqs = new Lst();
        if (Logger.debugging) {
            Logger.debug("reading VIBFREQ vibration records: frequencyCount = " + frequencyCount);
        }
        boolean[] ignore = new boolean[frequencyCount];
        for (int i = 0; i < frequencyCount; ++i) {
            int ac0 = this.r.asc.ac;
            boolean bl = ignore[i] = !this.r.doGetVibration(i + 1);
            if (!ignore[i] && this.r.desiredVibrationNumber <= 0) {
                this.r.asc.cloneLastAtomSet();
                this.addBonds(this.bondData, ac0);
            }
            this.readLine();
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            float freq = this.parseFloat(this.line);
            info.put("freq", Float.valueOf(freq));
            if (this.line.length() > 15 && !(label = this.line.substring(15, this.line.length())).equals("???")) {
                info.put("label", label);
            }
            freqs.addLast(info);
            if (ignore[i]) continue;
            this.r.asc.setAtomSetFrequency(null, label, "" + freq, null);
        }
        this.r.asc.setInfo("VibFreqs", freqs);
        int ac = this.r.asc.atomSetAtomCounts[0];
        Lst vib = new Lst();
        Lst<Float> vibatom = new Lst<Float>();
        int ifreq = 0;
        int iatom = ac;
        int nValues = 3;
        float[] atomInfo = new float[3];
        while (this.readLine() != null) {
            String[] tokens2 = PT.getTokens(this.line);
            for (int i = 0; i < tokens2.length; ++i) {
                float f;
                atomInfo[i % nValues] = f = this.parseFloat(tokens2[i]);
                vibatom.addLast(Float.valueOf(f));
                if ((i + 1) % nValues != 0) continue;
                if (!ignore[ifreq]) {
                    this.r.asc.addVibrationVector(iatom, atomInfo[0], atomInfo[1], atomInfo[2]);
                    vib.addLast(vibatom);
                    vibatom = new Lst();
                }
                ++iatom;
            }
            if (iatom % ac != 0) continue;
            if (!ignore[ifreq]) {
                vibrations.addLast(vib);
            }
            vib = new Lst();
            if (++ifreq != frequencyCount) continue;
            break;
        }
        this.r.asc.setInfo("vibration", vibrations);
    }

    private void setVibrationsFromProperties() throws Exception {
        int ac;
        Float v;
        Lst freq_modes = (Lst)this.r.asc.atomSetInfo.get("FREQ_MODES");
        if (freq_modes == null) {
            return;
        }
        Lst freq_lab = (Lst)this.r.asc.atomSetInfo.get("FREQ_LAB");
        Lst freq_val = (Lst)this.r.asc.atomSetInfo.get("FREQ_VAL");
        int frequencyCount = freq_val.size();
        Lst vibrations = new Lst();
        Lst freqs = new Lst();
        if (Logger.debugging) {
            Logger.debug("reading PROP VALUE:VIB FREQ_MODE vibration records: frequencyCount = " + frequencyCount);
        }
        for (int i = 0; i < frequencyCount; ++i) {
            int ac0 = this.r.asc.ac;
            this.r.asc.cloneLastAtomSet();
            this.addBonds(this.bondData, ac0);
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            v = (Float)freq_val.get(i);
            info.put("freq", v);
            float freq = v.floatValue();
            String label = (String)freq_lab.get(i);
            if (!label.equals("???")) {
                info.put("label", label);
            }
            freqs.addLast(info);
            this.r.asc.setAtomSetName(label + " " + freq + " cm^-1");
            this.r.asc.setAtomSetModelProperty("Frequency", freq + " cm^-1");
            this.r.asc.setAtomSetModelProperty(".PATH", "Frequencies");
        }
        this.r.asc.setInfo("VibFreqs", freqs);
        int iatom = ac = this.r.asc.atomSetAtomCounts[0];
        for (int i = 0; i < frequencyCount; ++i) {
            if (!this.r.doGetVibration(i + 1)) continue;
            int ipt = 0;
            Lst vib = new Lst();
            Lst mode = (Lst)freq_modes.get(i);
            int ia = 0;
            while (ia < ac) {
                Lst<Float> vibatom = new Lst<Float>();
                v = (Float)mode.get(ipt++);
                float vx = v.floatValue();
                vibatom.addLast(v);
                v = (Float)mode.get(ipt++);
                float vy = v.floatValue();
                vibatom.addLast(v);
                v = (Float)mode.get(ipt++);
                float vz = v.floatValue();
                vibatom.addLast(v);
                this.r.asc.addVibrationVector(iatom, vx, vy, vz);
                vib.addLast(vibatom);
                ++ia;
                ++iatom;
            }
            vibrations.addLast(vib);
        }
        this.r.asc.setInfo("vibration", vibrations);
    }

    private String getQuotedString(String strQuote) {
        int i = this.line.indexOf(strQuote);
        int j = this.line.lastIndexOf(strQuote);
        return j == i ? "" : this.line.substring(i + 1, j);
    }

    private int parseInt(String info) {
        return this.r.parseIntStr(info);
    }

    private float parseFloat(String info) {
        return this.r.parseFloatStr(info);
    }

    private String readLine() throws Exception {
        this.line = this.r.rd();
        return this.line;
    }
}

