/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.tools.spi.MouseClickEventListener;
import org.gephi.tools.spi.NodeClickEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.gephi.ui.tools.plugin.EdgePencilPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EdgePencil
implements Tool {
    private ToolEventListener[] listeners;
    private EdgePencilPanel edgePencilPanel;
    private Color color = Color.BLACK;
    private float weight = 1.0f;
    private Node sourceNode;

    public EdgePencil() {
        ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                EdgePencil.this.updatePanel();
            }

            public void select(Workspace workspace) {
                EdgePencil.this.updatePanel();
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
            }
        });
    }

    private void updatePanel() {
        if (this.edgePencilPanel != null) {
            GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
            if (gc.getGraphModel() != null) {
                this.edgePencilPanel.setType(gc.getGraphModel().isDirected() || gc.getGraphModel().isMixed());
            }
            this.sourceNode = null;
            this.edgePencilPanel.setStatus(NbBundle.getMessage(EdgePencil.class, (String)"EdgePencil.status1"));
        }
    }

    public void select() {
    }

    public void unselect() {
        this.listeners = null;
        this.sourceNode = null;
        this.color = this.edgePencilPanel.getColor();
        this.weight = this.edgePencilPanel.getWeight();
    }

    public ToolEventListener[] getListeners() {
        this.listeners = new ToolEventListener[2];
        this.listeners[0] = new NodeClickEventListener(){

            public void clickNodes(Node[] nodes) {
                Node n = nodes[0];
                if (EdgePencil.this.sourceNode == null) {
                    EdgePencil.this.sourceNode = n;
                    EdgePencil.this.edgePencilPanel.setStatus(NbBundle.getMessage(EdgePencil.class, (String)"EdgePencil.status2"));
                } else {
                    EdgePencil.this.color = EdgePencil.this.edgePencilPanel.getColor();
                    EdgePencil.this.weight = EdgePencil.this.edgePencilPanel.getWeight();
                    boolean directed = ((EdgePencil)EdgePencil.this).edgePencilPanel.isDirected;
                    Edge edge = ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).createEdge(EdgePencil.this.sourceNode, n, directed);
                    edge.setColor(EdgePencil.this.color);
                    EdgePencil.this.sourceNode = null;
                    EdgePencil.this.edgePencilPanel.setStatus(NbBundle.getMessage(EdgePencil.class, (String)"EdgePencil.status1"));
                }
            }
        };
        this.listeners[1] = new MouseClickEventListener(){

            public void mouseClick(int[] positionViewport, float[] position3d) {
                if (EdgePencil.this.sourceNode != null) {
                    EdgePencil.this.edgePencilPanel.setStatus(NbBundle.getMessage(EdgePencil.class, (String)"EdgePencil.status1"));
                    EdgePencil.this.sourceNode = null;
                }
            }
        };
        return this.listeners;
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                EdgePencil.this.edgePencilPanel = new EdgePencilPanel();
                EdgePencil.this.edgePencilPanel.setColor(EdgePencil.this.color);
                EdgePencil.this.edgePencilPanel.setWeight(EdgePencil.this.weight);
                EdgePencil.this.updatePanel();
                return EdgePencil.this.edgePencilPanel;
            }

            public String getName() {
                return NbBundle.getMessage(EdgePencil.class, (String)"EdgePencil.name");
            }

            public Icon getIcon() {
                return new ImageIcon(this.getClass().getResource("/org/gephi/tools/plugin/resources/edgepencil.png"));
            }

            public String getDescription() {
                return NbBundle.getMessage(EdgePencil.class, (String)"EdgePencil.description");
            }

            public int getPosition() {
                return 130;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.SELECTION;
    }
}

