/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters;

import java.awt.BorderLayout;
import java.util.Properties;
import org.gephi.desktop.filters.FilterUIModel;
import org.gephi.desktop.filters.FiltersPanel;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="FiltersTopComponent", iconBase="org/gephi/desktop/filters/resources/small.png", persistenceType=0)
public final class FiltersTopComponent
extends TopComponent {
    private static FiltersTopComponent instance;
    static final String ICON_PATH = "org/gephi/desktop/filters/resources/small.png";
    private static final String PREFERRED_ID = "FiltersTopComponent";
    private final FiltersPanel panel;
    private FilterModel filterModel;
    private FilterUIModel uiModel;

    public FiltersTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(FiltersTopComponent.class, (String)"CTL_FiltersTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.panel = new FiltersPanel();
        this.add(this.panel, "Center");
        FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                workspace.add((Object)new FilterUIModel(workspace));
            }

            public void select(Workspace workspace) {
                FiltersTopComponent.this.filterModel = (FilterModel)workspace.getLookup().lookup(FilterModel.class);
                FiltersTopComponent.this.uiModel = (FilterUIModel)workspace.getLookup().lookup(FilterUIModel.class);
                if (FiltersTopComponent.this.uiModel == null) {
                    FiltersTopComponent.this.uiModel = new FilterUIModel(workspace);
                    workspace.add((Object)FiltersTopComponent.this.uiModel);
                }
                FiltersTopComponent.this.refreshModel();
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                FiltersTopComponent.this.filterModel = null;
                FiltersTopComponent.this.uiModel = null;
                FiltersTopComponent.this.refreshModel();
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            Workspace workspace = pc.getCurrentWorkspace();
            this.filterModel = (FilterModel)workspace.getLookup().lookup(FilterModel.class);
            this.uiModel = (FilterUIModel)workspace.getLookup().lookup(FilterUIModel.class);
            if (this.uiModel == null) {
                this.uiModel = new FilterUIModel(workspace);
                workspace.add((Object)this.uiModel);
            }
        }
        this.refreshModel();
    }

    private void refreshModel() {
        this.panel.refreshModel(this.filterModel, this.uiModel);
    }

    public FilterUIModel getUiModel() {
        return this.uiModel;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

