/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.util.HashMap;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class EigenvectorCentrality
implements Statistics,
LongTask {
    public static final String EIGENVECTOR = "eigencentrality";
    private int numRuns = 100;
    private double[] centralities;
    private double sumChange;
    private ProgressTicket progress;
    private boolean isCanceled;
    private boolean isDirected;

    public EigenvectorCentrality() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    public void setNumRuns(int numRuns) {
        this.numRuns = numRuns;
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public void execute(GraphModel graphModel) {
        this.isDirected = graphModel.isDirected();
        this.isCanceled = false;
        Object graph = this.isDirected ? graphModel.getDirectedGraphVisible() : graphModel.getUndirectedGraphVisible();
        this.execute((Graph)graph);
    }

    public void execute(Graph hgraph) {
        Column column = this.initializeAttributeColunms(hgraph.getModel());
        int N = hgraph.getNodeCount();
        hgraph.readLock();
        this.centralities = new double[N];
        Progress.start((ProgressTicket)this.progress, (int)this.numRuns);
        HashMap<Integer, Node> indicies = new HashMap<Integer, Node>();
        HashMap<Node, Integer> invIndicies = new HashMap<Node, Integer>();
        this.fillIndiciesMaps(hgraph, this.centralities, indicies, invIndicies);
        this.sumChange = this.calculateEigenvectorCentrality(hgraph, this.centralities, indicies, invIndicies, this.isDirected, this.numRuns);
        this.saveCalculatedValues(hgraph, column, indicies, this.centralities);
        hgraph.readUnlock();
        Progress.finish((ProgressTicket)this.progress);
    }

    private Column initializeAttributeColunms(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        Column eigenCol = nodeTable.getColumn(EIGENVECTOR);
        if (eigenCol == null) {
            eigenCol = nodeTable.addColumn(EIGENVECTOR, "Eigenvector Centrality", Double.class, (Object)new Double(0.0));
        }
        return eigenCol;
    }

    private void saveCalculatedValues(Graph hgraph, Column attributeColumn, HashMap<Integer, Node> indicies, double[] eigCenrtalities) {
        int N = hgraph.getNodeCount();
        for (int i = 0; i < N; ++i) {
            Node s = indicies.get(i);
            s.setAttribute(attributeColumn, (Object)eigCenrtalities[i]);
        }
    }

    public void fillIndiciesMaps(Graph hgraph, double[] eigCentralities, HashMap<Integer, Node> indicies, HashMap<Node, Integer> invIndicies) {
        if (indicies == null || invIndicies == null) {
            return;
        }
        int count = 0;
        for (Node u : hgraph.getNodes()) {
            indicies.put(count, u);
            invIndicies.put(u, count);
            eigCentralities[count] = 1.0;
            ++count;
        }
    }

    private double computeMaxValueAndTempValues(Graph hgraph, HashMap<Integer, Node> indicies, HashMap<Node, Integer> invIndicies, double[] tempValues, double[] centralityValues, boolean directed) {
        double max = 0.0;
        int N = hgraph.getNodeCount();
        for (int i = 0; i < N; ++i) {
            Node u = indicies.get(i);
            EdgeIterable iter = null;
            iter = directed ? ((DirectedGraph)hgraph).getInEdges(u) : hgraph.getEdges(u);
            for (Edge e : iter) {
                Node v = hgraph.getOpposite(u, e);
                Integer id = invIndicies.get(v);
                int n = i;
                tempValues[n] = tempValues[n] + centralityValues[id];
            }
            max = Math.max(max, tempValues[i]);
            if (!this.isCanceled) continue;
            return max;
        }
        return max;
    }

    private double updateValues(Graph hgraph, double[] tempValues, double[] centralityValues, double max) {
        double sumChanged = 0.0;
        int N = hgraph.getNodeCount();
        for (int k = 0; k < N; ++k) {
            if (max != 0.0) {
                sumChanged += Math.abs(centralityValues[k] - tempValues[k] / max);
                centralityValues[k] = tempValues[k] / max;
            } else {
                centralityValues[k] = 0.0;
            }
            if (!this.isCanceled) continue;
            return sumChanged;
        }
        return sumChanged;
    }

    public double calculateEigenvectorCentrality(Graph hgraph, double[] eigCentralities, HashMap<Integer, Node> indicies, HashMap<Node, Integer> invIndicies, boolean directed, int numIterations) {
        int N = hgraph.getNodeCount();
        double sumChanged = 0.0;
        double[] tmp = new double[N];
        for (int s = 0; s < numIterations; ++s) {
            double max = this.computeMaxValueAndTempValues(hgraph, indicies, invIndicies, tmp, eigCentralities, directed);
            sumChanged = this.updateValues(hgraph, tmp, eigCentralities, max);
            if (this.isCanceled) {
                return sumChanged;
            }
            Progress.progress((ProgressTicket)this.progress);
        }
        return sumChanged;
    }

    public String getReport() {
        HashMap<Double, Integer> dist = new HashMap<Double, Integer>();
        for (int i = 0; i < this.centralities.length; ++i) {
            Double d = this.centralities[i];
            if (dist.containsKey(d)) {
                Integer v = (Integer)dist.get(d);
                dist.put(d, v + 1);
                continue;
            }
            dist.put(d, 1);
        }
        XYSeries dSeries = ChartUtils.createXYSeries(dist, "Eigenvector Centralities");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createScatterPlot((String)"Eigenvector Centrality Distribution", (String)"Score", (String)"Count", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, true);
        String imageFile = ChartUtils.renderChart(chart, "eigenvector-centralities.png");
        String report = "<HTML> <BODY> <h1>Eigenvector Centrality Report</h1> <hr><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br>" + "Number of iterations: " + this.numRuns + "<br>" + "Sum change: " + this.sumChange + "<br> <h2> Results: </h2>" + imageFile + "</BODY></HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

