/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.AttributeColumnPropertyEditor;
import org.gephi.filters.FilterModelImpl;
import org.gephi.filters.FilterProcessor;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.OperatorQueryImpl;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.ElementFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;
import org.openide.util.Lookup;

public class FilterModelPersistenceProvider
implements WorkspaceXMLPersistenceProvider {
    private int queryId = 0;

    public void writeXML(XMLStreamWriter writer, Workspace workspace) {
        FilterModelImpl filterModel = (FilterModelImpl)workspace.getLookup().lookup(FilterModelImpl.class);
        if (filterModel != null) {
            try {
                this.writeXML(writer, filterModel);
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) {
        FilterModelImpl filterModel = (FilterModelImpl)workspace.getLookup().lookup(FilterModelImpl.class);
        if (filterModel == null) {
            filterModel = new FilterModelImpl(workspace);
            workspace.add((Object)filterModel);
        }
        try {
            this.readXML(reader, filterModel);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getIdentifier() {
        return "filtermodel";
    }

    public void writeXML(XMLStreamWriter writer, FilterModelImpl model) throws XMLStreamException {
        writer.writeStartElement("autorefresh");
        writer.writeAttribute("value", String.valueOf(model.isAutoRefresh()));
        writer.writeEndElement();
        writer.writeStartElement("queries");
        this.queryId = 0;
        for (Query query : model.getQueries()) {
            this.writeQuery("query", writer, model, query, -1);
        }
        writer.writeEndElement();
        writer.writeStartElement("savedqueries");
        for (Query query : model.getLibrary().getLookup().lookupAll(Query.class)) {
            this.writeQuery("savedquery", writer, model, query, -1);
        }
        writer.writeEndElement();
    }

    private void writeQuery(String code, XMLStreamWriter writer, FilterModelImpl model, Query query, int parentId) throws XMLStreamException {
        writer.writeStartElement(code);
        int id = this.queryId++;
        writer.writeAttribute("id", String.valueOf(id));
        if (parentId != -1) {
            writer.writeAttribute("parent", String.valueOf(parentId));
        }
        Filter filter = query.getFilter();
        FilterBuilder builder = model.getLibrary().getBuilder(filter);
        writer.writeAttribute("builder", builder.getClass().getName());
        writer.writeAttribute("filter", filter.getClass().getName());
        for (int i = 0; i < query.getPropertiesCount(); ++i) {
            FilterProperty prop = query.getFilter().getProperties()[i];
            this.writeParameter(writer, i, prop);
        }
        writer.writeEndElement();
        for (Query child : query.getChildren()) {
            this.writeQuery(code, writer, model, child, id);
        }
    }

    private void writeParameter(XMLStreamWriter writer, int index, FilterProperty property) {
        try {
            PropertyEditor editor = property.getPropertyEditor();
            if (editor == null) {
                editor = PropertyEditorManager.findEditor(property.getValueType());
            }
            if (editor == null) {
                return;
            }
            Object val = property.getValue();
            editor.setValue(val);
            writer.writeStartElement("parameter");
            writer.writeAttribute("index", String.valueOf(index));
            writer.writeCharacters(editor.getAsText());
            writer.writeEndElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readXML(XMLStreamReader reader, FilterModelImpl model) throws XMLStreamException {
        HashMap<Integer, Query> idMap = new HashMap<Integer, Query>();
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                Query parentQuery;
                int parentId;
                Query query;
                String parent;
                String id;
                String name = reader.getLocalName();
                if ("autorefresh".equalsIgnoreCase(name)) {
                    String val = reader.getAttributeValue(null, "value");
                    model.setAutoRefresh(Boolean.parseBoolean(val));
                    continue;
                }
                if ("query".equalsIgnoreCase(name)) {
                    id = reader.getAttributeValue(null, "id");
                    parent = reader.getAttributeValue(null, "parent");
                    query = this.readQuery(reader, model);
                    if (query == null) continue;
                    idMap.put(Integer.parseInt(id), query);
                    if (parent != null) {
                        parentId = Integer.parseInt(parent);
                        parentQuery = (Query)idMap.get(parentId);
                        if (parentQuery == null) continue;
                        model.setSubQuery(parentQuery, query);
                        continue;
                    }
                    model.addFirst(query);
                    continue;
                }
                if (!"savedquery".equalsIgnoreCase(name)) continue;
                id = reader.getAttributeValue(null, "id");
                parent = reader.getAttributeValue(null, "parent");
                query = this.readQuery(reader, model);
                if (query == null) continue;
                idMap.put(Integer.parseInt(id), query);
                if (parent != null) {
                    parentId = Integer.parseInt(parent);
                    parentQuery = (Query)idMap.get(parentId);
                    if (parentQuery == null) continue;
                    AbstractQueryImpl impl = (AbstractQueryImpl)parentQuery;
                    impl.addSubQuery(query);
                    continue;
                }
                model.getLibrary().saveQuery(query);
                continue;
            }
            if (!eventType.equals(2) || !"filtermodel".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
        Graph graph = model.getGraphModel().getGraph();
        for (Query rootQuery : model.getQueries()) {
            for (Query q : rootQuery.getDescendantsAndSelf()) {
                Filter filter = q.getFilter();
                if (!(filter instanceof NodeFilter) && !(filter instanceof EdgeFilter) && !(filter instanceof ElementFilter)) continue;
                FilterProcessor filterProcessor = new FilterProcessor();
                filterProcessor.init(filter, graph);
            }
        }
    }

    private Query readQuery(XMLStreamReader reader, FilterModelImpl model) throws XMLStreamException {
        String builderClassName = reader.getAttributeValue(null, "builder");
        String filterClassName = reader.getAttributeValue(null, "filter");
        FilterBuilder builder = null;
        for (FilterBuilder fb : model.getLibrary().getLookup().lookupAll(FilterBuilder.class)) {
            if (!fb.getClass().getName().equals(builderClassName)) continue;
            if (filterClassName != null) {
                if (!fb.getFilter(model.getWorkspace()).getClass().getName().equals(filterClassName)) continue;
                builder = fb;
                break;
            }
            builder = fb;
            break;
        }
        if (builder == null) {
            block3: for (CategoryBuilder catBuilder : Lookup.getDefault().lookupAll(CategoryBuilder.class)) {
                for (FilterBuilder fb : catBuilder.getBuilders(model.getWorkspace())) {
                    if (!fb.getClass().getName().equals(builderClassName)) continue;
                    if (filterClassName != null) {
                        if (!fb.getFilter(model.getWorkspace()).getClass().getName().equals(filterClassName)) continue;
                        builder = fb;
                        continue block3;
                    }
                    builder = fb;
                    continue block3;
                }
            }
        }
        if (builder != null) {
            Filter filter = builder.getFilter(model.getWorkspace());
            AbstractQueryImpl query = filter instanceof Operator ? new OperatorQueryImpl((Operator)filter) : new FilterQueryImpl(builder, filter);
            FilterProperty property = null;
            boolean end = false;
            while (reader.hasNext() && !end) {
                Integer eventType = reader.next();
                if (eventType.equals(1)) {
                    String name = reader.getLocalName();
                    if (!"parameter".equalsIgnoreCase(name)) continue;
                    int index = Integer.parseInt(reader.getAttributeValue(null, "index"));
                    property = query.getFilter().getProperties()[index];
                    continue;
                }
                if (eventType.equals(4) && property != null) {
                    try {
                        PropertyEditor editor = property.getPropertyEditor();
                        if (editor == null) {
                            editor = PropertyEditorManager.findEditor(property.getValueType());
                        }
                        if (editor == null) continue;
                        String textValue = reader.getText();
                        if (editor instanceof AttributeColumnPropertyEditor) {
                            GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
                            GraphModel graphModel = gc.getGraphModel(model.getWorkspace());
                            ((AttributeColumnPropertyEditor)editor).setGraphModel(graphModel);
                        }
                        editor.setAsText(textValue);
                        property.setValue(editor.getValue());
                        model.updateParameters(query);
                        if (!(editor instanceof AttributeColumnPropertyEditor)) continue;
                        ((AttributeColumnPropertyEditor)editor).setGraphModel(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!eventType.equals(2)) continue;
                property = null;
                if (!"query".equalsIgnoreCase(reader.getLocalName())) continue;
                end = true;
            }
            return query;
        }
        return null;
    }
}

