/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.util.ArrayList;
import java.util.Comparator;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.OperatorQueryImpl;
import org.gephi.filters.api.Range;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.ElementFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;

public class FilterProcessor {
    public Graph process(AbstractQueryImpl query, GraphModel graphModel) {
        graphModel.getGraph().writeLock();
        ArrayList<GraphView> views = new ArrayList<GraphView>();
        query = this.simplifyQuery(query);
        AbstractQueryImpl[] tree = this.getTree(query, true);
        for (int i = 0; i < tree.length; ++i) {
            Operator op;
            OperatorQueryImpl operatorQuery;
            AbstractQueryImpl q = tree[tree.length - i - 1];
            Graph[] input = new Graph[]{};
            if (q.getChildrenCount() > 0) {
                input = new Graph[q.getChildrenCount()];
                for (int j = 0; j < input.length; ++j) {
                    input[j] = q.getChildAt(j).getResult();
                }
            } else {
                GraphView newView = graphModel.copyView(graphModel.getGraph().getView());
                views.add(newView);
                input = new Graph[]{graphModel.getGraph(newView)};
            }
            if (q instanceof OperatorQueryImpl && !((OperatorQueryImpl)q).isSimple()) {
                operatorQuery = (OperatorQueryImpl)q;
                op = (Operator)operatorQuery.getFilter();
                Subgraph[] inputSG = new Subgraph[input.length];
                for (int j = 0; j < inputSG.length; ++j) {
                    inputSG[j] = (Subgraph)input[j];
                }
                q.setResult(op.filter(inputSG));
                continue;
            }
            if (q instanceof OperatorQueryImpl && ((OperatorQueryImpl)q).isSimple()) {
                operatorQuery = (OperatorQueryImpl)q;
                op = (Operator)operatorQuery.getFilter();
                GraphView newView = graphModel.copyView(graphModel.getGraph().getView());
                views.add(newView);
                Subgraph newGraph = graphModel.getGraph(newView);
                ArrayList<Filter> filters = new ArrayList<Filter>();
                for (int k = 0; k < operatorQuery.getChildrenCount(); ++k) {
                    Filter filter = operatorQuery.getChildAt(k).getFilter();
                    if (!this.init(filter, (Graph)newGraph)) continue;
                    filters.add(filter);
                }
                q.setResult(op.filter((Graph)newGraph, filters.toArray(new Filter[0])));
                continue;
            }
            FilterQueryImpl filterQuery = (FilterQueryImpl)q;
            Filter filter = filterQuery.getFilter();
            if (filter instanceof NodeFilter && filter instanceof EdgeFilter) {
                this.processNodeFilter((NodeFilter)filter, input[0]);
                this.processEdgeFilter((EdgeFilter)filter, input[0]);
                q.setResult(input[0]);
                continue;
            }
            if (filter instanceof NodeFilter) {
                this.processNodeFilter((NodeFilter)filter, input[0]);
                q.setResult(input[0]);
                continue;
            }
            if (filter instanceof EdgeFilter) {
                this.processEdgeFilter((EdgeFilter)filter, input[0]);
                q.setResult(input[0]);
                continue;
            }
            if (filter instanceof ComplexFilter) {
                ComplexFilter cf = (ComplexFilter)filter;
                q.setResult(cf.filter(input[0]));
                continue;
            }
            q.setResult(input[0]);
        }
        Graph finalResult = tree[0].result;
        GraphView finalView = finalResult.getView();
        for (GraphView v : views) {
            if (v == finalView || v.isMainView()) continue;
            graphModel.destroyView(v);
        }
        graphModel.getGraph().writeUnlock();
        return finalResult;
    }

    private void processNodeFilter(NodeFilter nodeFilter, Graph graph) {
        if (this.init((Filter)nodeFilter, graph)) {
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            for (Node n : graph.getNodes()) {
                if (nodeFilter.evaluate(graph, (Element)n)) continue;
                nodesToRemove.add(n);
            }
            if (!nodesToRemove.isEmpty()) {
                graph.removeAllNodes(nodesToRemove);
            }
            nodeFilter.finish();
        }
    }

    private void processEdgeFilter(EdgeFilter edgeFilter, Graph graph) {
        if (this.init((Filter)edgeFilter, graph)) {
            ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
            for (Edge e : graph.getEdges()) {
                if (edgeFilter.evaluate(graph, (Element)e)) continue;
                edgesToRemove.add(e);
            }
            if (!edgesToRemove.isEmpty()) {
                graph.removeAllEdges(edgesToRemove);
            }
            edgeFilter.finish();
        }
    }

    private AbstractQueryImpl simplifyQuery(AbstractQueryImpl query) {
        AbstractQueryImpl copy = query.copy();
        for (AbstractQueryImpl q : this.getTree(copy, false)) {
            if (!(q instanceof OperatorQueryImpl) || q.getChildrenCount() <= 0) continue;
            boolean canSimplify = true;
            for (AbstractQueryImpl child : q.children) {
                if (child.getChildrenCount() <= 0 && (child.getFilter() instanceof NodeFilter || child.getFilter() instanceof EdgeFilter || child.getFilter() instanceof ElementFilter)) continue;
                canSimplify = false;
            }
            if (!canSimplify) continue;
            ((OperatorQueryImpl)q).setSimple(true);
        }
        return copy;
    }

    private AbstractQueryImpl[] getTree(AbstractQueryImpl query, boolean ignoreSimple) {
        ArrayList<AbstractQueryImpl> tree = new ArrayList<AbstractQueryImpl>();
        int pointer = 0;
        tree.add(query);
        while (pointer < tree.size()) {
            AbstractQueryImpl q = (AbstractQueryImpl)tree.get(pointer++);
            if (q.children.size() <= 0 || q instanceof OperatorQueryImpl && ((OperatorQueryImpl)q).isSimple()) continue;
            tree.addAll(q.children);
        }
        return tree.toArray(new AbstractQueryImpl[0]);
    }

    public boolean init(Filter filter, Graph graph) {
        boolean res = true;
        if (filter instanceof NodeFilter) {
            res = ((NodeFilter)filter).init(graph);
        } else if (filter instanceof EdgeFilter) {
            res = ((EdgeFilter)filter).init(graph);
        }
        if (filter instanceof RangeFilter) {
            RangeFilter rangeFilter = (RangeFilter)filter;
            Number[] values = rangeFilter.getValues(graph);
            NumberComparator comparator = new NumberComparator();
            Number min = null;
            Number max = null;
            if (values != null) {
                for (Number n : values) {
                    min = min == null ? (Number)n : (Number)comparator.min(min, n);
                    max = max == null ? (Number)n : (Number)comparator.max(max, n);
                }
            }
            Range previousRange = (Range)rangeFilter.getRangeProperty().getValue();
            if (min == null || max == null) {
                Object newRange = null;
                rangeFilter.getRangeProperty().setValue(newRange);
            } else if (previousRange == null) {
                Range newRange = new Range(min, max, min, max, values);
                rangeFilter.getRangeProperty().setValue((Object)newRange);
            } else if (previousRange != null && (previousRange.getMinimum() == null || previousRange.getMaximum() == null)) {
                Range newRange = new Range(previousRange.getLowerBound(), previousRange.getUpperBound(), min, max, previousRange.isLeftInclusive(), previousRange.isRightInclusive(), values);
                rangeFilter.getRangeProperty().setValue((Object)newRange);
            } else {
                Range newRange;
                boolean stickyLeft = previousRange.getMinimum().equals(previousRange.getLowerBound());
                boolean stickyRight = previousRange.getMaximum().equals(previousRange.getUpperBound());
                Number lowerBound = previousRange.getLowerBound();
                Number upperBound = previousRange.getUpperBound();
                if (stickyRight && comparator.superior(max, upperBound)) {
                    upperBound = max;
                }
                if (stickyLeft && comparator.inferior(min, lowerBound)) {
                    lowerBound = min;
                }
                if (comparator.superior(upperBound, max)) {
                    upperBound = max;
                }
                if (comparator.inferior(lowerBound, min)) {
                    lowerBound = min;
                }
                if (!(newRange = new Range(lowerBound, upperBound, min, max, previousRange.isLeftInclusive(), previousRange.isRightInclusive(), values)).equals((Object)previousRange)) {
                    rangeFilter.getRangeProperty().setValue((Object)newRange);
                }
            }
        }
        return res;
    }

    private static class NumberComparator
    implements Comparator<Number> {
        private NumberComparator() {
        }

        public boolean superior(Number a, Number b) {
            return this.compare(a, b) > 0;
        }

        public boolean inferior(Number a, Number b) {
            return this.compare(a, b) < 0;
        }

        public Number min(Number a, Number b) {
            int c = this.compare(a, b);
            return c < 0 ? (Number)a : (Number)b;
        }

        public Number max(Number a, Number b) {
            int c = this.compare(a, b);
            return c > 0 ? (Number)a : (Number)b;
        }

        @Override
        public int compare(Number number1, Number number2) {
            if (number2.getClass().equals(number1.getClass()) && number1 instanceof Comparable) {
                return ((Comparable)((Object)number1)).compareTo(number2);
            }
            if (number1.doubleValue() < number2.doubleValue()) {
                return -1;
            }
            if (number1.doubleValue() > number2.doubleValue()) {
                return 1;
            }
            return 0;
        }
    }
}

