/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import org.gephi.appearance.RankingImpl;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Index;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.types.TimeMap;

public class AttributeRankingImpl
extends RankingImpl {
    protected final Index index;
    protected final Column column;
    protected final Graph graph;

    public AttributeRankingImpl(Column column, Index index) {
        this.column = column;
        this.index = index;
        this.graph = null;
    }

    public AttributeRankingImpl(Column column, Graph graph) {
        this.column = column;
        this.graph = graph;
        this.index = null;
    }

    @Override
    protected void refresh() {
        if (this.index != null) {
            this.min = this.index.getMinValue(this.column);
            this.max = this.index.getMaxValue(this.column);
        } else {
            NodeIterable iterable = AttributeUtils.isNodeColumn((Column)this.column) ? this.graph.getNodes() : this.graph.getEdges();
            double minN = Double.POSITIVE_INFINITY;
            double maxN = Double.NEGATIVE_INFINITY;
            for (Element el : iterable) {
                if (this.column.isDynamic()) {
                    TimeMap timeMap = (TimeMap)el.getAttribute(this.column);
                    if (timeMap == null) continue;
                    Number numMin = (Number)timeMap.get(this.graph.getView().getTimeInterval(), Estimator.MIN);
                    Number numMax = (Number)timeMap.get(this.graph.getView().getTimeInterval(), Estimator.MAX);
                    if (numMin.doubleValue() < minN) {
                        this.min = numMin;
                    }
                    if (!(numMax.doubleValue() > maxN)) continue;
                    this.max = numMax;
                    continue;
                }
                Number num = (Number)el.getAttribute(this.column);
                if (num.doubleValue() < minN) {
                    this.min = num;
                }
                if (!(num.doubleValue() > maxN)) continue;
                this.max = num;
            }
        }
    }

    @Override
    public Number getValue(Element element, Graph gr) {
        if (this.graph != null) {
            return (Number)element.getAttribute(this.column, gr.getView());
        }
        return (Number)element.getAttribute(this.column);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.column != null ? this.column.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeRankingImpl other = (AttributeRankingImpl)obj;
        return this.column == other.column || this.column != null && this.column.equals(other.column);
    }
}

