/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab;

import java.util.HashSet;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnObserver;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphObserver;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.TableDiff;
import org.gephi.graph.api.TableObserver;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

public class DataTablesObservers {
    private final Workspace workspace;
    private final GraphModel graphModel;
    private GraphObserver graphObserver;
    private TableObserver nodesTableObserver;
    private TableObserver edgesTableObserver;
    private final Set<ColumnObserver> columnObservers;

    public DataTablesObservers(Workspace workspace) {
        this.workspace = workspace;
        this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        this.columnObservers = new HashSet<ColumnObserver>();
    }

    public synchronized void initialize() {
        if (this.graphObserver != null) {
            return;
        }
        this.graphObserver = this.graphModel.createGraphObserver(this.graphModel.getGraph(), false);
        this.nodesTableObserver = this.graphModel.getNodeTable().createTableObserver(true);
        this.edgesTableObserver = this.graphModel.getEdgeTable().createTableObserver(true);
        for (Column column : this.graphModel.getNodeTable()) {
            this.createColumnObserver(column);
        }
        for (Column column : this.graphModel.getEdgeTable()) {
            this.createColumnObserver(column);
        }
    }

    public synchronized void destroy() {
        if (this.graphObserver != null) {
            this.graphObserver.destroy();
            this.graphObserver = null;
        }
        if (this.nodesTableObserver != null) {
            this.nodesTableObserver.destroy();
            this.nodesTableObserver = null;
        }
        if (this.edgesTableObserver != null) {
            this.edgesTableObserver.destroy();
            this.edgesTableObserver = null;
        }
        for (ColumnObserver columnObserver : this.columnObservers) {
            columnObserver.destroy();
        }
        this.columnObservers.clear();
    }

    public boolean hasChanges() {
        if (this.graphObserver == null) {
            return false;
        }
        boolean hasChanges = this.graphObserver.hasGraphChanged();
        hasChanges = this.processTableObseverChanges(this.nodesTableObserver) || hasChanges;
        hasChanges = this.processTableObseverChanges(this.edgesTableObserver) || hasChanges;
        LatestVisibleView latestVisibleView = (LatestVisibleView)this.workspace.getLookup().lookup(LatestVisibleView.class);
        if (latestVisibleView != null) {
            this.workspace.remove((Object)latestVisibleView);
            if (latestVisibleView.getView().isDestroyed()) {
                hasChanges = true;
            }
        }
        this.workspace.add((Object)new LatestVisibleView(this.graphModel.getVisibleView()));
        if (!hasChanges) {
            for (ColumnObserver columnObserver : this.columnObservers) {
                if (!columnObserver.hasColumnChanged()) continue;
                hasChanges = true;
                break;
            }
        }
        return hasChanges;
    }

    private boolean processTableObseverChanges(TableObserver observer) {
        boolean hasChanges = false;
        if (observer.hasTableChanged()) {
            hasChanges = true;
            TableDiff diff = observer.getDiff();
            for (Column addedColumn : diff.getAddedColumns()) {
                this.createColumnObserver(addedColumn);
            }
            for (Column removedColumn : diff.getRemovedColumns()) {
                for (ColumnObserver columnObserver : this.columnObservers.toArray(new ColumnObserver[0])) {
                    if (columnObserver.getColumn() != removedColumn) continue;
                    columnObserver.destroy();
                    this.columnObservers.remove(columnObserver);
                }
            }
        }
        return hasChanges;
    }

    private void createColumnObserver(Column column) {
        ColumnObserver observer = column.createColumnObserver(false);
        this.columnObservers.add(observer);
    }

    class LatestVisibleView {
        private final GraphView view;

        public LatestVisibleView(GraphView view) {
            this.view = view;
        }

        public GraphView getView() {
            return this.view;
        }
    }
}

