/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Splash
implements Stamps.Updater {
    private static Splash splash;
    private static final boolean noBar;
    private static final String ICON_16 = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_32 = "org/netbeans/core/startup/frame32.gif";
    private static final String ICON_48 = "org/netbeans/core/startup/frame48.gif";
    private Frame frame;
    private SplashPainter painter;
    private SplashComponent comp;
    private SplashScreen splashScreen;

    public static Splash getInstance() {
        if (splash == null) {
            splash = new Splash();
        }
        return splash;
    }

    public static void showAboutDialog(Frame parent, JComponent info) {
        Splash.createAboutDialog(parent, info).setVisible(true);
    }

    private static JDialog createAboutDialog(Frame parent, JComponent info) {
        SplashDialog splashDialog = new SplashDialog(parent, info);
        return splashDialog;
    }

    private void initFrameIcons(Frame f) {
        f.setIconImages(Arrays.asList(ImageUtilities.loadImage((String)ICON_16, (boolean)true), ImageUtilities.loadImage((String)ICON_32, (boolean)true), ImageUtilities.loadImage((String)ICON_48, (boolean)true)));
    }

    private Splash() {
        Stamps s = Stamps.getModulesJARs();
        if (!CLIOptions.isNoSplash() && !GraphicsEnvironment.isHeadless()) {
            if (!s.exists("splash.png")) {
                s.scheduleSave((Stamps.Updater)this, "splash.png", false);
            }
            try {
                this.splashScreen = SplashScreen.getSplashScreen();
                if (this.splashScreen != null) {
                    Graphics2D graphics = this.splashScreen.createGraphics();
                    this.painter = new SplashPainter(graphics, null, false);
                }
            }
            catch (RuntimeException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
            if (this.painter == null) {
                this.comp = new SplashComponent(false);
                this.painter = this.comp.painter;
            }
        }
    }

    final int getMaxSteps() {
        return this.painter.maxSteps;
    }

    final int getProgress() {
        return this.painter.progress;
    }

    public void setRunning(boolean running) {
        if (CLIOptions.isNoSplash()) {
            return;
        }
        if (this.comp == null) {
            return;
        }
        if (running) {
            if (this.frame == null) {
                this.frame = new Frame(NbBundle.getMessage(Splash.class, (String)"LBL_splash_window_title"));
                this.frame.setType(Window.Type.POPUP);
                this.initFrameIcons(this.frame);
                this.frame.setUndecorated(true);
                this.frame.setLayout(new BorderLayout());
                this.frame.add((Component)this.comp, "Center");
                this.frame.setResizable(false);
                int width = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_WIDTH"));
                int height = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_HEIGHT"));
                this.frame.setPreferredSize(new Dimension(width, height));
                SwingUtilities.invokeLater(new SplashRunner(this.frame, true));
            }
        } else {
            SwingUtilities.invokeLater(new SplashRunner(this.frame, false));
        }
    }

    public void dispose() {
        this.setRunning(false);
        splash = null;
    }

    public void increment(int steps) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.painter != null) {
            this.painter.increment(steps);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void print(String s) {
        if (CLIOptions.isNoSplash() || this.painter == null) {
            return;
        }
        this.painter.setText(s);
    }

    public void addToMaxSteps(int steps) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.painter != null) {
            this.painter.addToMaxSteps(steps);
        }
    }

    static void center(Window c) {
        c.pack();
        c.setBounds(Utilities.findCenterBounds((Dimension)c.getSize()));
    }

    public static Image loadContent(boolean about) {
        Image img;
        if (about && (img = ImageUtilities.loadImage((String)"org/netbeans/core/startup/about.png", (boolean)true)) != null) {
            return img;
        }
        return ImageUtilities.loadImage((String)"org/netbeans/core/startup/splash.gif", (boolean)true);
    }

    public void flushCaches(DataOutputStream os) throws IOException {
        ImageIO.write((RenderedImage)((BufferedImage)Splash.loadContent(false)), "png", os);
    }

    public void cacheReady() {
    }

    static {
        noBar = Boolean.getBoolean("netbeans.splash.nobar") || !Boolean.parseBoolean(NbBundle.getMessage(Splash.class, (String)"SplashShowProgressBar"));
    }

    private static class SplashComponent
    extends JComponent
    implements Accessible {
        final SplashPainter painter;

        public SplashComponent(boolean about) {
            this.painter = new SplashPainter((Graphics2D)this.getGraphics(), this, about);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics graphics) {
            this.painter.graphics = graphics;
            this.painter.paint();
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public String toString() {
            return "SplashComponent - progress: " + this.painter.progress + "/" + this.painter.maxSteps + " text: " + this.painter.text;
        }
    }

    private static class SplashDialog
    extends JDialog
    implements ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new SplashComponent(true);

        public SplashDialog(Frame parent, JComponent infoPanel) {
            super(parent, true);
            JPanel splashPanel = new JPanel();
            JTabbedPane tabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"));
            splashPanel.add(this.splashComponent);
            tabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"), splashPanel);
            tabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Detail"), infoPanel);
            this.getContentPane().add((Component)tabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 1);
            tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Splash.class, (String)"ACSN_AboutTabs"));
            tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutDialog"));
            Splash.center(this);
            this.setDefaultCloseOperation(2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SplashPainter {
        Rectangle view;
        Color color_text;
        Color color_bar;
        Color color_edge;
        Color color_corner;
        private int size = 12;
        private Rectangle dirty = new Rectangle();
        private Rectangle rect = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 0;
        private int barStart = 0;
        private int barLength = 0;
        private Image image;
        private String text;
        private FontMetrics fm;
        private Graphics graphics;
        private final JComponent comp;
        private final boolean about;
        long next;

        public SplashPainter(Graphics graphics, JComponent comp, boolean about) {
            this.graphics = graphics;
            this.comp = comp;
            this.about = about;
        }

        final void init() throws MissingResourceException, NumberFormatException {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.maxSteps > 0) {
                return;
            }
            this.maxSteps = 140;
            ResourceBundle bundle = NbBundle.getBundle(Splash.class);
            StringTokenizer st = new StringTokenizer(bundle.getString("SplashRunningTextBounds"), " ,");
            this.view = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            st = new StringTokenizer(bundle.getString("SplashProgressBarBounds"), " ,");
            try {
                this.bar = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                Integer rgb = Integer.decode(bundle.getString("SplashRunningTextColor"));
                this.color_text = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarColor"));
                this.color_bar = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarEdgeColor"));
                this.color_edge = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarCornerColor"));
                this.color_corner = new Color(rgb);
            }
            catch (NumberFormatException nfe) {
                Util.err.warning("Number format exception loading splash screen parameters.");
                Logger.getLogger("global").log(Level.WARNING, null, nfe);
                this.color_text = Color.BLACK;
                this.color_bar = Color.ORANGE;
                this.color_edge = Color.BLUE;
                this.color_corner = Color.GREEN;
                this.bar = new Rectangle(0, 0, 80, 10);
            }
            try {
                String sizeStr = bundle.getString("SplashRunningTextFontSize");
                this.size = Integer.parseInt(sizeStr);
            }
            catch (MissingResourceException e) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.image = Splash.loadContent(this.about);
            Font font = new Font(bundle.getString("SplashRunningTextFontType"), 0, this.size);
            if (this.comp != null) {
                this.comp.setFont(font);
                this.fm = this.comp.getFontMetrics(font);
            } else {
                this.graphics.setFont(font);
                this.fm = this.graphics.getFontMetrics(font);
            }
        }

        final void repaint(Rectangle r) {
            if (this.comp != null) {
                this.comp.repaint(r);
            } else if (this.next < System.currentTimeMillis()) {
                this.paint();
                try {
                    Splash s = splash;
                    if (s != null) {
                        s.splashScreen.update();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.next = System.currentTimeMillis() + 200L;
            }
        }

        public void setText(final String text) {
            if (text != null && text.equals(this.text)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SplashPainter.this.init();
                    if (text == null) {
                        SplashPainter.this.repaint(SplashPainter.this.dirty);
                        return;
                    }
                    if (SplashPainter.this.fm == null) {
                        return;
                    }
                    SplashPainter.this.adjustText(text);
                    SwingUtilities.layoutCompoundLabel(SplashPainter.this.fm, text, null, 3, 2, 3, 2, SplashPainter.this.view, new Rectangle(), SplashPainter.this.rect, 0);
                    SplashPainter.this.dirty = SplashPainter.this.dirty.union(SplashPainter.this.rect);
                    SplashPainter.this.repaint(SplashPainter.this.dirty);
                    SplashPainter.this.dirty = new Rectangle(SplashPainter.this.rect);
                }
            });
        }

        private void adjustText(String text) {
            String newText = null;
            if (text == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            int width = this.fm.stringWidth(text);
            if (width > this.view.width) {
                String newString;
                StringTokenizer st = new StringTokenizer(text);
                while (st.hasMoreTokens()) {
                    String element = st.nextToken();
                    newString = newText == null ? element : newText + " " + element;
                    if (this.fm.stringWidth(newString + "...") > this.view.width) {
                        this.text = newText + "...";
                        break;
                    }
                    newText = newString;
                }
                if (newText == null) {
                    this.text = "";
                    newString = "";
                    newText = "";
                    for (int i = 0; i < text.length(); ++i) {
                        if (this.fm.stringWidth((newString = newString + text.charAt(i)) + "...") > this.view.width) {
                            this.text = newText + "...";
                            break;
                        }
                        newText = newString;
                    }
                }
            } else {
                this.text = text;
            }
        }

        public void increment(int steps) {
            int bl;
            if (steps <= 0) {
                return;
            }
            this.progress += steps;
            if (this.progress > this.maxSteps) {
                this.progress = this.maxSteps;
            } else if (this.maxSteps > 0 && ((bl = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                this.barLength = bl;
                this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SplashPainter.this.init();
                        SplashPainter.this.repaint(SplashPainter.this.bar_inc);
                    }
                });
            }
        }

        final void addToMaxSteps(int steps) {
            if (steps == 0) {
                return;
            }
            if (this.maxSteps == 0) {
                int prog = this.progress / steps;
                this.maxSteps = steps;
                this.progress = prog;
            } else {
                int max = this.maxSteps + steps;
                int prog = this.progress * max / this.maxSteps;
                this.maxSteps = max;
                this.progress = prog;
            }
        }

        void paint() {
            this.graphics.setColor(this.color_text);
            this.graphics.drawImage(this.image, 0, 0, null);
            if (this.text != null) {
                if (this.fm == null) {
                    return;
                }
                SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, this.view, new Rectangle(), this.rect, 0);
                Graphics2D g2d = (Graphics2D)this.graphics;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                this.graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
            }
            if (!noBar && this.maxSteps > 0) {
                this.graphics.setColor(this.color_bar);
                this.graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                this.graphics.setColor(this.color_corner);
                this.graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                this.graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                this.graphics.setColor(this.color_edge);
                this.graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                this.graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }
    }

    private static class SplashRunner
    implements Runnable {
        private Window splashWindow;
        private boolean visible;

        public SplashRunner(Window splashWindow, boolean visible) {
            this.splashWindow = splashWindow;
            this.visible = visible;
        }

        @Override
        public void run() {
            if (this.visible) {
                Splash.center(this.splashWindow);
                this.splashWindow.setVisible(true);
                this.splashWindow.toFront();
            } else {
                this.splashWindow.setVisible(false);
                this.splashWindow.dispose();
            }
        }
    }
}

