/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.builders;

import java.awt.Color;
import java.util.ArrayList;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TextProperties;
import org.gephi.preview.api.Item;
import org.gephi.preview.plugin.items.NodeLabelItem;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.visualization.api.VisualizationController;
import org.openide.util.Lookup;

public class NodeLabelBuilder
implements ItemBuilder {
    public Item[] getItems(Graph graph) {
        boolean useTextData = false;
        for (Node n : graph.getNodes()) {
            TextProperties textData = n.getTextProperties();
            if (textData == null || textData.getText() == null || textData.getText().isEmpty()) continue;
            useTextData = true;
        }
        VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        Column[] nodeColumns = vizController != null ? vizController.getNodeTextColumns() : null;
        ArrayList<NodeLabelItem> items = new ArrayList<NodeLabelItem>();
        for (Node n : graph.getNodes()) {
            NodeLabelItem labelItem = new NodeLabelItem(n);
            String label = this.getLabel(n, nodeColumns, graph.getView());
            labelItem.setData("label", label);
            TextProperties textData = n.getTextProperties();
            if (textData != null && useTextData) {
                if (textData.getR() != -1.0f) {
                    labelItem.setData("color", new Color((int)(textData.getR() * 255.0f), (int)(textData.getG() * 255.0f), (int)(textData.getB() * 255.0f), (int)(textData.getAlpha() * 255.0f)));
                }
                labelItem.setData("size", Float.valueOf(textData.getSize()));
                labelItem.setData("visible", textData.isVisible());
                labelItem.setData("label", textData.getText());
                if (!textData.isVisible() || label == null || label.isEmpty()) continue;
                items.add(labelItem);
                continue;
            }
            if (label == null || label.isEmpty()) continue;
            items.add(labelItem);
        }
        return items.toArray(new Item[0]);
    }

    private String getLabel(Node n, Column[] cols, GraphView view) {
        String str = "";
        if (cols != null) {
            int i = 0;
            for (Column c : cols) {
                if (i++ > 0) {
                    str = str + " - ";
                }
                Object val = n.getAttribute(c, view);
                str = str + (val != null ? val : "");
            }
        }
        if (str.isEmpty()) {
            str = n.getLabel();
        }
        if (str == null) {
            str = "";
        }
        return str;
    }

    public String getType() {
        return "node_label";
    }
}

