

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:SkyTraq Venus based loggers (download) (skytraq){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">SkyTraq Venus based loggers (download) (skytraq)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_skyforce.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_skytraq-bin.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_skytraq"></a>SkyTraq Venus based loggers (download) (skytraq)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read tracks
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_erase" title="erase option">erase</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_targetlocation" title="targetlocation option">targetlocation</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_configlog" title="configlog option">configlog</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_baud" title="baud option">baud</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_initbaud" title="initbaud option">initbaud</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_read-at-once" title="read-at-once option">read-at-once</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_first-sector" title="first-sector option">first-sector</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_last-sector" title="last-sector option">last-sector</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_dump-file" title="dump-file option">dump-file</a>, <a class="link" href="fmt_skytraq.html#fmt_skytraq_o_no-output" title="no-output option">no-output</a> .</p><p>Serial download protocol for GPS data loggers based on Skytraq Venus 5 and Venus 6 chipsets.
This chipset is used by a number of devices from different manufacturers.
If your logger came with the Windows software iTravelTech GPS Photo Tagger, chances are that you can
use this format to read its memory.</p><p>Following a list of devices which should be supported by this module
(Note that not all of them have actually been tested, so if you can confirm that additional models work, please mail the gpsbabel-misc group with your success, tips, and any pertinent links for your model.):</p><div class="table"><a id="skytraq_devices"></a><p class="title"><strong>Table 3.7. Devices supported by skytraq module</strong></p><div class="table-contents"><table class="table" summary="Devices supported by skytraq module" border="1"><colgroup><col /><col /><col /><col /></colgroup><thead><tr><th>Manufacturer</th><th>Model</th><th>USB (baud)</th><th>Bluetooth (baud)</th></tr></thead><tbody><tr><td>SJA</td><td>"3-in-1" GPS logger</td><td>up to 230400</td><td>9600</td></tr><tr><td>Navilock</td><td>BT-455PDL</td><td>untested</td><td>untested</td></tr><tr><td>Polaris</td><td>Travel Honey</td><td>up to 230400</td><td>9600</td></tr><tr><td>Pearl Diffusion</td><td>Keymate STV-5</td><td>untested</td><td>untested</td></tr><tr><td>Canmore</td><td>GT-730FL-S</td><td>untested</td><td>n/a</td></tr><tr><td>Canmore</td><td>GT-750F</td><td>untested</td><td>untested</td></tr><tr><td>Gisteq</td><td>DPL900</td><td>up to 230400</td><td>untested</td></tr><tr><td>Adapt Mobile</td><td>Keychain Pro</td><td>untested</td><td>untested</td></tr><tr><td>Adapt Mobile </td><td>Keychain Pro</td><td>9600</td><td>9600</td></tr></tbody></table></div></div><br class="table-break" /><p>Windows users of GPSBabel version 1.5.2 or less may have to explicitly specifiy a bit rate of 115200 or lower.</p><div class="example"><a id="skytraq-on-linux"></a><p class="title"><strong>Example 3.32. Command showing skytraq download of tracks and erasing the logger on Linux</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i skytraq,erase -f /dev/ttyUSB0 -o gpx -F out.gpx</code></strong></p></div></div><br class="example-break" /><div class="example"><a id="skytraq-erase"></a><p class="title"><strong>Example 3.33. Command showing skytraq erasing the logger without download on Linux</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i skytraq,erase,no-output -f /dev/ttyUSB0</code></strong></p></div></div><br class="example-break" /><p>If available, reading the logger using bluetooth should also work. However, many devices support only one
specific baud rate over bluetooth, e.g. 9600. In that case you should use the option <strong class="userinput"><code>baud=0</code></strong>
to tell GPSBabel to use that default baud rate:</p><div class="example"><a id="skytraq-on-linux-bt"></a><p class="title"><strong>Example 3.34. Command showing skytraq download tracks via bluetooth on Linux</strong></p><div class="example-contents"><p><strong class="userinput"><code>rfcomm bind 0 &lt;bdaddr&gt;</code></strong></p><p><strong class="userinput"><code>gpsbabel -i skytraq,baud=0 -f /dev/rfcomm0 -o gpx -F out.gpx</code></strong></p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_erase"></a><code class="option">erase</code> option</h3></div></div></div><p>
      Erase device data after download.
    </p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_targetlocation"></a><code class="option">targetlocation</code> option</h3></div></div></div><p>
      Set location finder target location as lat,lng.
    </p><p>
  The device provides a location finder built from eight LEDs and can use
  those LEDs to guide you to a location.  You can set the target location
  with the 'targetlocation' option.  Use ':' as the delimiter between latitude
  and longitude. Note that GPSBabel terminates after writing the location info
  to the device, i.e. no logging data will be read from it.
</p><div class="example"><a id="skytraq-targetlocation"></a><p class="title"><strong>Example 3.35. Set the target location of the Skytraq location finder</strong></p><div class="example-contents"><p>
       <strong class="userinput"><code>gpsbabel -i skytraq,targetlocation=12.34:-56.78 -f /dev/ttyUSB
0 -o unicsv -F -</code></strong>
  </p><p>
       Sets latitude and longitude of the location finder to N12.34 and 
	W56.78 respectively. 
       The arrows on the device will point you to this location as soon as 
	it has a satellite fix.
 </p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_configlog"></a><code class="option">configlog</code> option</h3></div></div></div><p>
      Configure logging parameter as tmin:tmax:dmin:dmax.
    </p><p>
  Set the logging configuration as tmin:tmax:dmin:dmax.
  Here tmin and tmax are in seconds, and dmin and dmax in meters.
  With dt = time since last log, dx = distance since last log,
  and v the current speed, the device logs if
</p><p>
   (dt &gt; tmin and dx &gt;= dmin and v &gt;= vmin) or dt &gt; tmax or dx &gt; dmax or v &gt; vmax
</p><p>
   If you use this option, vmin is fixed at 0 and vmax at 65535 km/h.
</p><p>
   Example. Set the device to log every 6 seconds (or 10km, whichever
   happens first!)
</p><div class="example"><a id="skytraq-configulog"></a><p class="title"><strong>Example 3.36. Set the logging parameters for Skytraq device</strong></p><div class="example-contents"><p>
<strong class="userinput"><code>
   gpsbabel -i skytraq,configlog=6:3600:0:10000 -f /dev/ttyUSB0
</code></strong>
</p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_baud"></a><code class="option">baud</code> option</h3></div></div></div><p>
      Baud rate used for download.
    </p><p>The following baud rates can be used: 4800, 9600, 19200, 38400, 57600, 115200, 230400.
Note that your logger might not support all of them (especially 230400 which isn't documented
in the chipset manual, though there are known devices that are capable of this speed).</p><p>If <strong class="userinput"><code>baud=0</code></strong> (zero) download takes place at the baud rate the
device is currently set to. This is especially useful for Bluetooth connections since they
often don't allow changing the baud rate.</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_initbaud"></a><code class="option">initbaud</code> option</h3></div></div></div><p>
      Baud rate used to init device (0=autodetect).
    </p><p>The "initbaud" option might be helpful if autodetection fails or takes too long. With this option you
can tell GPSBabel the baud rate the device is currently set to. In contrast, the option "baud" specifies
the rate at which the actual download should take place. If it is different than "initbaud" (or the autodetected
rate, if initbaud wasn't given), the initial setting will be restored after finishing the download.</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_read-at-once"></a><code class="option">read-at-once</code> option</h3></div></div></div><p>
      Number of sectors to read at once (0=use single sector mode).
    </p><p>If <strong class="userinput"><code>read-at-once</code></strong> &gt;= 1, batch mode is enabled with that many sectors being read at a time.
A value of zero disables batch mode and switches to single read mode. Not all devices support batch mode; in that case
gpsbabel automatically switches to single read mode.</p><p>Under normal circumstances, the larger this number the faster the transfer.
Reducing <strong class="userinput"><code>read-at-once</code></strong> or even switching to single sector mode might help when you get
transmission errors/aborts.</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_first-sector"></a><code class="option">first-sector</code> option</h3></div></div></div><p>
      First sector to be read from the device.
    </p><p>The logger's memory is organized in sectors, serially numbered starting at 0. Each sector takes 4096 bytes of data.
Typical devices hold about 250 sectors. The memory is always filled from sector 0 on, until it is full or the device being
erased again by the user.</p><p>Normally you can safely omit this option. However, it might be useful to read data from erased devices: we observed
that on erase, only the first two sectors are actually cleared. The following example shows how to read the remaining data:
</p><div class="example"><a id="skytraq-restore-erased"></a><p class="title"><strong>Example 3.37. Command showing how to read data from an erased device</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i skytraq,first-sector=2 -f /dev/ttyUSB0 -o gpx -F out.gpx</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_last-sector"></a><code class="option">last-sector</code> option</h3></div></div></div><p>
      Last sector to be read from the device (-1: smart read everything).
    </p><p>A value of -1 (the default) enables automatic mode, i.e. reading is stopped when an empty sector is
encountered.
We observed that sometimes the device doesn't report the correct number of used sectors, which confuses the Windows
software, so that it might not get all trackpoints.
In contrast, our algorithm ensures that everything is being read (please report if it doesn't work for you).</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_dump-file"></a><code class="option">dump-file</code> option</h3></div></div></div><p>
      Dump raw data to this file.
    </p><p>Writes raw data as it is read from the logger to the file given as this option's argument
(additional to decoding it as usual). The resulting binary files can be read and decoded by the skytraq-bin format.
Mainly useful for debugging/development purposes.</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_skytraq_o_no-output"></a><code class="option">no-output</code> option</h3></div></div></div><p>
      Disable output (useful with erase).
    </p><p>If this option is given, no GPS log data will be read from the device
(unless "dump-file" is given too; in that case only decoding will be disabled).</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_skyforce.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_skytraq-bin.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Skymap / KMD150 ascii files (skyforce) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> SkyTraq Venus based loggers Binary File Format (skytraq-bin)</td></tr></table></div>
  
      {/literal}{/block}
  