/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.gephi.project.api.Workspace;
import org.gephi.project.impl.ProjectControllerImpl;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.impl.ProjectsImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.io.GephiFormatException;
import org.gephi.project.io.GephiReader;
import org.gephi.project.io.PersistenceProviderUtils;
import org.gephi.project.io.Xml10FilterReader;
import org.gephi.project.spi.WorkspaceBytesPersistenceProvider;
import org.gephi.project.spi.WorkspacePersistenceProvider;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.workspace.impl.WorkspaceImpl;
import org.gephi.workspace.impl.WorkspaceInformationImpl;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LoadTask
implements LongTask,
Runnable {
    private final File file;
    private boolean cancel = false;
    private ProgressTicket progressTicket;

    public LoadTask(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Progress.start((ProgressTicket)this.progressTicket);
        Progress.setDisplayName((ProgressTicket)this.progressTicket, (String)NbBundle.getMessage(LoadTask.class, (String)"LoadTask.name"));
        try (ZipFile zip = null;){
            zip = new ZipFile(this.file);
            ProjectImpl project = this.readProject(zip);
            if (project != null) {
                ArrayList<String> workspaceEntries = new ArrayList<String>();
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().matches("Workspace_[0-9]*_xml")) continue;
                    workspaceEntries.add(entry.getName());
                }
                Collection<WorkspacePersistenceProvider> providers = PersistenceProviderUtils.getPersistenceProviders();
                Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)((1 + providers.size()) * workspaceEntries.size()));
                for (String workspaceEntry : workspaceEntries) {
                    WorkspaceImpl workspace = this.readWorkspace(project, workspaceEntry, zip);
                    Progress.progress((ProgressTicket)this.progressTicket);
                    if (workspace != null) {
                        for (WorkspacePersistenceProvider provider : providers) {
                            if (provider instanceof WorkspaceXMLPersistenceProvider) {
                                this.readWorkspaceChildrenXML((WorkspaceXMLPersistenceProvider)provider, workspace, zip);
                            } else if (provider instanceof WorkspaceBytesPersistenceProvider) {
                                this.readWorkspaceChildrenBytes((WorkspaceBytesPersistenceProvider)provider, workspace, zip);
                            }
                            Progress.progress((ProgressTicket)this.progressTicket);
                            if (!this.cancel) continue;
                            break;
                        }
                    }
                    if (!this.cancel) continue;
                    break;
                }
            }
            Progress.switchToIndeterminate((ProgressTicket)this.progressTicket);
            ProjectControllerImpl projectController = (ProjectControllerImpl)Lookup.getDefault().lookup(ProjectControllerImpl.class);
            if (project != null && !this.cancel && !this.cancel) {
                WorkspaceProviderImpl workspaces = (WorkspaceProviderImpl)project.getLookup().lookup(WorkspaceProviderImpl.class);
                for (Workspace workspace : workspaces.getWorkspaces()) {
                    WorkspaceInformationImpl info = (WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class);
                    if (!info.isOpen()) continue;
                    workspaces.setCurrentWorkspace(workspace);
                    break;
                }
                projectController.openProject(project);
            }
        }
        catch (Exception ex) {
            if (ex instanceof GephiFormatException) {
                throw (GephiFormatException)ex;
            }
            throw new GephiFormatException(GephiReader.class, (Throwable)ex);
        }
        Progress.finish((ProgressTicket)this.progressTicket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectImpl readProject(ZipFile zipFile) throws Exception {
        ZipEntry entry = zipFile.getEntry("Project_xml");
        if (entry == null) {
            entry = zipFile.getEntry("Project");
        }
        if (entry != null) {
            try (InputStream is = null;){
                ProjectImpl projectImpl;
                FilterReader filterReader;
                block13: {
                    is = zipFile.getInputStream(entry);
                    InputStreamReader isReader = null;
                    filterReader = null;
                    XMLStreamReader reader = null;
                    try {
                        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                        if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                            inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
                        }
                        inputFactory.setXMLReporter(new XMLReporter(){

                            @Override
                            public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                            }
                        });
                        isReader = new InputStreamReader(is, "UTF-8");
                        filterReader = new Xml10FilterReader(isReader);
                        reader = inputFactory.createXMLStreamReader(filterReader);
                        ProjectControllerImpl projectController = (ProjectControllerImpl)Lookup.getDefault().lookup(ProjectControllerImpl.class);
                        ProjectsImpl projects = projectController.getProjects();
                        ProjectImpl project = GephiReader.readProject(reader, projects);
                        ((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).setFile(this.file);
                        projectImpl = project;
                        if (reader == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            reader.close();
                        }
                        if (filterReader != null) {
                            filterReader.close();
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                if (filterReader != null) {
                    filterReader.close();
                }
                return projectImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkspaceImpl readWorkspace(ProjectImpl project, String entryName, ZipFile zipFile) throws Exception {
        ZipEntry entry = zipFile.getEntry(entryName);
        if (entry != null) {
            try (InputStream is = null;){
                WorkspaceImpl workspaceImpl;
                FilterReader filterReader;
                InputStreamReader isReader;
                block14: {
                    is = zipFile.getInputStream(entry);
                    isReader = null;
                    filterReader = null;
                    XMLStreamReader reader = null;
                    try {
                        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                        if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                            inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
                        }
                        inputFactory.setXMLReporter(new XMLReporter(){

                            @Override
                            public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                            }
                        });
                        isReader = new InputStreamReader(is, "UTF-8");
                        filterReader = new Xml10FilterReader(isReader);
                        reader = inputFactory.createXMLStreamReader(filterReader);
                        workspaceImpl = GephiReader.readWorkspace(reader, project);
                        if (reader == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            reader.close();
                        }
                        if (filterReader != null) {
                            filterReader.close();
                        }
                        if (isReader != null) {
                            isReader.close();
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                if (filterReader != null) {
                    filterReader.close();
                }
                if (isReader != null) {
                    isReader.close();
                }
                return workspaceImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWorkspaceChildrenXML(WorkspaceXMLPersistenceProvider persistenceProvider, Workspace workspace, ZipFile zipFile) throws Exception {
        String identifier = persistenceProvider.getIdentifier();
        ZipEntry entry = zipFile.getEntry("Workspace_" + workspace.getId() + "_" + identifier + "_xml");
        if (entry != null) {
            try (InputStream is = null;){
                is = zipFile.getInputStream(entry);
                InputStreamReader isReader = null;
                FilterReader filterReader = null;
                XMLStreamReader reader = null;
                try {
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                        inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
                    }
                    inputFactory.setXMLReporter(new XMLReporter(){

                        @Override
                        public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                        }
                    });
                    isReader = new InputStreamReader(is, "UTF-8");
                    filterReader = new Xml10FilterReader(isReader);
                    reader = inputFactory.createXMLStreamReader(filterReader);
                    persistenceProvider.readXML(reader, workspace);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (filterReader != null) {
                        filterReader.close();
                    }
                    if (isReader != null) {
                        isReader.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWorkspaceChildrenBytes(WorkspaceBytesPersistenceProvider persistenceProvider, Workspace workspace, ZipFile zipFile) throws Exception {
        String identifier = persistenceProvider.getIdentifier();
        ZipEntry entry = zipFile.getEntry("Workspace_" + workspace.getId() + "_" + identifier + "_bytes");
        if (entry != null) {
            InputStream is = null;
            FilterInputStream stream = null;
            try {
                is = zipFile.getInputStream(entry);
                stream = new DataInputStream(is);
                persistenceProvider.readBytes((DataInputStream)stream, workspace);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

