/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gephi.appearance.AttributeFunctionImpl;
import org.gephi.appearance.AttributePartitionImpl;
import org.gephi.appearance.AttributeRankingImpl;
import org.gephi.appearance.DegreeRankingImpl;
import org.gephi.appearance.EdgeTypePartitionImpl;
import org.gephi.appearance.EdgeWeightRankingImpl;
import org.gephi.appearance.FunctionImpl;
import org.gephi.appearance.GraphFunctionImpl;
import org.gephi.appearance.InDegreeRankingImpl;
import org.gephi.appearance.OutDegreeRankingImpl;
import org.gephi.appearance.PartitionImpl;
import org.gephi.appearance.RankingImpl;
import org.gephi.appearance.SimpleFunctionImpl;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.AttributeFunction;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.api.Interpolator;
import org.gephi.appearance.api.Partition;
import org.gephi.appearance.spi.PartitionTransformer;
import org.gephi.appearance.spi.RankingTransformer;
import org.gephi.appearance.spi.SimpleTransformer;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnObserver;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphObserver;
import org.gephi.graph.api.Index;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AppearanceModelImpl
implements AppearanceModel {
    private final Workspace workspace;
    private final GraphModel graphModel;
    private final Interpolator defaultInterpolator;
    private boolean localScale = false;
    private final List<Transformer> nodeTransformers;
    private final List<Transformer> edgeTransformers;
    private final Map<Class, TransformerUI> transformerUIs;
    private final Object functionLock;
    private final FunctionsModel functionsMain;
    private final Map<Graph, FunctionsModel> functions = new HashMap<Graph, FunctionsModel>();
    private final Set<String> forcedRanking;
    private final Set<String> forcedPartition;
    private final List<Column> forcedColumnsRefresh;

    public AppearanceModelImpl(Workspace workspace) {
        this.workspace = workspace;
        this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        this.defaultInterpolator = Interpolator.LINEAR;
        this.functionLock = new Object();
        this.transformerUIs = this.initTransformerUIs();
        this.nodeTransformers = this.initNodeTransformers();
        this.edgeTransformers = this.initEdgeTransformers();
        this.forcedPartition = new HashSet<String>();
        this.forcedRanking = new HashSet<String>();
        this.forcedColumnsRefresh = new ArrayList<Column>();
        this.functionsMain = new FunctionsModel(this.graphModel.getGraph());
        this.refreshFunctions(this.graphModel.getGraph());
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public boolean isLocalScale() {
        return this.localScale;
    }

    @Override
    public Function[] getNodeFunctions(Graph graph) {
        return this.refreshFunctions(graph).getNodeFunctions();
    }

    @Override
    public Function[] getEdgeFunctions(Graph graph) {
        return this.refreshFunctions(graph).getEdgeFunctions();
    }

    @Override
    public Function getNodeFunction(Graph graph, Column column, Class<? extends Transformer> transformer) {
        for (Function f : this.refreshFunctions(graph).getNodeFunctions()) {
            if (!f.isAttribute() || !f.getTransformer().getClass().equals(transformer) || !((AttributeFunction)f).getColumn().equals(column)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Function getEdgeFunction(Graph graph, Column column, Class<? extends Transformer> transformer) {
        for (Function f : this.refreshFunctions(graph).getEdgeFunctions()) {
            if (!f.isAttribute() || !f.getTransformer().getClass().equals(transformer) || !((AttributeFunction)f).getColumn().equals(column)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Function getNodeFunction(Graph graph, AppearanceModel.GraphFunction graphFunction, Class<? extends Transformer> transformer) {
        String id = this.getNodeId(transformer, graphFunction);
        for (Function f : this.refreshFunctions(graph).getNodeFunctions()) {
            if (!((FunctionImpl)f).getId().equals(id) || !f.getTransformer().getClass().equals(transformer)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Function getEdgeFunction(Graph graph, AppearanceModel.GraphFunction graphFunction, Class<? extends Transformer> transformer) {
        String id = this.getEdgeId(transformer, graphFunction);
        for (Function f : this.refreshFunctions(graph).getEdgeFunctions()) {
            if (!((FunctionImpl)f).getId().equals(id) || !f.getTransformer().getClass().equals(transformer)) continue;
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition getNodePartition(Graph graph, Column column) {
        Object object = this.functionLock;
        synchronized (object) {
            FunctionsModel m = graph.getView().isMainView() ? this.functionsMain : this.functions.get(graph);
            if (m != null) {
                return m.nodeFunctionsModel.getPartition(column);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition getEdgePartition(Graph graph, Column column) {
        Object object = this.functionLock;
        synchronized (object) {
            FunctionsModel m = graph.getView().isMainView() ? this.functionsMain : this.functions.get(graph);
            if (m != null) {
                return m.edgeFunctionsModel.getPartition(column);
            }
            return null;
        }
    }

    protected void forceRanking(Function function) {
        if (function instanceof AttributeFunction) {
            Column col = ((AttributeFunction)function).getColumn();
            String id = this.getIdCol(col);
            this.forcedColumnsRefresh.add(col);
            this.forcedPartition.remove(id);
            this.forcedRanking.add(id);
        }
    }

    protected void forcePartition(Function function) {
        if (function instanceof AttributeFunction) {
            Column col = ((AttributeFunction)function).getColumn();
            String id = this.getIdCol(col);
            this.forcedColumnsRefresh.add(col);
            this.forcedRanking.remove(id);
            this.forcedPartition.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionsModel refreshFunctions(Graph graph) {
        Object object = this.functionLock;
        synchronized (object) {
            FunctionsModel m;
            if (graph.getView().isMainView()) {
                m = this.functionsMain;
            } else {
                m = this.functions.get(graph);
                if (m == null) {
                    m = new FunctionsModel(graph);
                    this.functions.put(graph, m);
                }
            }
            Iterator<Map.Entry<Graph, FunctionsModel>> it = this.functions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Graph, FunctionsModel> entry = it.next();
                if (!entry.getKey().getView().isDestroyed()) continue;
                it.remove();
            }
            return m;
        }
    }

    protected String getIdCol(Column column) {
        return (AttributeUtils.isNodeColumn((Column)column) ? "node" : "edge") + "_column_" + column.getId();
    }

    protected String getNodeId(Class<? extends Transformer> transformer, AppearanceModel.GraphFunction graphFunction) {
        return "node_" + transformer.getSimpleName() + "_" + graphFunction.getId();
    }

    protected String getEdgeId(Class<? extends Transformer> transformer, AppearanceModel.GraphFunction graphFunction) {
        return "edge_" + transformer.getSimpleName() + "_" + graphFunction.getId();
    }

    private boolean isPartition(Graph graph, Column column) {
        double ratio;
        if (column.isDynamic()) {
            if (!column.isNumber()) {
                return true;
            }
            HashSet<Object> set = new HashSet<Object>();
            boolean hasNullValue = false;
            int elements = 0;
            NodeIterable iterable = AttributeUtils.isNodeColumn((Column)column) ? graph.getNodes() : graph.getEdges();
            for (Element el : iterable) {
                Object[] va;
                TimeMap val = (TimeMap)el.getAttribute(column);
                if (val == null) continue;
                for (Object v : va = val.toValuesArray()) {
                    if (v != null) {
                        set.add(v);
                    } else {
                        hasNullValue = true;
                    }
                    ++elements;
                }
            }
            ratio = (double)set.size() / (double)elements;
        } else if (column.isIndexed()) {
            if (!column.isNumber()) {
                return true;
            }
            Index index = AttributeUtils.isNodeColumn((Column)column) ? this.graphModel.getNodeIndex(graph.getView()) : this.graphModel.getEdgeIndex(graph.getView());
            int valueCount = index.countValues(column);
            int elementCount = index.countElements(column);
            ratio = (double)valueCount / (double)elementCount;
        } else {
            return false;
        }
        Class typeClass = column.getTypeClass();
        Class clazz = typeClass = column.isDynamic() ? AttributeUtils.getStaticType((Class)typeClass) : typeClass;
        if (typeClass.equals(Integer.class) || typeClass.equals(Byte.class) || typeClass.equals(Short.class)) {
            return ratio <= 0.3;
        }
        return ratio <= 0.05;
    }

    private boolean isRanking(Graph graph, Column column) {
        if (column.isDynamic() && column.isNumber()) {
            NodeIterable iterable = AttributeUtils.isNodeColumn((Column)column) ? graph.getNodes() : graph.getEdges();
            for (Element el : iterable) {
                if (el.getAttribute(column, graph.getView()) == null) continue;
                iterable.doBreak();
                return true;
            }
        } else if (!column.isDynamic() && column.isIndexed() && column.isNumber()) {
            Index index;
            if (AttributeUtils.isNodeColumn((Column)column)) {
                index = this.localScale ? this.graphModel.getNodeIndex(graph.getView()) : this.graphModel.getNodeIndex();
            } else {
                Index index2 = index = this.localScale ? this.graphModel.getEdgeIndex(graph.getView()) : this.graphModel.getEdgeIndex();
            }
            if (index.countValues(column) > 0) {
                return true;
            }
        }
        return false;
    }

    public void setLocalScale(boolean localScale) {
        this.localScale = localScale;
    }

    protected GraphModel getGraphModel() {
        return this.graphModel;
    }

    private Map<Class, TransformerUI> initTransformerUIs() {
        HashMap<Class, TransformerUI> uis = new HashMap<Class, TransformerUI>();
        for (TransformerUI ui : Lookup.getDefault().lookupAll(TransformerUI.class)) {
            Class transformerClass = ui.getTransformerClass();
            if (transformerClass == null) {
                throw new NullPointerException("Transformer class can' be null");
            }
            if (uis.containsKey(transformerClass)) {
                throw new RuntimeException("A Transformer can't be attach to multiple TransformerUI");
            }
            uis.put(transformerClass, ui);
        }
        return uis;
    }

    private List<Transformer> initNodeTransformers() {
        ArrayList<Transformer> res = new ArrayList<Transformer>();
        for (Transformer transformer : Lookup.getDefault().lookupAll(Transformer.class)) {
            if (!transformer.isNode()) continue;
            res.add(transformer);
        }
        return res;
    }

    private List<Transformer> initEdgeTransformers() {
        ArrayList<Transformer> res = new ArrayList<Transformer>();
        for (Transformer transformer : Lookup.getDefault().lookupAll(Transformer.class)) {
            if (!transformer.isEdge()) continue;
            res.add(transformer);
        }
        return res;
    }

    private abstract class ElementFunctionsModel<T extends Element> {
        protected final Graph graph;
        protected final GraphObserver graphObserver;
        protected final Map<Column, ColumnObserver> columnObservers;
        protected final Map<String, SimpleFunctionImpl> simpleFunctions;
        protected final Map<String, GraphFunctionImpl> graphFunctions;
        protected final Map<String, AttributeFunctionImpl> attributeFunctions;
        protected final Map<String, PartitionImpl> partitions;
        protected final Map<String, RankingImpl> rankings;

        protected ElementFunctionsModel(Graph graph) {
            this.graph = graph;
            this.simpleFunctions = new HashMap<String, SimpleFunctionImpl>();
            this.graphFunctions = new HashMap<String, GraphFunctionImpl>();
            this.attributeFunctions = new HashMap<String, AttributeFunctionImpl>();
            this.columnObservers = new HashMap<Column, ColumnObserver>();
            this.graphObserver = graph.getModel().createGraphObserver(graph, false);
            this.partitions = new HashMap<String, PartitionImpl>();
            this.rankings = new HashMap<String, RankingImpl>();
            this.initSimpleFunctions();
        }

        public abstract Iterable<T> getElements();

        public abstract Table getTable();

        public abstract Index<T> getIndex(boolean var1);

        public abstract List<Transformer> getTransformers();

        public abstract String getIdPrefix();

        public abstract void refreshGraphFunctions();

        public abstract Class<? extends Element> getElementClass();

        public Partition getPartition(Column column) {
            return this.partitions.get(AppearanceModelImpl.this.getIdCol(column));
        }

        protected void refreshFunctions() {
            boolean graphHasChanged;
            this.graph.readLock();
            boolean bl = graphHasChanged = this.graphObserver.isNew() || this.graphObserver.hasGraphChanged();
            if (graphHasChanged) {
                if (this.graphObserver.isNew()) {
                    this.graphObserver.hasGraphChanged();
                }
                this.refreshGraphFunctions();
            }
            this.refreshAttributeFunctions(graphHasChanged);
            this.graph.readUnlock();
        }

        private void refreshAttributeFunctions(boolean graphHasChanged) {
            String id;
            HashSet<Column> columns = new HashSet<Column>();
            for (Column column : this.getTable()) {
                if (column.isProperty()) continue;
                columns.add(column);
            }
            Iterator<Map.Entry<Column, ColumnObserver>> itr = this.columnObservers.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<Column, ColumnObserver> entry = itr.next();
                if (columns.contains(entry.getKey()) && !AppearanceModelImpl.this.forcedColumnsRefresh.contains(entry.getKey())) continue;
                this.rankings.remove(AppearanceModelImpl.this.getIdCol(entry.getKey()));
                this.partitions.remove(AppearanceModelImpl.this.getIdCol(entry.getKey()));
                for (Transformer t : this.getTransformers()) {
                    this.attributeFunctions.remove(this.getId(t, entry.getKey()));
                }
                itr.remove();
                if (entry.getValue().isDestroyed()) continue;
                entry.getValue().destroy();
            }
            HashSet<Column> toRefreshColumns = new HashSet<Column>(AppearanceModelImpl.this.forcedColumnsRefresh);
            for (Column column : columns) {
                if (!this.columnObservers.containsKey(column)) {
                    this.columnObservers.put(column, column.createColumnObserver(false));
                    toRefreshColumns.add(column);
                    continue;
                }
                if (!this.columnObservers.get(column).hasColumnChanged() && !graphHasChanged) continue;
                toRefreshColumns.add(column);
            }
            AppearanceModelImpl.this.forcedColumnsRefresh.clear();
            for (Column column : toRefreshColumns) {
                RankingImpl ranking = this.rankings.get(AppearanceModelImpl.this.getIdCol(column));
                PartitionImpl partition = this.partitions.get(AppearanceModelImpl.this.getIdCol(column));
                if (ranking == null && partition == null) {
                    String id2 = AppearanceModelImpl.this.getIdCol(column);
                    if (AppearanceModelImpl.this.forcedPartition.contains(id2) || !AppearanceModelImpl.this.forcedRanking.contains(id2) && AppearanceModelImpl.this.isPartition(this.graph, column)) {
                        partition = column.isIndexed() ? new AttributePartitionImpl(column, this.getIndex(false)) : new AttributePartitionImpl(column, this.graph);
                        this.partitions.put(AppearanceModelImpl.this.getIdCol(column), partition);
                    } else if (AppearanceModelImpl.this.forcedRanking.contains(id2) || !AppearanceModelImpl.this.forcedPartition.contains(id2) && AppearanceModelImpl.this.isRanking(this.graph, column)) {
                        ranking = column.isIndexed() ? new AttributeRankingImpl(column, this.getIndex(AppearanceModelImpl.this.localScale)) : new AttributeRankingImpl(column, this.graph);
                        this.rankings.put(AppearanceModelImpl.this.getIdCol(column), ranking);
                    }
                }
                if (ranking != null) {
                    ranking.refresh();
                }
                if (partition == null) continue;
                partition.refresh();
            }
            for (Transformer t : this.getRankingTransformers()) {
                for (Column col : toRefreshColumns) {
                    RankingImpl ranking = this.rankings.get(AppearanceModelImpl.this.getIdCol(col));
                    if (ranking == null || this.attributeFunctions.containsKey(id = this.getId(t, col))) continue;
                    this.attributeFunctions.put(id, new AttributeFunctionImpl(id, this.graph, col, t, this.getTransformerUI(t), ranking, AppearanceModelImpl.this.defaultInterpolator));
                }
            }
            for (Transformer t : this.getPartitionTransformers()) {
                for (Column col : toRefreshColumns) {
                    PartitionImpl partition = this.partitions.get(AppearanceModelImpl.this.getIdCol(col));
                    if (partition == null || this.attributeFunctions.containsKey(id = this.getId(t, col))) continue;
                    this.attributeFunctions.put(id, new AttributeFunctionImpl(id, this.graph, col, t, this.getTransformerUI(t), partition));
                }
            }
        }

        private void initSimpleFunctions() {
            for (Transformer transformer : this.getTransformers()) {
                if (!(transformer instanceof SimpleTransformer)) continue;
                String id = this.getId(transformer, "simple");
                this.simpleFunctions.put(id, new SimpleFunctionImpl(id, this.getElementClass(), this.graph, transformer, this.getTransformerUI(transformer)));
            }
        }

        protected TransformerUI getTransformerUI(Transformer transformer) {
            return (TransformerUI)AppearanceModelImpl.this.transformerUIs.get(transformer.getClass());
        }

        protected List<Transformer> getRankingTransformers() {
            ArrayList<Transformer> res = new ArrayList<Transformer>();
            for (Transformer t : this.getTransformers()) {
                if (!(t instanceof RankingTransformer)) continue;
                res.add(t);
            }
            return res;
        }

        protected List<Transformer> getPartitionTransformers() {
            ArrayList<Transformer> res = new ArrayList<Transformer>();
            for (Transformer t : this.getTransformers()) {
                if (!(t instanceof PartitionTransformer)) continue;
                res.add(t);
            }
            return res;
        }

        protected String getId(Transformer transformer, Column column) {
            return this.getIdPrefix() + "_" + transformer.getClass().getSimpleName() + "_column_" + column.getId();
        }

        protected String getId(Transformer transformer, String suffix) {
            return this.getIdPrefix() + "_" + transformer.getClass().getSimpleName() + "_" + suffix;
        }

        protected String getIdStr(String suffix) {
            return this.getIdPrefix() + "_" + suffix;
        }
    }

    private class FunctionsModel {
        protected final Graph graph;
        protected final NodeFunctionsModel nodeFunctionsModel;
        protected final EdgeFunctionsModel edgeFunctionsModel;

        public FunctionsModel(Graph graph) {
            this.graph = graph;
            this.nodeFunctionsModel = new NodeFunctionsModel(graph);
            this.edgeFunctionsModel = new EdgeFunctionsModel(graph);
        }

        public Function[] getNodeFunctions() {
            return this.getFunctions(this.nodeFunctionsModel).toArray(new Function[0]);
        }

        public Function[] getEdgeFunctions() {
            return this.getFunctions(this.edgeFunctionsModel).toArray(new Function[0]);
        }

        private List<Function> getFunctions(ElementFunctionsModel model) {
            model.refreshFunctions();
            ArrayList<Function> functions = new ArrayList<Function>();
            functions.addAll(model.simpleFunctions.values());
            functions.addAll(model.graphFunctions.values());
            functions.addAll(model.attributeFunctions.values());
            return functions;
        }
    }

    private class EdgeFunctionsModel
    extends ElementFunctionsModel<Edge> {
        public EdgeFunctionsModel(Graph graph) {
            super(graph);
        }

        @Override
        public Iterable<Edge> getElements() {
            return this.graph.getEdges();
        }

        @Override
        public Class<? extends Element> getElementClass() {
            return Edge.class;
        }

        @Override
        public Table getTable() {
            return this.graph.getModel().getEdgeTable();
        }

        @Override
        public Index<Edge> getIndex(boolean localScale) {
            return localScale ? this.graph.getModel().getEdgeIndex(this.graph.getView()) : this.graph.getModel().getEdgeIndex();
        }

        @Override
        public List<Transformer> getTransformers() {
            return AppearanceModelImpl.this.edgeTransformers;
        }

        @Override
        public String getIdPrefix() {
            return "edge";
        }

        @Override
        public void refreshGraphFunctions() {
            String name;
            if (!this.rankings.containsKey(this.getIdStr(AppearanceModel.GraphFunction.EDGE_WEIGHT.getId()))) {
                this.rankings.put(this.getIdStr(AppearanceModel.GraphFunction.EDGE_WEIGHT.getId()), new EdgeWeightRankingImpl(this.graph));
            }
            if (this.graph.getModel().isMultiGraph()) {
                if (!this.partitions.containsKey(this.getIdStr(AppearanceModel.GraphFunction.EDGE_TYPE.getId()))) {
                    this.partitions.put(this.getIdStr(AppearanceModel.GraphFunction.EDGE_TYPE.getId()), new EdgeTypePartitionImpl(this.graph));
                }
            } else {
                this.partitions.remove(this.getIdStr(AppearanceModel.GraphFunction.EDGE_TYPE.getId()));
            }
            for (Transformer t : this.getRankingTransformers()) {
                String weightId = this.getId(t, AppearanceModel.GraphFunction.EDGE_WEIGHT.getId());
                RankingImpl ranking = (RankingImpl)this.rankings.get(this.getIdStr(AppearanceModel.GraphFunction.EDGE_WEIGHT.getId()));
                if (!this.graphFunctions.containsKey(weightId)) {
                    name = NbBundle.getMessage(AppearanceModelImpl.class, (String)"EdgeGraphFunction.Weight.name");
                    this.graphFunctions.put(weightId, new GraphFunctionImpl(weightId, name, Edge.class, this.graph, t, this.getTransformerUI(t), ranking, AppearanceModelImpl.this.defaultInterpolator));
                }
                ranking.refresh();
            }
            for (Transformer t : this.getPartitionTransformers()) {
                String typeId = this.getId(t, AppearanceModel.GraphFunction.EDGE_TYPE.getId());
                PartitionImpl partition = (PartitionImpl)this.partitions.get(this.getIdStr(AppearanceModel.GraphFunction.EDGE_TYPE.getId()));
                if (partition != null) {
                    if (!this.graphFunctions.containsKey(typeId)) {
                        name = NbBundle.getMessage(AppearanceModelImpl.class, (String)"EdgeGraphFunction.Type.name");
                        this.graphFunctions.put(typeId, new GraphFunctionImpl(typeId, name, Edge.class, this.graph, t, this.getTransformerUI(t), partition));
                    }
                    partition.refresh();
                    continue;
                }
                this.graphFunctions.remove(typeId);
            }
        }
    }

    private class NodeFunctionsModel
    extends ElementFunctionsModel<Node> {
        public NodeFunctionsModel(Graph graph) {
            super(graph);
        }

        @Override
        public Class<? extends Element> getElementClass() {
            return Node.class;
        }

        @Override
        public Iterable<Node> getElements() {
            return this.graph.getNodes();
        }

        @Override
        public Table getTable() {
            return this.graph.getModel().getNodeTable();
        }

        @Override
        public Index<Node> getIndex(boolean localScale) {
            return localScale ? this.graph.getModel().getNodeIndex(this.graph.getView()) : this.graph.getModel().getNodeIndex();
        }

        @Override
        public List<Transformer> getTransformers() {
            return AppearanceModelImpl.this.nodeTransformers;
        }

        @Override
        public String getIdPrefix() {
            return "node";
        }

        @Override
        public void refreshGraphFunctions() {
            if (!this.rankings.containsKey(this.getIdStr(AppearanceModel.GraphFunction.NODE_DEGREE.getId()))) {
                this.rankings.put(this.getIdStr(AppearanceModel.GraphFunction.NODE_DEGREE.getId()), new DegreeRankingImpl(this.graph));
            }
            if (this.graph.isDirected()) {
                if (!this.rankings.containsKey(this.getIdStr(AppearanceModel.GraphFunction.NODE_INDEGREE.getId()))) {
                    DirectedGraph directedGraph = (DirectedGraph)this.graph;
                    this.rankings.put(this.getIdStr(AppearanceModel.GraphFunction.NODE_INDEGREE.getId()), new InDegreeRankingImpl(directedGraph));
                    this.rankings.put(this.getIdStr(AppearanceModel.GraphFunction.NODE_OUTDEGREE.getId()), new OutDegreeRankingImpl(directedGraph));
                }
            } else {
                this.rankings.remove(this.getIdStr(AppearanceModel.GraphFunction.NODE_INDEGREE.getId()));
                this.rankings.remove(this.getIdStr(AppearanceModel.GraphFunction.NODE_OUTDEGREE.getId()));
            }
            for (Transformer t : this.getRankingTransformers()) {
                String degreeId = this.getId(t, AppearanceModel.GraphFunction.NODE_DEGREE.getId());
                RankingImpl degreeRanking = (RankingImpl)this.rankings.get(this.getIdStr(AppearanceModel.GraphFunction.NODE_DEGREE.getId()));
                if (!this.graphFunctions.containsKey(degreeId)) {
                    String name = NbBundle.getMessage(AppearanceModelImpl.class, (String)"NodeGraphFunction.Degree.name");
                    this.graphFunctions.put(degreeId, new GraphFunctionImpl(degreeId, name, Node.class, this.graph, t, this.getTransformerUI(t), degreeRanking, AppearanceModelImpl.this.defaultInterpolator));
                }
                degreeRanking.refresh();
                String indegreeId = this.getId(t, AppearanceModel.GraphFunction.NODE_INDEGREE.getId());
                String outdegreeId = this.getId(t, AppearanceModel.GraphFunction.NODE_OUTDEGREE.getId());
                RankingImpl indegreeRanking = (RankingImpl)this.rankings.get(this.getIdStr(AppearanceModel.GraphFunction.NODE_INDEGREE.getId()));
                RankingImpl outdegreeRanking = (RankingImpl)this.rankings.get(this.getIdStr(AppearanceModel.GraphFunction.NODE_OUTDEGREE.getId()));
                if (indegreeRanking != null && outdegreeRanking != null) {
                    if (!this.graphFunctions.containsKey(indegreeId)) {
                        String inDegreeName = NbBundle.getMessage(AppearanceModelImpl.class, (String)"NodeGraphFunction.InDegree.name");
                        String outDegreeName = NbBundle.getMessage(AppearanceModelImpl.class, (String)"NodeGraphFunction.OutDegree.name");
                        this.graphFunctions.put(indegreeId, new GraphFunctionImpl(indegreeId, inDegreeName, Node.class, this.graph, t, this.getTransformerUI(t), indegreeRanking, AppearanceModelImpl.this.defaultInterpolator));
                        this.graphFunctions.put(outdegreeId, new GraphFunctionImpl(outdegreeId, outDegreeName, Node.class, this.graph, t, this.getTransformerUI(t), outdegreeRanking, AppearanceModelImpl.this.defaultInterpolator));
                    }
                    indegreeRanking.refresh();
                    outdegreeRanking.refresh();
                    continue;
                }
                this.graphFunctions.remove(indegreeId);
                this.graphFunctions.remove(outdegreeId);
            }
        }
    }
}

