/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.tools;

import java.math.BigInteger;
import java.util.Arrays;

public class TestMultiplierXorShift32 {
    public static final int INT_PHI = -1640531527;
    public static final long LONG_PHI = -7046029254386353131L;
    private static long state = System.nanoTime();

    private static long staffordMix13(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    public static long nextLong() {
        return TestMultiplierXorShift32.staffordMix13(state += -7046029254386353131L);
    }

    public static void main(String[] args) {
        int multiplier = new BigInteger(args[0]).intValue();
        int shift = Integer.parseInt(args[1]);
        int[] count = new int[32];
        Arrays.fill(count, 0);
        long n = 1L;
        while (true) {
            int b;
            int x = (int)TestMultiplierXorShift32.nextLong();
            int mapped = multiplier * x ^ multiplier * x >>> shift;
            int flippedBitMask = 1;
            int f = 32;
            while (f-- != 0) {
                int t = multiplier * (x ^ flippedBitMask);
                int flippedMapped = mapped ^ t ^ t >>> shift;
                int bitMask = Integer.MIN_VALUE;
                b = 32;
                while (b-- != 0) {
                    if ((bitMask & flippedMapped) != 0) {
                        int n2 = b;
                        count[n2] = count[n2] + 1;
                    }
                    bitMask >>>= 1;
                }
                flippedBitMask <<= 1;
            }
            if ((n & 0xFFFFFL) == 0L) {
                double chiSquared = 0.0;
                double maxBias = 0.0;
                for (b = 2; b < 32; ++b) {
                    double d = Math.abs(0.5 - (double)count[b] / (32.0 * (double)n));
                    chiSquared += d * d;
                    maxBias = Math.max(maxBias, d / 0.5);
                }
                System.out.println("maxBias=" + maxBias + ", chiSquared=" + 2.0 * chiSquared);
            }
            ++n;
        }
    }
}

