/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import net.java.dev.colorchooser.ColorChooserUI;
import net.java.dev.colorchooser.DefaultColorChooserUI;
import net.java.dev.colorchooser.NamedColor;
import net.java.dev.colorchooser.Palette;
import net.java.dev.colorchooser.PredefinedPalette;
import net.java.dev.colorchooser.RecentColors;

public final class ColorChooser
extends JComponent {
    public static final String UI_CLASS_ID = "nbColorChooserUI";
    private transient Palette[] palettes = null;
    private Color color = Color.BLUE;
    private transient Color transientColor = null;
    private transient List actionListenerList;
    public static final String PROP_COLOR = "color";
    public static final String PROP_TRANSIENT_COLOR = "transientColor";
    public static final String PROP_CONTINUOUS_PALETTE = "continuousPalette";
    public static final String PROP_PICKER_VISIBLE = "pickerVisible";
    private boolean continuousPalette = true;
    static /* synthetic */ Class class$java$awt$Color;

    public ColorChooser() {
        this((Color)null);
    }

    public ColorChooser(Color initialColor) {
        this(null, initialColor);
    }

    public ColorChooser(Palette[] palettes, Color initialColor) {
        this.setPalettes(palettes);
        if (initialColor != null) {
            this.color = initialColor;
        }
        this.updateUI();
    }

    public ColorChooser(Palette[] palettes) {
        this(palettes, null);
    }

    public String getUIClassId() {
        return UI_CLASS_ID;
    }

    public void updateUI() {
        if (UIManager.get(UI_CLASS_ID) != null) {
            this.setUI((ColorChooserUI)UIManager.getUI(this));
        } else {
            this.setUI(DefaultColorChooserUI.createUI(this));
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        if (c.getClass() != (class$java$awt$Color == null ? (class$java$awt$Color = ColorChooser.class$("java.awt.Color")) : class$java$awt$Color)) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }
        if (this.color != null && !this.color.equals(c) || this.color == null && c != null) {
            Color old = this.color;
            this.color = c;
            this.repaint();
            this.firePropertyChange(PROP_COLOR, old, c);
        }
    }

    void setTransientColor(Color c) {
        Color old = this.transientColor;
        this.transientColor = c;
        if (c != null && !this.color.equals(old) || old == null && c != null) {
            this.firePropertyChange(PROP_TRANSIENT_COLOR, old, this.getTransientColor());
            this.repaint();
        } else if (c == null) {
            this.firePropertyChange(PROP_TRANSIENT_COLOR, old, this.getColor());
            this.repaint();
        }
    }

    public Color getTransientColor() {
        return this.transientColor == null ? null : new Color(this.transientColor.getRed(), this.transientColor.getGreen(), this.transientColor.getBlue());
    }

    public static String colorToString(Color c) {
        RecentColors.getDefault();
        NamedColor named = RecentColors.findNamedColor(c);
        if (named == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(c.getRed());
            sb.append(',');
            sb.append(c.getGreen());
            sb.append(',');
            sb.append(c.getBlue());
            return sb.toString();
        }
        return named.getDisplayName();
    }

    Color transientColor() {
        return this.transientColor;
    }

    public static String getColorName(Color color) {
        return PredefinedPalette.getColorName(color);
    }

    public void setContinuousPalettePreferred(boolean val) {
        if (val != this.continuousPalette) {
            this.continuousPalette = val;
            this.setPalettes(null);
            this.firePropertyChange(PROP_CONTINUOUS_PALETTE, !val, val);
        }
    }

    public boolean isContinuousPalettePreferred() {
        return this.continuousPalette;
    }

    public void setPalettes(Palette[] palettes) {
        if (palettes != null && palettes.length > 8) {
            throw new IllegalArgumentException("Must be <= 8 palettes");
        }
        Palette[] old = this.palettes;
        if (palettes == null) {
            palettes = Palette.getDefaultPalettes(this.continuousPalette);
        }
        this.palettes = palettes;
        this.firePropertyChange("palettes", old, palettes.clone());
    }

    public Palette[] getPalettes() {
        Palette[] result = new Palette[this.palettes.length];
        System.arraycopy(this.palettes, 0, result, 0, this.palettes.length);
        return result;
    }

    static String getString(String key) {
        String BUNDLE = "net.java.dev.colorchooser.Bundle";
        try {
            return ResourceBundle.getBundle(BUNDLE).getString(key);
        }
        catch (MissingResourceException mre) {
            return key;
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireActionPerformed(ActionEvent event) {
        List list;
        ColorChooser colorChooser = this;
        synchronized (colorChooser) {
            if (this.actionListenerList == null) {
                return;
            }
            list = (List)((ArrayList)this.actionListenerList).clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(event);
        }
    }

    void firePickerVisible(boolean val) {
        this.firePropertyChange(PROP_PICKER_VISIBLE, !val, val);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

