/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterGDF
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;
    private List<String> nodeLines = new ArrayList<String>();
    private List<String> edgeLines = new ArrayList<String>();
    private final String[] nodeLineStart = new String[]{"nodedef>name", "nodedef> name", "Nodedef>name", "Nodedef> name", "nodedef>\"name", "nodedef> \"name", "Nodedef>\"name", "Nodedef> \"name"};
    private final String[] edgeLineStart = new String[]{"edgedef>", "Edgedef>"};
    private GDFColumn[] nodeColumns;
    private GDFColumn[] edgeColumns;

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader((Reader)this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException ex) {}
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        String data;
        int end;
        int start;
        String id;
        int count;
        Matcher m;
        Progress.start((ProgressTicket)this.progressTicket);
        this.walkFile(reader);
        Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)(this.nodeLines.size() + this.edgeLines.size()));
        Pattern pattern = Pattern.compile("(?<=(?:,|^)\")(.*?)(?=(?<=(?:[^\\\\]))\",|\"$)|(?<=(?:,|^)')(.*?)(?=(?<=(?:[^\\\\]))',|'$)|(?<=(?:,|^))(?=[^'\"])(.*?)(?=(?:,|$))|(?<=,)($)");
        for (String nodeLine : this.nodeLines) {
            if (this.cancel) {
                return;
            }
            NodeDraft node = null;
            m = pattern.matcher(nodeLine);
            count = 0;
            id = "";
            while (m.find()) {
                start = m.start();
                if (start != (end = m.end())) {
                    data = nodeLine.substring(start, end);
                    if (!(data = data.trim()).isEmpty() && !data.toLowerCase().equals("null")) {
                        if (count == 0) {
                            id = data;
                            if (node == null) {
                                node = this.container.factory().newNodeDraft(id);
                            }
                        } else if (count - 1 < this.nodeColumns.length) {
                            if (this.nodeColumns[count - 1] != null) {
                                this.setNodeData(node, this.nodeColumns[count - 1], data);
                            }
                        } else {
                            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat7", (Object)id), Issue.Level.SEVERE));
                        }
                    }
                }
                ++count;
            }
            this.container.addNode(node);
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        for (String edgeLine : this.edgeLines) {
            if (this.cancel) {
                return;
            }
            EdgeDraft edge = this.container.factory().newEdgeDraft();
            edge.setDirection(EdgeDirection.UNDIRECTED);
            m = pattern.matcher(edgeLine);
            count = 0;
            id = "";
            while (m.find()) {
                start = m.start();
                if (start != (end = m.end())) {
                    data = edgeLine.substring(start, end);
                    if (!(data = data.trim()).isEmpty() && !data.toLowerCase().equals("null")) {
                        if (count == 0) {
                            NodeDraft nodeSource = this.container.getNode(data);
                            edge.setSource(nodeSource);
                            id = data;
                        } else if (count == 1) {
                            NodeDraft nodeTarget = this.container.getNode(data);
                            edge.setTarget(nodeTarget);
                            id = id + "," + data;
                        } else if (count - 2 < this.edgeColumns.length) {
                            if (this.edgeColumns[count - 2] != null) {
                                this.setEdgeData(edge, this.edgeColumns[count - 2], data);
                            }
                        } else {
                            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat7", (Object)id), Issue.Level.SEVERE));
                        }
                    }
                }
                ++count;
            }
            this.container.addEdge(edge);
            Progress.progress((ProgressTicket)this.progressTicket);
        }
    }

    private void walkFile(BufferedReader reader) throws Exception {
        if (reader.ready()) {
            String firstLine = reader.readLine();
            if (this.isNodeFirstLine(firstLine)) {
                this.findNodeColumns(firstLine);
                boolean edgesWalking = false;
                while (reader.ready() && !this.cancel) {
                    String line = reader.readLine();
                    if (this.isEdgeFirstLine(line)) {
                        edgesWalking = true;
                        this.findEdgeColumns(line);
                        continue;
                    }
                    if (!edgesWalking) {
                        this.nodeLines.add(line);
                        continue;
                    }
                    this.edgeLines.add(line);
                }
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat1"), Issue.Level.CRITICAL));
            }
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat1"), Issue.Level.CRITICAL));
        }
    }

    private void findNodeColumns(String line) throws Exception {
        String[] columns = line.split(",");
        this.nodeColumns = new GDFColumn[columns.length - 1];
        for (int i = 1; i < columns.length; ++i) {
            String columnString = columns[i];
            String typeString = "";
            String columnName = "";
            Class type = String.class;
            try {
                typeString = columnString.substring(columnString.lastIndexOf(" ")).trim().toLowerCase();
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                int end = columnString.lastIndexOf(" ");
                columnName = end != -1 ? columnString.substring(0, end).trim().toLowerCase() : columnString.trim().toLowerCase();
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            if (columnName.isEmpty()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat2"), Issue.Level.SEVERE));
                columnName = "default" + i;
            }
            if (typeString.isEmpty()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat6", (Object)columnName), Issue.Level.INFO));
                typeString = "varchar";
            }
            if ((typeString = typeString.replaceAll("\\([0-9]*\\)", "")).equals("varchar")) {
                type = String.class;
            } else if (typeString.equals("bool")) {
                type = Boolean.class;
            } else if (typeString.equals("boolean")) {
                type = Boolean.class;
            } else if (typeString.equals("integer")) {
                type = Integer.class;
            } else if (typeString.equals("tinyint")) {
                type = Integer.class;
            } else if (typeString.equals("int")) {
                type = Integer.class;
            } else if (typeString.equals("double")) {
                type = Double.class;
            } else if (typeString.equals("float")) {
                type = Float.class;
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat5", (Object)typeString), Issue.Level.WARNING));
            }
            if (columnName.equals("x")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.X);
                this.report.log("Node property found: x");
                continue;
            }
            if (columnName.equals("y")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.Y);
                this.report.log("Node property found: y");
                continue;
            }
            if (columnName.equals("visible")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.VISIBLE);
                this.report.log("Node property found: visible");
                continue;
            }
            if (columnName.equals("color")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.COLOR);
                this.report.log("Node property found: color");
                continue;
            }
            if (columnName.equals("fixed")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.FIXED);
                this.report.log("Node property found: fixed");
                continue;
            }
            if (columnName.equals("style")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.STYLE);
                this.report.log("Node property found: style");
                continue;
            }
            if (columnName.equals("width")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.WIDTH);
                this.report.log("Node property found: width");
                continue;
            }
            if (columnName.equals("height")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.HEIGHT);
                this.report.log("Node property found: height");
                continue;
            }
            if (columnName.equals("label")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.LABEL);
                this.report.log("Node property found: label");
                continue;
            }
            if (columnName.equals("labelvisible")) {
                this.nodeColumns[i - 1] = new GDFColumn(GDFColumn.NodeGuessColumn.LABELVISIBLE);
                this.report.log("Node property found: labelvisible");
                continue;
            }
            ColumnDraft column = this.container.getNodeColumn(columnName);
            if (column == null) {
                column = this.container.addNodeColumn(columnName, type);
                this.nodeColumns[i - 1] = new GDFColumn(column);
                this.report.log("Node attribute " + columnName + " (" + type.getSimpleName() + ")");
                continue;
            }
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat8", (Object)columnName), Issue.Level.SEVERE));
        }
    }

    private void findEdgeColumns(String line) throws Exception {
        String[] columns = line.split(",");
        this.edgeColumns = new GDFColumn[columns.length - 2];
        for (int i = 2; i < columns.length; ++i) {
            String columnString = columns[i];
            String typeString = "";
            String columnName = "";
            Class type = String.class;
            try {
                typeString = columnString.substring(columnString.lastIndexOf(" ")).trim().toLowerCase();
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                int end = columnString.lastIndexOf(" ");
                columnName = end != -1 ? columnString.substring(0, end).trim().toLowerCase() : columnString.trim().toLowerCase();
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            if (columnName.isEmpty()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat2"), Issue.Level.SEVERE));
                columnName = "default" + i;
            }
            if (typeString.isEmpty()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat6", (Object)columnName), Issue.Level.INFO));
                typeString = "varchar";
            }
            if ((typeString = typeString.replaceAll("\\([0-9]*\\)", "")).equals("varchar")) {
                type = String.class;
            } else if (typeString.equals("bool")) {
                type = Boolean.class;
            } else if (typeString.equals("boolean")) {
                type = Boolean.class;
            } else if (typeString.equals("integer")) {
                type = Integer.class;
            } else if (typeString.equals("tinyint")) {
                type = Integer.class;
            } else if (typeString.equals("int")) {
                type = Integer.class;
            } else if (typeString.equals("double")) {
                type = Double.class;
            } else if (typeString.equals("float")) {
                type = Float.class;
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat5", (Object)typeString), Issue.Level.WARNING));
            }
            if (columnName.equals("color")) {
                this.edgeColumns[i - 2] = new GDFColumn(GDFColumn.EdgeGuessColumn.COLOR);
                this.report.log("Edge property found: color");
                continue;
            }
            if (columnName.equals("visible")) {
                this.edgeColumns[i - 2] = new GDFColumn(GDFColumn.EdgeGuessColumn.VISIBLE);
                this.report.log("Edge property found: visible");
                continue;
            }
            if (columnName.equals("weight")) {
                this.edgeColumns[i - 2] = new GDFColumn(GDFColumn.EdgeGuessColumn.WEIGHT);
                this.report.log("Edge property found: weight");
                continue;
            }
            if (columnName.equals("directed")) {
                this.edgeColumns[i - 2] = new GDFColumn(GDFColumn.EdgeGuessColumn.DIRECTED);
                this.report.log("Edge property found: directed");
                continue;
            }
            if (columnName.equals("label")) {
                this.edgeColumns[i - 2] = new GDFColumn(GDFColumn.EdgeGuessColumn.LABEL);
                this.report.log("Edge property found: label");
                continue;
            }
            if (columnName.equals("labelvisible")) {
                this.edgeColumns[i - 2] = new GDFColumn(GDFColumn.EdgeGuessColumn.LABELVISIBLE);
                this.report.log("Edge property found: labelvisible");
                continue;
            }
            ColumnDraft column = this.container.getEdgeColumn(columnName);
            if (column == null) {
                column = this.container.addEdgeColumn(columnName, type);
                this.edgeColumns[i - 2] = new GDFColumn(column);
                this.report.log("Edge attribute " + columnName + " (" + type.getSimpleName() + ")");
                continue;
            }
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat9", (Object)columnName), Issue.Level.SEVERE));
        }
    }

    private boolean isNodeFirstLine(String line) {
        for (String s : this.nodeLineStart) {
            if (!line.contains(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isEdgeFirstLine(String line) {
        for (String s : this.edgeLineStart) {
            if (!line.contains(s)) continue;
            return true;
        }
        return false;
    }

    private void setNodeData(NodeDraft node, GDFColumn column, String data) throws Exception {
        if (column.getNodeColumn() != null) {
            try {
                switch (column.getNodeColumn()) {
                    case X: {
                        node.setX(Float.parseFloat(data));
                        break;
                    }
                    case Y: {
                        node.setY(Float.parseFloat(data));
                        break;
                    }
                    case COLOR: {
                        String[] rgb = data.replace(" ", "").split(",");
                        if (rgb.length == 3) {
                            node.setColor(rgb[0], rgb[1], rgb[2]);
                            break;
                        }
                        node.setColor(data);
                        break;
                    }
                    case FIXED: {
                        node.setFixed(Boolean.parseBoolean(data));
                        break;
                    }
                    case HEIGHT: {
                        break;
                    }
                    case WIDTH: {
                        node.setSize(Float.parseFloat(data));
                        break;
                    }
                    case LABEL: {
                        node.setLabel(data);
                        break;
                    }
                    case LABELVISIBLE: {
                        node.setLabelVisible(Boolean.parseBoolean(data));
                    }
                }
            }
            catch (Exception e) {
                String message = NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat3", (Object)((Object)column.getNodeColumn()), (Object)node, (Object)data);
                this.report.logIssue(new Issue(message, Issue.Level.WARNING, (Throwable)e));
            }
        } else if (column.getAttributeColumn() != null) {
            try {
                node.parseAndSetValue(column.getAttributeColumn().getId(), data);
            }
            catch (Exception e) {
                String message = NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat4", (Object)column.getAttributeColumn().getTypeClass().getSimpleName(), (Object)column.getAttributeColumn().getTitle(), (Object)node);
                this.report.logIssue(new Issue(message, Issue.Level.WARNING, (Throwable)e));
            }
        }
    }

    private void setEdgeData(EdgeDraft edge, GDFColumn column, String data) throws Exception {
        if (column.getEdgeColumn() != null) {
            try {
                switch (column.getEdgeColumn()) {
                    case COLOR: {
                        String[] rgb = data.replace(" ", "").split(",");
                        if (rgb.length == 3) {
                            edge.setColor(rgb[0], rgb[1], rgb[2]);
                            break;
                        }
                        edge.setColor(data);
                        break;
                    }
                    case WEIGHT: {
                        edge.setWeight((double)Float.parseFloat(data));
                        break;
                    }
                    case DIRECTED: {
                        if (Boolean.parseBoolean(data)) {
                            edge.setDirection(EdgeDirection.DIRECTED);
                            break;
                        }
                        edge.setDirection(EdgeDirection.UNDIRECTED);
                        break;
                    }
                    case LABEL: {
                        edge.setLabel(data);
                        break;
                    }
                    case LABELVISIBLE: {
                        edge.setLabelVisible(Boolean.parseBoolean(data));
                    }
                }
            }
            catch (Exception e) {
                String message = NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat3", (Object)((Object)column.getEdgeColumn()), (Object)data);
                this.report.logIssue(new Issue(message, Issue.Level.WARNING, (Throwable)e));
            }
        } else if (column.getAttributeColumn() != null) {
            try {
                edge.parseAndSetValue(column.getAttributeColumn().getId(), data);
            }
            catch (Exception e) {
                String message = NbBundle.getMessage(ImporterGDF.class, (String)"importerGDF_error_dataformat4", (Object)column.getAttributeColumn().getTypeClass().getSimpleName(), (Object)column.getAttributeColumn().getTitle(), (Object)edge);
                this.report.logIssue(new Issue(message, Issue.Level.WARNING, (Throwable)e));
            }
        }
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    private static class GDFColumn {
        private ColumnDraft column;
        private NodeGuessColumn nodeColumn;
        private EdgeGuessColumn edgeColumn;

        public GDFColumn(NodeGuessColumn column) {
            this.nodeColumn = column;
        }

        public GDFColumn(EdgeGuessColumn column) {
            this.edgeColumn = column;
        }

        public GDFColumn(ColumnDraft column) {
            this.column = column;
        }

        public NodeGuessColumn getNodeColumn() {
            return this.nodeColumn;
        }

        public EdgeGuessColumn getEdgeColumn() {
            return this.edgeColumn;
        }

        public ColumnDraft getAttributeColumn() {
            return this.column;
        }

        public static enum EdgeGuessColumn {
            VISIBLE,
            COLOR,
            WEIGHT,
            DIRECTED,
            LABEL,
            LABELVISIBLE;

        }

        public static enum NodeGuessColumn {
            X,
            Y,
            VISIBLE,
            FIXED,
            STYLE,
            COLOR,
            WIDTH,
            HEIGHT,
            LABEL,
            LABELVISIBLE;

        }
    }
}

