/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.openord;

import gnu.trove.TIntFloatHashMap;
import gnu.trove.TIntFloatIterator;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.gephi.layout.plugin.openord.DensityGrid;
import org.gephi.layout.plugin.openord.Node;

public class Worker
implements Runnable {
    private final int id;
    private final int numThreads;
    private final CyclicBarrier barrier;
    private boolean done = false;
    private Node[] positions;
    private TIntFloatHashMap[] neighbors;
    private DensityGrid densityGrid;
    private boolean firstAdd = true;
    private boolean fineFirstAdd = true;
    private float attraction;
    private int STAGE;
    private float temperature;
    private float dampingMult;
    private float minEdges;
    private float cutEnd;
    private float cutOffLength;
    private boolean fineDensity;
    protected Random random;

    public Worker(int id, int numThreads, CyclicBarrier barrier) {
        this.barrier = barrier;
        this.id = id;
        this.numThreads = numThreads;
        this.densityGrid = new DensityGrid();
        this.densityGrid.init();
    }

    @Override
    public void run() {
        while (!this.isDone()) {
            for (int i = this.id; i < this.positions.length; i += this.numThreads) {
                this.updateNodePos(i);
            }
            if (this.positions.length % this.numThreads != 0 && this.id > this.positions.length % this.numThreads - 1) {
                this.getNextRandom();
                this.getNextRandom();
            }
            this.firstAdd = false;
            if (this.fineDensity) {
                this.fineFirstAdd = false;
            }
            try {
                this.barrier.await();
            }
            catch (InterruptedException ex) {
                return;
            }
            catch (BrokenBarrierException ex) {
                return;
            }
        }
    }

    private void updateNodePos(int nodeIndex) {
        Node n = this.positions[nodeIndex];
        if (n.fixed) {
            this.getNextRandom();
            this.getNextRandom();
            return;
        }
        float[] energies = new float[2];
        float[][] updatedPos = new float[2][2];
        float jumpLength = 0.01f * this.temperature;
        this.densityGrid.substract(n, this.firstAdd, this.fineFirstAdd, this.fineDensity);
        energies[0] = this.getNodeEnergy(nodeIndex);
        this.solveAnalytic(nodeIndex);
        updatedPos[0][0] = n.x;
        updatedPos[0][1] = n.y;
        updatedPos[1][0] = updatedPos[0][0] + (0.5f - this.getNextRandom()) * jumpLength;
        updatedPos[1][1] = updatedPos[0][1] + (0.5f - this.getNextRandom()) * jumpLength;
        n.x = updatedPos[1][0];
        n.y = updatedPos[1][1];
        energies[1] = this.getNodeEnergy(nodeIndex);
        if (energies[0] < energies[1]) {
            n.x = updatedPos[0][0];
            n.y = updatedPos[0][1];
            n.energy = energies[0];
        } else {
            n.x = updatedPos[1][0];
            n.y = updatedPos[1][1];
            n.energy = energies[1];
        }
        this.densityGrid.add(n, this.fineDensity);
    }

    private float getNodeEnergy(int nodeIndex) {
        double attraction_factor = (double)(this.attraction * this.attraction * this.attraction * this.attraction) * 0.02;
        float nodeEnergy = 0.0f;
        Node n = this.positions[nodeIndex];
        if (this.neighbors[nodeIndex] != null) {
            TIntFloatIterator itr = this.neighbors[nodeIndex].iterator();
            while (itr.hasNext()) {
                itr.advance();
                float weight = itr.value();
                Node m = this.positions[itr.key()];
                float xDis = n.x - m.x;
                float yDis = n.y - m.y;
                float energyDistance = xDis * xDis + yDis * yDis;
                if (this.STAGE < 2) {
                    energyDistance *= energyDistance;
                }
                if (this.STAGE == 0) {
                    energyDistance *= energyDistance;
                }
                nodeEnergy = (float)((double)nodeEnergy + (double)weight * attraction_factor * (double)energyDistance);
            }
        }
        return nodeEnergy += this.densityGrid.getDensity(n.x, n.y, this.fineDensity);
    }

    private void solveAnalytic(int nodeIndex) {
        float totalWeight = 0.0f;
        float xCen = 0.0f;
        float yCen = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        TIntFloatHashMap map = this.neighbors[nodeIndex];
        if (map != null) {
            Node n = this.positions[nodeIndex];
            TIntFloatIterator itr = map.iterator();
            while (itr.hasNext()) {
                itr.advance();
                float weight = itr.value();
                Node m = this.positions[itr.key()];
                totalWeight += weight;
                x += weight * m.x;
                y += weight * m.y;
            }
            if (totalWeight > 0.0f) {
                xCen = x / totalWeight;
                yCen = y / totalWeight;
                float damping = 1.0f - this.dampingMult;
                float posX = damping * n.x + (1.0f - damping) * xCen;
                float posY = damping * n.y + (1.0f - damping) * yCen;
                n.x = posX;
                n.y = posY;
            }
            if (this.minEdges == 99.0f) {
                return;
            }
            if (this.cutEnd >= 39500.0f) {
                return;
            }
            float maxLength = 0.0f;
            int maxIndex = -1;
            int neighborsCount = map.size();
            if ((float)neighborsCount >= this.minEdges) {
                TIntFloatIterator itr2 = this.neighbors[nodeIndex].iterator();
                while (itr2.hasNext()) {
                    itr2.advance();
                    Node m = this.positions[itr2.key()];
                    float xDis = xCen - m.x;
                    float yDis = yCen - m.y;
                    float dis = xDis * xDis + yDis * yDis;
                    if (!((dis = (float)((double)dis * Math.sqrt(neighborsCount))) > maxLength)) continue;
                    maxLength = dis;
                    maxIndex = itr2.key();
                }
            }
            if (maxLength > this.cutOffLength && maxIndex != -1) {
                map.remove(maxIndex);
            }
        }
    }

    public float getTotEnergy() {
        float myTotEnergy = 0.0f;
        for (int i = this.id; i < this.positions.length; i += this.numThreads) {
            myTotEnergy += this.positions[i].energy;
        }
        return myTotEnergy;
    }

    public float getNextRandom() {
        float rand = 0.0f;
        for (int i = 0; i < this.numThreads; ++i) {
            if (i == this.id) {
                rand = this.random.nextFloat();
                continue;
            }
            this.random.nextFloat();
        }
        return rand;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public void setPositions(Node[] positions) {
        this.positions = positions;
    }

    public void setNeighbors(TIntFloatHashMap[] neighbors) {
        this.neighbors = neighbors;
    }

    public Node[] getPositions() {
        return this.positions;
    }

    public boolean isFineDensity() {
        return this.fineDensity;
    }

    public boolean isFineFirstAdd() {
        return this.fineFirstAdd;
    }

    public boolean isFirstAdd() {
        return this.firstAdd;
    }

    public DensityGrid getDensityGrid() {
        return this.densityGrid;
    }

    public TIntFloatHashMap[] getNeighbors() {
        return this.neighbors;
    }

    public void setSTAGE(int STAGE) {
        this.STAGE = STAGE;
    }

    public void setAttraction(float attraction) {
        this.attraction = attraction;
    }

    public void setCutOffLength(float cutOffLength) {
        this.cutOffLength = cutOffLength;
    }

    public void setDampingMult(float dampingMult) {
        this.dampingMult = dampingMult;
    }

    public void setMinEdges(float minEdges) {
        this.minEdges = minEdges;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setFineDensity(boolean fineDensity) {
        this.fineDensity = fineDensity;
    }

    public void setDensityGrid(DensityGrid densityGrid) {
        this.densityGrid = densityGrid;
    }

    public int getId() {
        return this.id;
    }
}

