/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CommandLineProcessor
extends OptionProcessor {
    private Option openOption = Option.defaultArguments();
    private Option openOption2 = Option.additionalArguments((char)'o', (String)"open");
    private final String MEMORY_ERROR = NbBundle.getMessage(CommandLineProcessor.class, (String)"CommandLineProcessor.OutOfMemoryError.message");
    private static final String GEPHI_EXTENSION = "gephi";

    protected Set<Option> getOptions() {
        HashSet<Option> set = new HashSet<Option>();
        set.add(this.openOption);
        set.add(this.openOption2);
        return set;
    }

    public void process(Env env, Map values) throws CommandException {
        ArrayList<String> filenameList = new ArrayList<String>();
        Object obj = values.get(this.openOption);
        if (obj != null) {
            filenameList.addAll(Arrays.asList((String[])obj));
        }
        if ((obj = values.get(this.openOption2)) != null) {
            filenameList.addAll(Arrays.asList((String[])obj));
        }
        try {
            for (int i = 0; i < filenameList.size(); ++i) {
                File file = new File((String)filenameList.get(i));
                if (!file.isAbsolute()) {
                    file = new File(env.getCurrentDirectory(), (String)filenameList.get(i));
                }
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (!file.exists()) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CommandLineProcessor.class, (String)"CommandLineProcessor.fileNotFound", (Object)file.getName()), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    return;
                }
                if (fileObject.hasExt(GEPHI_EXTENSION)) {
                    ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
                    try {
                        pc.openProject(file);
                    }
                    catch (Exception ew) {
                        ew.printStackTrace();
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CommandLineProcessor.class, (String)"CommandLineProcessor.openGephiError"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                    return;
                }
                ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                if (importController.getImportController().isFileSupported(FileUtil.toFile((FileObject)fileObject))) {
                    importController.importFile(fileObject);
                    continue;
                }
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CommandLineProcessor.class, (String)"CommandLineProcessor.fileNotSupported"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        }
        catch (OutOfMemoryError ex) {
            System.gc();
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)this.MEMORY_ERROR, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)("CommandLineParsing " + ex.getMessage()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }
}

