/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.filetypes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.ui.options.filetypes.FileAssociationsModel;
import org.netbeans.core.ui.options.filetypes.NewExtensionPanel;
import org.netbeans.core.ui.options.filetypes.OpenAsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public final class OpenAsAction
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(OpenAsAction.class.getName());
    private final DataObject dob;

    public OpenAsAction(DataObject obj) {
        this.dob = obj;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String mimeType;
        OpenAsPanel openAsPanel = new OpenAsPanel();
        FileAssociationsModel model = new FileAssociationsModel();
        openAsPanel.setModel(model);
        FileObject fo = this.dob.getPrimaryFile();
        String extension = fo.getExt();
        openAsPanel.setExtension(extension);
        String openLabel = NbBundle.getMessage(NewExtensionPanel.class, (String)"OpenAsPanel.open");
        DialogDescriptor dd = new DialogDescriptor((Object)openAsPanel, NbBundle.getMessage(OpenAsPanel.class, (String)"OpenAsPanel.title"), true, new Object[]{openLabel, DialogDescriptor.CANCEL_OPTION}, (Object)openLabel, 0, null, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        if (openLabel.equals(dd.getValue()) && (mimeType = openAsPanel.getMimeType()) != null) {
            this.dob.addPropertyChangeListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("valid") && !((Boolean)evt.getNewValue()).booleanValue()) {
                        LOGGER.log(Level.FINE, "PROP_VALID {0} - {1}", new Object[]{evt.getNewValue(), evt});
                        try {
                            OpenCookie openCookie = (OpenCookie)DataObject.find((FileObject)OpenAsAction.this.dob.getPrimaryFile()).getCookie(OpenCookie.class);
                            if (openCookie == null) return;
                            openCookie.open();
                            return;
                        }
                        catch (DataObjectNotFoundException ex) {
                            LOGGER.log(Level.INFO, null, ex);
                            return;
                        }
                        finally {
                            OpenAsAction.this.dob.removePropertyChangeListener((PropertyChangeListener)this);
                        }
                    } else {
                        OpenAsAction.this.dob.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
            model.setMimeType(extension, mimeType);
            model.store();
            try {
                this.dob.setValid(false);
            }
            catch (PropertyVetoException ex) {
                LOGGER.log(Level.INFO, "Can't convert", ex);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenAsAction.class, (String)"ERR_CantConvert", (Object)fo.getPath(), (Object)mimeType), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
            try {
                OpenCookie openCookie = (OpenCookie)DataObject.find((FileObject)fo).getLookup().lookup(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                    return;
                }
            }
            catch (DataObjectNotFoundException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenAsAction.class, (String)"ERR_CantOpen", (Object)fo.getPath()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }
}

