/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ElementIdType;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.processor.plugin.AbstractProcessor;
import org.gephi.io.processor.spi.Processor;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DefaultProcessor
extends AbstractProcessor
implements Processor {
    public String getDisplayName() {
        return NbBundle.getMessage(DefaultProcessor.class, (String)"DefaultProcessor.displayName");
    }

    public void process() {
        if (this.containers.length > 1) {
            throw new RuntimeException("This processor can only handle single containers");
        }
        ContainerUnloader container = this.containers[0];
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (this.workspace == null) {
            this.workspace = pc.newWorkspace(pc.getCurrentProject());
            pc.openWorkspace(this.workspace);
        }
        this.processConfiguration(container, this.workspace);
        if (container.getSource() != null) {
            pc.setSource(this.workspace, container.getSource());
        }
        this.process(container, this.workspace);
        this.workspace = null;
        this.graphModel = null;
        this.containers = null;
        this.progressTicket = null;
    }

    protected void processConfiguration(ContainerUnloader container, Workspace workspace) {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        Configuration configuration = new Configuration();
        configuration.setTimeRepresentation(container.getTimeRepresentation());
        if (container.getEdgeTypeLabelClass() != null) {
            configuration.setEdgeLabelType(container.getEdgeTypeLabelClass());
        }
        configuration.setNodeIdType(container.getElementIdType().getTypeClass());
        configuration.setEdgeIdType(container.getElementIdType().getTypeClass());
        ColumnDraft weightColumn = container.getEdgeColumn("weight");
        if (weightColumn != null && weightColumn.isDynamic()) {
            if (container.getTimeRepresentation().equals((Object)TimeRepresentation.INTERVAL)) {
                configuration.setEdgeWeightType(IntervalDoubleMap.class);
            } else {
                configuration.setEdgeWeightType(TimestampDoubleMap.class);
            }
        }
        graphController.getGraphModel(workspace).setConfiguration(configuration);
    }

    protected void process(ContainerUnloader container, Workspace workspace) {
        Object id;
        String idString;
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.graphModel = graphController.getGraphModel(workspace);
        Graph graph = this.graphModel.getGraph();
        GraphFactory factory = this.graphModel.factory();
        this.graphModel.setTimeFormat(container.getTimeFormat());
        this.graphModel.setTimeZone(container.getTimeZone());
        Progress.start((ProgressTicket)this.progressTicket, (int)(container.getNodeCount() + container.getEdgeCount()));
        this.flushColumns(container);
        int addedNodes = 0;
        int addedEdges = 0;
        ElementIdType elementIdType = container.getElementIdType();
        for (NodeDraft draftNode : container.getNodes()) {
            idString = draftNode.getId();
            id = this.toElementId(elementIdType, idString);
            Node node = graph.getNode(id);
            boolean newNode = false;
            if (node == null) {
                node = factory.newNode(id);
                ++addedNodes;
                newNode = true;
            }
            this.flushToNode(draftNode, node);
            if (newNode) {
                graph.addNode(node);
            }
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        for (EdgeDraft draftEdge : container.getEdges()) {
            idString = draftEdge.getId();
            id = this.toElementId(elementIdType, idString);
            String sourceId = draftEdge.getSource().getId();
            String targetId = draftEdge.getTarget().getId();
            Node source = graph.getNode(this.toElementId(elementIdType, sourceId));
            Node target = graph.getNode(this.toElementId(elementIdType, targetId));
            Object type = draftEdge.getType();
            int edgeType = this.graphModel.addEdgeType(type);
            Edge edge = graph.getEdge(source, target, edgeType);
            boolean newEdge = false;
            if (edge == null) {
                switch (container.getEdgeDefault()) {
                    case DIRECTED: {
                        edge = factory.newEdge(id, source, target, edgeType, draftEdge.getWeight(), true);
                        break;
                    }
                    case UNDIRECTED: {
                        edge = factory.newEdge(id, source, target, edgeType, draftEdge.getWeight(), false);
                        break;
                    }
                    case MIXED: {
                        boolean directed = draftEdge.getDirection() == null || !draftEdge.getDirection().equals((Object)EdgeDirection.UNDIRECTED);
                        edge = factory.newEdge(id, source, target, edgeType, draftEdge.getWeight(), directed);
                    }
                }
                ++addedEdges;
                newEdge = true;
            }
            this.flushToEdge(draftEdge, edge);
            if (newEdge) {
                graph.addEdge(edge);
            }
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        int touchedNodes = container.getNodeCount();
        int touchedEdges = container.getEdgeCount();
        if (touchedNodes != addedNodes || touchedEdges != addedEdges) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Nodes loaded: {0} ({1} added)", new Object[]{touchedNodes, addedNodes});
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Edges loaded: {0} ({1} added)", new Object[]{touchedEdges, addedEdges});
        } else {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Nodes loaded: {0}", new Object[]{touchedNodes});
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Edges loaded: {0}", new Object[]{touchedEdges});
        }
        Progress.finish((ProgressTicket)this.progressTicket);
    }

    private Object toElementId(ElementIdType elementIdType, String idString) {
        Object id;
        switch (elementIdType) {
            case INTEGER: {
                id = Integer.parseInt(idString);
                break;
            }
            case LONG: {
                id = Long.parseLong(idString);
                break;
            }
            default: {
                id = idString;
            }
        }
        return id;
    }
}

