/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.tools;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;

public class FindMultiplierXorShift32 {
    private static final long PHI = -7046029254386353131L;
    private static final int TOP = 20;
    private static long state = System.nanoTime();

    private static long staffordMix13(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    public static long nextLong() {
        return FindMultiplierXorShift32.staffordMix13(state += -7046029254386353131L);
    }

    public static void main(String[] args) throws InterruptedException {
        final ArrayBlockingQueue<Candidate> candidates = new ArrayBlockingQueue<Candidate>(100000);
        final ObjectSet scores = ObjectSets.synchronize(new ObjectOpenHashSet());
        final ObjectSet forbidden = ObjectSets.synchronize(new ObjectOpenHashSet());
        int processors = Runtime.getRuntime().availableProcessors();
        Thread[] thread = new Thread[processors];
        Runnable barrierAction = new Runnable(){
            private ObjectSet<Candidate> top = new ObjectOpenHashSet<Candidate>();
            Candidate best;

            @Override
            public void run() {
                int i;
                ObjectOpenHashSet<Object> currentTop;
                Object[] array = scores.toArray(new Candidate[scores.size()]);
                Arrays.sort(array);
                if (array.length > 0 && (this.best == null || ((Candidate)array[0]).compareTo(this.best) < 0)) {
                    this.best = array[0];
                }
                if (this.top.equals(currentTop = new ObjectOpenHashSet<Object>(array, 0, Math.min(20, array.length)))) {
                    System.err.println("Fixed point: restarting");
                    array = new Candidate[]{};
                    forbidden.addAll(this.top);
                    this.top.clear();
                } else {
                    this.top = currentTop;
                }
                scores.clear();
                for (i = 0; i < Math.min(10, array.length); ++i) {
                    System.out.println(array[i]);
                }
                for (i = 0; i < Math.min(20, array.length); ++i) {
                    Object c = array[i];
                    candidates.add(c);
                    candidates.add(new Candidate(((Candidate)c).multiplier, ((Candidate)c).shift + 1));
                    candidates.add(new Candidate(((Candidate)c).multiplier, ((Candidate)c).shift - 1));
                    candidates.add(new Candidate(((Candidate)c).multiplier << 1 | 1, ((Candidate)c).shift - 1));
                    candidates.add(new Candidate(((Candidate)c).multiplier << 1 | 1, ((Candidate)c).shift));
                    candidates.add(new Candidate(((Candidate)c).multiplier << 1 | 1, ((Candidate)c).shift + 1));
                    int b0 = 32;
                    while (b0-- != 1) {
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ 1 << b0, ((Candidate)c).shift - 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ 1 << b0, ((Candidate)c).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ 1 << b0, ((Candidate)c).shift + 1));
                        int b1 = b0;
                        while (b1-- != 1) {
                            candidates.add(new Candidate(((Candidate)c).multiplier ^ 1 << b0 ^ 1 << b1, ((Candidate)c).shift - 1));
                            candidates.add(new Candidate(((Candidate)c).multiplier ^ 1 << b0 ^ 1 << b1, ((Candidate)c).shift));
                            candidates.add(new Candidate(((Candidate)c).multiplier ^ 1 << b0 ^ 1 << b1, ((Candidate)c).shift + 1));
                        }
                    }
                    for (int m : new int[]{13107, 21845, 39321}) {
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | m << 16, ((Candidate)c).shift - 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | m << 16, ((Candidate)c).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | m << 16, ((Candidate)c).shift + 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF0000 | m, ((Candidate)c).shift - 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF0000 | m, ((Candidate)c).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF0000 | m, ((Candidate)c).shift + 1));
                    }
                    for (int j = 0; j < Math.min(20, array.length); ++j) {
                        Object d = array[j];
                        if (((Candidate)c).multiplier == ((Candidate)d).multiplier) continue;
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ ((Candidate)d).multiplier | 1, ((Candidate)c).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ ((Candidate)d).multiplier | 1, ((Candidate)d).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ ((Candidate)d).multiplier | 1, ((Candidate)c).shift + 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ ((Candidate)d).multiplier | 1, ((Candidate)d).shift + 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ ((Candidate)d).multiplier | 1, ((Candidate)c).shift - 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier ^ ((Candidate)d).multiplier | 1, ((Candidate)d).shift - 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier + ((Candidate)d).multiplier | 1, ((Candidate)c).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier + ((Candidate)d).multiplier | 1, ((Candidate)d).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier + ((Candidate)d).multiplier | 1, ((Candidate)c).shift + 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier + ((Candidate)d).multiplier | 1, ((Candidate)d).shift + 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier + ((Candidate)d).multiplier | 1, ((Candidate)c).shift - 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier + ((Candidate)d).multiplier | 1, ((Candidate)d).shift - 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | ((Candidate)d).multiplier & 0xFFFF0000, ((Candidate)c).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | ((Candidate)d).multiplier & 0xFFFF0000, ((Candidate)d).shift));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | ((Candidate)d).multiplier & 0xFFFF0000, ((Candidate)c).shift + 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | ((Candidate)d).multiplier & 0xFFFF0000, ((Candidate)d).shift + 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | ((Candidate)d).multiplier & 0xFFFF0000, ((Candidate)c).shift - 1));
                        candidates.add(new Candidate(((Candidate)c).multiplier & 0xFFFF | ((Candidate)d).multiplier & 0xFFFF0000, ((Candidate)d).shift - 1));
                    }
                }
                int r = 8;
                while (r-- != 0) {
                    int multiplier = (int)FindMultiplierXorShift32.nextLong() | 1;
                    candidates.add(new Candidate(multiplier, 15));
                    candidates.add(new Candidate(multiplier, 16));
                    candidates.add(new Candidate(multiplier, 17));
                }
                candidates.removeAll(forbidden);
                System.out.println();
                System.out.println("Best: " + this.best);
                System.out.println("Now testing " + candidates.size() + " candidates ");
            }
        };
        final CyclicBarrier barrier = new CyclicBarrier(processors, barrierAction);
        int i = thread.length;
        while (i-- != 0) {
            thread[i] = new Thread(){

                @Override
                public void run() {
                    int[] count = new int[32];
                    while (true) {
                        Candidate candidate;
                        try {
                            while (true) {
                                candidate = (Candidate)candidates.poll();
                                while (candidate == null) {
                                    barrier.await();
                                    candidate = (Candidate)candidates.poll();
                                }
                                if (candidate.chiSquared != 0.0) {
                                    scores.add(candidate);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        catch (BrokenBarrierException e) {
                            throw new RuntimeException(e.getMessage(), e);
                        }
                        int multiplier = candidate.multiplier;
                        int shift = candidate.shift;
                        Arrays.fill(count, 0);
                        int x = 1;
                        long n = 0L;
                        do {
                            ++n;
                            int mapped = multiplier * x ^ multiplier * x >>> shift;
                            int flippedBitMask = 1;
                            int f = 32;
                            while (f-- != 0) {
                                int t = multiplier * (x ^ flippedBitMask);
                                int flippedMapped = mapped ^ t ^ t >>> shift;
                                int bitMask = Integer.MIN_VALUE;
                                int b = 32;
                                while (b-- != 0) {
                                    if ((bitMask & flippedMapped) != 0) {
                                        int n2 = b;
                                        count[n2] = count[n2] + 1;
                                    }
                                    bitMask >>>= 1;
                                }
                                flippedBitMask <<= 1;
                            }
                            if (x == Integer.MIN_VALUE) {
                                x = 3;
                                continue;
                            }
                            if (x == -1073741824) {
                                x = 7;
                                continue;
                            }
                            if (x == -536870912) break;
                            int c = x & -x;
                            int r = x + c;
                            x = ((r ^ x) >>> 2) / c | r;
                        } while (x != 0);
                        double chiSquared = 0.0;
                        double maxBias = 0.0;
                        for (int b = 0; b < 30; ++b) {
                            double d = Math.abs(0.5 - (double)count[b] / (32.0 * (double)n));
                            chiSquared += d * d;
                            maxBias = Math.max(maxBias, d / 0.5);
                        }
                        candidate.chiSquared = 2.0 * chiSquared;
                        candidate.bias = maxBias;
                        scores.add(candidate);
                    }
                }
            };
        }
        for (int shift = 8; shift <= 24; ++shift) {
            candidates.add(new Candidate(0x33333333, shift));
            candidates.add(new Candidate(0x55555555, shift));
            candidates.add(new Candidate(-1717986919, shift));
        }
        for (Thread t : thread) {
            t.start();
        }
        for (Thread t : thread) {
            t.join();
        }
    }

    public static final class Candidate
    implements Comparable<Candidate> {
        public final int multiplier;
        public final int shift;
        public double chiSquared;
        public double bias;

        public Candidate(int multiplier, int shift) {
            this.multiplier = multiplier;
            this.shift = shift;
        }

        public String toString() {
            return "Candidate [multiplier=0x" + Integer.toHexString(this.multiplier) + ", shift=" + this.shift + ", bias=" + this.bias + ", chiSquared=" + this.chiSquared + "]";
        }

        @Override
        public int compareTo(Candidate o) {
            int t = Double.compare(this.bias, o.bias);
            if (t != 0) {
                return t;
            }
            return Double.compare(this.chiSquared, o.chiSquared);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Candidate other = (Candidate)obj;
            if (this.multiplier != other.multiplier) {
                return false;
            }
            return this.shift == other.shift;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.multiplier ^ this.multiplier >>> 32);
            result = 31 * result + this.shift;
            return result;
        }
    }
}

