/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.impl.EdgeDraftImpl;
import org.gephi.io.importer.impl.ImportContainerImpl;
import org.gephi.io.importer.impl.NodeDraftImpl;
import org.openide.util.NbBundle;

public class ElementFactoryImpl
implements ElementDraft.Factory {
    protected final ImportContainerImpl container;
    protected static final AtomicInteger NODE_IDS = new AtomicInteger();
    protected static final AtomicInteger EDGE_IDS = new AtomicInteger();

    public ElementFactoryImpl(ImportContainerImpl container) {
        this.container = container;
    }

    @Override
    public NodeDraftImpl newNodeDraft() {
        NodeDraftImpl node = new NodeDraftImpl(this.container, String.valueOf(NODE_IDS.getAndIncrement()));
        return node;
    }

    @Override
    public NodeDraftImpl newNodeDraft(String id) {
        if (id == null) {
            String message = NbBundle.getMessage(ElementFactoryImpl.class, (String)"ElementFactoryException_NullNodeId");
            this.container.getReport().logIssue(new Issue(message, Issue.Level.CRITICAL));
        }
        NodeDraftImpl node = new NodeDraftImpl(this.container, id);
        return node;
    }

    @Override
    public EdgeDraftImpl newEdgeDraft() {
        EdgeDraftImpl edge = new EdgeDraftImpl(this.container, String.valueOf(EDGE_IDS.getAndIncrement()));
        return edge;
    }

    @Override
    public EdgeDraftImpl newEdgeDraft(String id) {
        if (id == null) {
            String message = NbBundle.getMessage(ElementFactoryImpl.class, (String)"ElementFactoryException_NullEdgeId");
            this.container.getReport().logIssue(new Issue(message, Issue.Level.CRITICAL));
        }
        EdgeDraftImpl edge = new EdgeDraftImpl(this.container, id);
        return edge;
    }
}

