/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class UIUtils {
    public static final String PROP_EXPANSION_TRANSACTION = "expansion_transaction";
    public static Dimension DIMENSION_SMALLEST = new Dimension(0, 0);
    private static final Logger LOGGER = Logger.getLogger(UIUtils.class.getName());
    public static final float ALTERNATE_ROW_DARKER_FACTOR = 0.96f;
    private static final int MAX_TREE_AUTOEXPAND_LINES = 50;
    private static boolean toolTipValuesInitialized = false;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;
    private static Color disabledLineColor;
    private static Map<Integer, Color> DARKER_CACHE;
    private static Color profilerResultsBackground;

    public static void decorateProfilerPanel(JPanel jPanel) {
        Color color = UIManager.getColor("ProfilerPanels.background");
        if (color != null) {
            jPanel.setOpaque(true);
            jPanel.setBackground(color);
        }
    }

    public static JPanel createFillerPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 3)){

            @Override
            public Dimension getPreferredSize() {
                return DIMENSION_SMALLEST;
            }
        };
        jPanel.setOpaque(false);
        return jPanel;
    }

    public static JSeparator createHorizontalSeparator() {
        JSeparator jSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        return jSeparator;
    }

    public static JSeparator createHorizontalLine(Color color) {
        final boolean bl = UIUtils.isNimbus();
        JSeparator jSeparator = new JSeparator(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, 1);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 1);
            }

            @Override
            public void paint(Graphics graphics) {
                if (bl) {
                    graphics.setColor(UIUtils.getDisabledLineColor());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    super.paint(graphics);
                }
            }
        };
        jSeparator.setBackground(color);
        return jSeparator;
    }

    public static boolean isAquaLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    public static Color getDarker(Color color) {
        int n;
        Color color2;
        if (DARKER_CACHE == null) {
            DARKER_CACHE = new HashMap<Integer, Color>();
        }
        if ((color2 = DARKER_CACHE.get(n = color.getRGB())) == null) {
            color2 = color.equals(Color.WHITE) ? new Color(244, 244, 244) : UIUtils.getSafeColor((int)((float)color.getRed() * 0.96f), (int)((float)color.getGreen() * 0.96f), (int)((float)color.getBlue() * 0.96f));
            DARKER_CACHE.put(n, color2);
        }
        return color2;
    }

    public static Color getDarkerLine(Color color, float f) {
        return UIUtils.getSafeColor((int)((float)color.getRed() * f), (int)((float)color.getGreen() * f), (int)((float)color.getBlue() * f));
    }

    public static Color getDisabledForeground(Color color) {
        if (UIUtils.isNimbusLookAndFeel()) {
            return UIManager.getColor("nimbusDisabledText").darker();
        }
        if (UIUtils.isMetalLookAndFeel()) {
            return UIManager.getColor("Label.disabledForeground");
        }
        if (Color.BLACK.equals(color)) {
            return Color.GRAY;
        }
        return color.brighter();
    }

    public static int getDefaultRowHeight() {
        return new JLabel((String)"X").getPreferredSize().height + 2;
    }

    public static boolean isGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    public static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Nimbus");
    }

    public static boolean isNimbusGTKTheme() {
        return UIUtils.isGTKLookAndFeel() && "nimbus".equals(Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Net/ThemeName"));
    }

    public static boolean isNimbus() {
        return UIUtils.isNimbusLookAndFeel() || UIUtils.isNimbusGTKTheme();
    }

    public static boolean isMetalLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Metal");
    }

    public static int getNextSubTabIndex(JTabbedPane jTabbedPane, int n) {
        int n2 = n;
        for (int i = 0; i < jTabbedPane.getComponentCount(); ++i) {
            if (++n2 == jTabbedPane.getComponentCount()) {
                n2 = 0;
            }
            if (jTabbedPane.isEnabledAt(n2)) break;
        }
        return n2;
    }

    public static Window getParentWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public static int getPreviousSubTabIndex(JTabbedPane jTabbedPane, int n) {
        int n2 = n;
        for (int i = 0; i < jTabbedPane.getComponentCount(); ++i) {
            if (--n2 < 0) {
                n2 = jTabbedPane.getComponentCount() - 1;
            }
            if (jTabbedPane.isEnabledAt(n2)) break;
        }
        return n2;
    }

    public static Color getSafeColor(int n, int n2, int n3) {
        n = Math.max(n, 0);
        n = Math.min(n, 255);
        n2 = Math.max(n2, 0);
        n2 = Math.min(n2, 255);
        n3 = Math.max(n3, 0);
        n3 = Math.min(n3, 255);
        return new Color(n, n2, n3);
    }

    public static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    public static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    private static Color getGTKProfilerResultsBackground() {
        int[] nArray = new int[]{-1};
        JTextArea jTextArea = new JTextArea();
        jTextArea.setSize(new Dimension(10, 10));
        jTextArea.doLayout();
        BufferedImage bufferedImage = new BufferedImage(jTextArea.getSize().width, jTextArea.getSize().height, 1);
        jTextArea.printAll(((Image)bufferedImage).getGraphics());
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 5, 5, 1, 1, nArray, 0, 1);
        try {
            pixelGrabber.grabPixels();
            if (nArray[0] == -1) {
                return Color.WHITE;
            }
        }
        catch (InterruptedException interruptedException) {
            return UIUtils.getNonGTKProfilerResultsBackground();
        }
        return nArray[0] != -1 ? new Color(nArray[0]) : UIUtils.getNonGTKProfilerResultsBackground();
    }

    private static Color getNonGTKProfilerResultsBackground() {
        return UIManager.getColor("Table.background");
    }

    public static Color getProfilerResultsBackground() {
        if (profilerResultsBackground == null && (profilerResultsBackground = UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel() ? UIUtils.getGTKProfilerResultsBackground() : UIUtils.getNonGTKProfilerResultsBackground()) == null) {
            profilerResultsBackground = Color.WHITE;
        }
        return profilerResultsBackground;
    }

    public static boolean isWindowsClassicLookAndFeel() {
        if (!UIUtils.isWindowsLookAndFeel()) {
            return false;
        }
        return !UIUtils.isWindowsXPLookAndFeel();
    }

    public static boolean isWindowsLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    public static boolean isWindowsXPLookAndFeel() {
        if (!UIUtils.isWindowsLookAndFeel()) {
            return false;
        }
        boolean bl = Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
        boolean bl2 = System.getProperty("swing.noxp") != null;
        return bl && !bl2;
    }

    public static void autoExpand(JTree jTree, TreePath treePath, int n, int n2, boolean bl) {
        TreeModel treeModel = jTree.getModel();
        Object object = treePath.getLastPathComponent();
        TreePath treePath2 = treePath;
        int n3 = 0;
        block0: while (n3++ < n && !treeModel.isLeaf(object) && treeModel.getChildCount(object) > 0 && treeModel.getChildCount(object) <= n2) {
            for (int i = 0; i < treeModel.getChildCount(object); ++i) {
                object = jTree.getModel().getChild(object, i);
                if (treeModel.isLeaf(object)) continue;
                if (bl && UIUtils.hasOnlyLeafs(jTree, object)) continue block0;
                treePath2 = treePath2.pathByAddingChild(object);
                continue block0;
            }
        }
        jTree.expandPath(treePath2);
    }

    public static void autoExpandRoot(JTree jTree) {
        UIUtils.autoExpandRoot(jTree, 1);
    }

    public static void autoExpandRoot(JTree jTree, int n) {
        Object object = jTree.getModel().getRoot();
        if (object == null) {
            return;
        }
        TreePath treePath = new TreePath(object);
        UIUtils.autoExpand(jTree, treePath, 50, n, false);
    }

    public static long[] copyArray(long[] lArray) {
        if (lArray == null) {
            return new long[0];
        }
        if (lArray.length == 0) {
            return new long[0];
        }
        long[] lArray2 = new long[lArray.length];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    public static int[] copyArray(int[] nArray) {
        if (nArray == null) {
            return new int[0];
        }
        if (nArray.length == 0) {
            return new int[0];
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static float[] copyArray(float[] fArray) {
        if (fArray == null) {
            return new float[0];
        }
        if (fArray.length == 0) {
            return new float[0];
        }
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public static BufferedImage createScreenshot(Component component) {
        if (component instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)component;
            return UIUtils.createComponentScreenshot(jScrollPane.getViewport());
        }
        return UIUtils.createComponentScreenshot(component);
    }

    public static void ensureMinimumSize(Component component) {
        if ((component = UIUtils.getParentWindow(component)) != null) {
            final Component component2 = component;
            component2.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    Dimension dimension = component2.getSize();
                    Dimension dimension2 = component2.getMinimumSize();
                    if (dimension.width < dimension2.width || dimension.height < dimension2.height) {
                        component2.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
                    }
                }
            });
        }
    }

    public static void fixButtonUI(AbstractButton abstractButton) {
    }

    public static boolean hasOnlyLeafs(JTree jTree, Object object) {
        TreeModel treeModel = jTree.getModel();
        for (int i = 0; i < treeModel.getChildCount(object); ++i) {
            if (treeModel.isLeaf(treeModel.getChild(object, i))) continue;
            return false;
        }
        return true;
    }

    public static void makeTreeAutoExpandable(JTree jTree) {
        UIUtils.makeTreeAutoExpandable(jTree, 1, false);
    }

    public static void makeTreeAutoExpandable(JTree jTree, boolean bl) {
        UIUtils.makeTreeAutoExpandable(jTree, 1, bl);
    }

    public static void makeTreeAutoExpandable(JTree jTree, int n) {
        UIUtils.makeTreeAutoExpandable(jTree, n, false);
    }

    public static void makeTreeAutoExpandable(final JTree jTree, final int n, final boolean bl) {
        jTree.addTreeExpansionListener(new TreeExpansionListener(){
            boolean internalChange = false;

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                if (this.internalChange || Boolean.TRUE.equals(jTree.getClientProperty(UIUtils.PROP_EXPANSION_TRANSACTION))) {
                    return;
                }
                TreePath treePath = treeExpansionEvent.getPath();
                JTree jTree2 = (JTree)treeExpansionEvent.getSource();
                this.internalChange = true;
                UIUtils.autoExpand(jTree2, treePath, 50, n, bl);
                this.internalChange = false;
            }
        });
    }

    public static void runInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.severe(invocationTargetException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                LOGGER.severe(interruptedException.getMessage());
            }
        }
    }

    public static void addBorder(JComponent jComponent, Border border) {
        Border border2 = jComponent.getBorder();
        Border border3 = border2 == null ? border : new CompoundBorder(border2, border);
        jComponent.setBorder(border3);
    }

    public static Color getDisabledLineColor() {
        if (disabledLineColor == null) {
            disabledLineColor = UIManager.getColor("Label.disabledForeground");
            if (disabledLineColor == null) {
                disabledLineColor = UIManager.getColor("Label.disabledText");
            }
            if (disabledLineColor == null) {
                disabledLineColor = Color.GRAY;
            }
        }
        return disabledLineColor;
    }

    private static BufferedImage createComponentScreenshot(final Component component) {
        final BufferedImage[] bufferedImageArray = new BufferedImage[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                bufferedImageArray[0] = component instanceof JTable || component instanceof JViewport && ((JViewport)component).getView() instanceof JTable ? UIUtils.createTableScreenshot(component) : UIUtils.createGeneralComponentScreenshot(component);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return bufferedImageArray[0];
    }

    private static BufferedImage createGeneralComponentScreenshot(Component component) {
        Dimension dimension;
        Component component2;
        Object object;
        Object object2;
        if (component instanceof JViewport) {
            object2 = (JViewport)component;
            object = ((JViewport)object2).getView();
            if (((Component)object).getSize().height > ((Component)object2).getSize().height) {
                component2 = component;
                dimension = component.getSize();
            } else {
                component2 = object;
                dimension = ((Component)object).getSize();
            }
        } else {
            component2 = component;
            dimension = component.getSize();
        }
        object2 = new BufferedImage(dimension.width, dimension.height, 1);
        object = ((BufferedImage)object2).getGraphics();
        component2.printAll((Graphics)object);
        return object2;
    }

    private static BufferedImage createTableScreenshot(Component component) {
        JComponent jComponent;
        Dimension dimension;
        JComponent jComponent2;
        JTable jTable;
        if (component instanceof JTable) {
            jTable = (JTable)component;
            if (jTable.getTableHeader() == null || !jTable.getTableHeader().isVisible()) {
                return UIUtils.createGeneralComponentScreenshot(component);
            }
            jComponent2 = jTable;
            dimension = jTable.getSize();
        } else if (component instanceof JViewport && ((JViewport)component).getView() instanceof JTable) {
            jComponent = (JViewport)component;
            jTable = (JTable)((JViewport)jComponent).getView();
            if (jTable.getTableHeader() == null || !jTable.getTableHeader().isVisible()) {
                return UIUtils.createGeneralComponentScreenshot(component);
            }
            if (jTable.getSize().height > jComponent.getSize().height) {
                jComponent2 = jComponent;
                dimension = jComponent.getSize();
            } else {
                jComponent2 = jTable;
                dimension = jTable.getSize();
            }
        } else {
            throw new IllegalArgumentException("Component can only be JTable or JViewport holding JTable");
        }
        jComponent = jTable.getTableHeader();
        Dimension dimension2 = jComponent.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension2.height + dimension.height, 1);
        final Graphics graphics = bufferedImage.getGraphics();
        if (SwingUtilities.isEventDispatchThread()) {
            jComponent.printAll(graphics);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable((JTableHeader)jComponent, graphics){
                    final /* synthetic */ JTableHeader val$tableHeader;
                    final /* synthetic */ Graphics val$tableScreenshotGraphics;
                    {
                        this.val$tableHeader = jTableHeader;
                        this.val$tableScreenshotGraphics = graphics;
                    }

                    @Override
                    public void run() {
                        this.val$tableHeader.printAll(this.val$tableScreenshotGraphics);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        graphics.translate(0, dimension2.height);
        final JComponent jComponent3 = jComponent2;
        if (SwingUtilities.isEventDispatchThread()) {
            ((Component)jComponent3).printAll(graphics);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        jComponent3.printAll(graphics);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bufferedImage;
    }
}

