/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CoverageData {
    public static final String STARTED = "";
    private static final int[] SVALUE = new int[0];
    private volatile Map<String, int[]> coverage;
    private final EventHook COVERAGE_HOOK = new EventHook(){

        @Override
        public synchronized void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
            if (CoverageData.this.coverage == null || line <= 0) {
                return;
            }
            int[] lines2 = (int[])CoverageData.this.coverage.get(file2);
            if (lines2 == null) {
                return;
            }
            if (lines2.length == 0) {
                return;
            }
            int n = line - 1;
            lines2[n] = lines2[n] + 1;
        }

        @Override
        public boolean isInterestedInEvent(RubyEvent event2) {
            return event2 == RubyEvent.COVERAGE;
        }
    };

    public boolean isCoverageEnabled() {
        return this.coverage != null && this.coverage.get(STARTED) != null;
    }

    public Map<String, int[]> getCoverage() {
        return this.coverage;
    }

    public synchronized void setCoverageEnabled(Ruby runtime, boolean enabled) {
        Map<String, int[]> coverage2 = this.coverage;
        if (coverage2 == null) {
            coverage2 = new HashMap<String, int[]>();
        }
        if (enabled) {
            coverage2.put(STARTED, SVALUE);
            runtime.addEventHook(this.COVERAGE_HOOK);
        } else {
            coverage2.remove(STARTED);
        }
        this.coverage = coverage2;
    }

    public synchronized Map<String, int[]> resetCoverage(Ruby runtime) {
        Map<String, int[]> coverage2 = this.coverage;
        runtime.removeEventHook(this.COVERAGE_HOOK);
        coverage2.remove(STARTED);
        for (Map.Entry<String, int[]> entry : coverage2.entrySet()) {
            String key2 = entry.getKey();
            if (key2.equals(STARTED) || !this.hasCodeBeenPartiallyCovered(entry.getValue())) continue;
            coverage2.put(key2, SVALUE);
        }
        return coverage2;
    }

    private boolean hasCodeBeenPartiallyCovered(int[] lines2) {
        for (int i2 = 0; i2 < lines2.length; ++i2) {
            if (lines2[i2] <= 0) continue;
            return true;
        }
        return false;
    }

    public synchronized Map<String, int[]> prepareCoverage(String filename2, int[] lines2) {
        assert (lines2 != null);
        Map<String, int[]> coverage2 = this.coverage;
        if (coverage2 != null) {
            coverage2.put(filename2, lines2);
        }
        return coverage2;
    }
}

