/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;

public class DoccatFactory
extends BaseToolFactory {
    private static final String FEATURE_GENERATORS = "doccat.featureGenerators";
    private static final String TOKENIZER_NAME = "doccat.tokenizer";
    private FeatureGenerator[] featureGenerators;
    private Tokenizer tokenizer;

    public DoccatFactory() {
        this.tokenizer = WhitespaceTokenizer.INSTANCE;
    }

    public DoccatFactory(FeatureGenerator[] featureGenerators) {
        this.tokenizer = WhitespaceTokenizer.INSTANCE;
        this.featureGenerators = featureGenerators;
    }

    @Deprecated
    public DoccatFactory(Tokenizer tokenizer, FeatureGenerator[] featureGenerators) {
        this.init(tokenizer, featureGenerators);
    }

    @Deprecated
    protected void init(Tokenizer tokenizer, FeatureGenerator[] featureGenerators) {
        this.featureGenerators = featureGenerators;
        this.tokenizer = tokenizer;
    }

    protected void init(FeatureGenerator[] featureGenerators) {
        this.featureGenerators = featureGenerators;
    }

    @Override
    public Map<String, String> createManifestEntries() {
        Map<String, String> manifestEntries = super.createManifestEntries();
        if (this.getTokenizer() != null) {
            manifestEntries.put(TOKENIZER_NAME, this.getTokenizer().getClass().getCanonicalName());
        }
        if (this.getFeatureGenerators() != null) {
            manifestEntries.put(FEATURE_GENERATORS, this.featureGeneratorsAsString());
        }
        return manifestEntries;
    }

    private String featureGeneratorsAsString() {
        List<FeatureGenerator> fgs = Arrays.asList(this.getFeatureGenerators());
        Iterator<FeatureGenerator> iter = fgs.iterator();
        StringBuilder sb = new StringBuilder();
        if (iter.hasNext()) {
            sb.append(iter.next().getClass().getCanonicalName());
            while (iter.hasNext()) {
                sb.append(',').append(iter.next().getClass().getCanonicalName());
            }
        }
        return sb.toString();
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }

    @Deprecated
    public static DoccatFactory create(String subclassName, Tokenizer tokenizer, FeatureGenerator[] featureGenerators) throws InvalidFormatException {
        if (subclassName == null) {
            return new DoccatFactory(tokenizer, featureGenerators);
        }
        try {
            DoccatFactory theFactory = ExtensionLoader.instantiateExtension(DoccatFactory.class, subclassName);
            theFactory.init(tokenizer, featureGenerators);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    public static DoccatFactory create(String subclassName, FeatureGenerator[] featureGenerators) throws InvalidFormatException {
        if (subclassName == null) {
            return new DoccatFactory(featureGenerators);
        }
        try {
            DoccatFactory theFactory = ExtensionLoader.instantiateExtension(DoccatFactory.class, subclassName);
            theFactory.init(featureGenerators);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    private FeatureGenerator[] loadFeatureGenerators(String classNames) {
        String[] classes = classNames.split(",");
        FeatureGenerator[] fgs = new FeatureGenerator[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            fgs[i] = ExtensionLoader.instantiateExtension(FeatureGenerator.class, classes[i]);
        }
        return fgs;
    }

    public FeatureGenerator[] getFeatureGenerators() {
        if (this.featureGenerators == null) {
            String classNames;
            if (this.artifactProvider != null && (classNames = this.artifactProvider.getManifestProperty(FEATURE_GENERATORS)) != null) {
                this.featureGenerators = this.loadFeatureGenerators(classNames);
            }
            if (this.featureGenerators == null) {
                this.featureGenerators = new FeatureGenerator[]{new BagOfWordsFeatureGenerator()};
            }
        }
        return this.featureGenerators;
    }

    public void setFeatureGenerators(FeatureGenerator[] featureGenerators) {
        this.featureGenerators = featureGenerators;
    }

    @Deprecated
    public Tokenizer getTokenizer() {
        if (this.tokenizer == null) {
            String className;
            if (this.artifactProvider != null && (className = this.artifactProvider.getManifestProperty(TOKENIZER_NAME)) != null) {
                this.tokenizer = ExtensionLoader.instantiateExtension(Tokenizer.class, className);
            }
            if (this.tokenizer == null) {
                this.tokenizer = WhitespaceTokenizer.INSTANCE;
            }
        }
        return this.tokenizer;
    }

    @Deprecated
    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }
}

