/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core.connections;

import java.io.Closeable;
import java.io.IOException;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;

public class DefaultConnectionSource<T, S extends ConnectionSourceSettings>
implements ConnectionSource<T, S> {
    protected final String name;
    protected final T source;
    protected final S settings;
    protected boolean closed = false;

    public DefaultConnectionSource(String name, T source, S settings) {
        this.name = name;
        this.source = source;
        this.settings = settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getSource() {
        return this.source;
    }

    @Override
    public S getSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.source instanceof Closeable) {
            try {
                ((Closeable)this.source).close();
            }
            finally {
                this.closed = true;
            }
        }
        if (this.source instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.source).close();
            }
            catch (Exception e) {
                throw new IOException("Error closing connection source [" + this.name + "]:" + e.getMessage(), e);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

