/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaUtil {
    public static final RecursionGuard ourParameterGuard = RecursionManager.createGuard("lambdaParameterGuard");
    public static final ThreadLocal<Map<PsiElement, PsiType>> ourFunctionTypes = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance("#" + LambdaUtil.class.getName());

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(PsiFunctionalExpression expr) {
        return LambdaUtil.getFunctionalInterfaceReturnType(expr.getFunctionalInterfaceType());
    }

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(@Nullable PsiType functionalInterfaceType) {
        MethodSignature methodSignature;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            PsiType returnType = LambdaUtil.getReturnType(psiClass, methodSignature);
            return resolveResult.getSubstitutor().substitute(returnType);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiType functionalInterfaceType) {
        return LambdaUtil.getFunctionalInterfaceMethod(PsiUtil.resolveGenericsClassInType(functionalInterfaceType));
    }

    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiElement element) {
        if (element instanceof PsiFunctionalExpression) {
            PsiType samType = ((PsiFunctionalExpression)element).getFunctionalInterfaceType();
            return LambdaUtil.getFunctionalInterfaceMethod(samType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@NotNull PsiClassType.ClassResolveResult result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/LambdaUtil", "getFunctionalInterfaceMethod"));
        }
        return LambdaUtil.getFunctionalInterfaceMethod(result2.getElement());
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClass aClass2) {
        MethodSignature methodSignature = LambdaUtil.getFunction(aClass2);
        if (methodSignature != null) {
            return LambdaUtil.getMethod(aClass2, methodSignature);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutor(@NotNull PsiMethod method, @NotNull PsiClassType.ClassResolveResult resolveResult) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        PsiClass derivedClass = resolveResult.getElement();
        LOG.assertTrue(derivedClass != null);
        PsiClass methodContainingClass = method.getContainingClass();
        LOG.assertTrue(methodContainingClass != null);
        PsiSubstitutor initialSubst = resolveResult.getSubstitutor();
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(methodContainingClass, derivedClass, PsiSubstitutor.EMPTY);
        for (PsiTypeParameter param : superClassSubstitutor.getSubstitutionMap().keySet()) {
            initialSubst = initialSubst.put(param, initialSubst.substitute(superClassSubstitutor.substitute(param)));
        }
        return initialSubst;
    }

    public static boolean isFunctionalType(PsiType type2) {
        if (type2 instanceof PsiIntersectionType) {
            return LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)type2) != null;
        }
        return LambdaUtil.isFunctionalClass(PsiUtil.resolveClassInClassTypeOnly(type2));
    }

    @Contract(value="null -> false")
    public static boolean isFunctionalClass(PsiClass aClass2) {
        if (aClass2 != null) {
            if (aClass2 instanceof PsiTypeParameter) {
                return false;
            }
            return LambdaUtil.getFunction(aClass2) != null;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isValidLambdaContext(@Nullable PsiElement context) {
        if (LambdaUtil.isAssignmentOrInvocationContext(context = PsiUtil.skipParenthesizedExprUp(context)) || context instanceof PsiTypeCastExpression) {
            return true;
        }
        if (context instanceof PsiConditionalExpression) {
            PsiElement parentContext = PsiUtil.skipParenthesizedExprUp(context.getParent());
            if (LambdaUtil.isAssignmentOrInvocationContext(parentContext)) {
                return true;
            }
            if (parentContext instanceof PsiConditionalExpression) {
                return LambdaUtil.isValidLambdaContext(parentContext);
            }
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean isAssignmentOrInvocationContext(PsiElement context) {
        return LambdaUtil.isAssignmentContext(context) || LambdaUtil.isInvocationContext(context);
    }

    private static boolean isInvocationContext(@Nullable PsiElement context) {
        return context instanceof PsiExpressionList;
    }

    private static boolean isAssignmentContext(PsiElement context) {
        return context instanceof PsiLambdaExpression || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression || context instanceof PsiVariable || context instanceof PsiArrayInitializerExpression;
    }

    public static boolean isLambdaFullyInferred(PsiLambdaExpression expression2, PsiType functionalInterfaceType) {
        boolean hasParams;
        boolean bl = hasParams = expression2.getParameterList().getParametersCount() > 0;
        if (hasParams || !PsiType.VOID.equals(LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType))) {
            return !LambdaUtil.dependsOnTypeParams(functionalInterfaceType, functionalInterfaceType, expression2, new PsiTypeParameter[0]);
        }
        return true;
    }

    @Contract(value="null -> null")
    @Nullable
    public static MethodSignature getFunction(PsiClass psiClass) {
        if (LambdaUtil.isPlainInterface(psiClass)) {
            return (MethodSignature)CachedValuesManager.getCachedValue(psiClass, () -> CachedValueProvider.Result.create(LambdaUtil.calcFunction(psiClass), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT));
        }
        return null;
    }

    private static boolean isPlainInterface(PsiClass psiClass) {
        return psiClass != null && psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    @Nullable
    private static MethodSignature calcFunction(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/LambdaUtil", "calcFunction"));
        }
        if (LambdaUtil.hasManyOwnAbstractMethods(psiClass) || LambdaUtil.hasManyInheritedAbstractMethods(psiClass)) {
            return null;
        }
        List<HierarchicalMethodSignature> functions2 = LambdaUtil.findFunctionCandidates(psiClass);
        return functions2 != null && functions2.size() == 1 ? (MethodSignature)functions2.get(0) : null;
    }

    private static boolean hasManyOwnAbstractMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/LambdaUtil", "hasManyOwnAbstractMethods"));
        }
        int abstractCount = 0;
        for (PsiMethod method : psiClass.getMethods()) {
            if (!LambdaUtil.isDefinitelyAbstractInterfaceMethod(method) || ++abstractCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefinitelyAbstractInterfaceMethod(PsiMethod method) {
        return method.hasModifierProperty("abstract") && !LambdaUtil.isPublicObjectMethod(method.getName());
    }

    private static boolean isPublicObjectMethod(String methodName) {
        return "equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName);
    }

    private static boolean hasManyInheritedAbstractMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/LambdaUtil", "hasManyInheritedAbstractMethods"));
        }
        HashSet abstractNames = ContainerUtil.newHashSet();
        HashSet defaultNames = ContainerUtil.newHashSet();
        InheritanceUtil.processSupers(psiClass, true, psiClass1 -> {
            for (PsiMethod method : psiClass1.getMethods()) {
                if (LambdaUtil.isDefinitelyAbstractInterfaceMethod(method)) {
                    abstractNames.add(method.getName());
                    continue;
                }
                if (!method.hasModifierProperty("default")) continue;
                defaultNames.add(method.getName());
            }
            return true;
        });
        abstractNames.removeAll(defaultNames);
        return abstractNames.size() > 1;
    }

    private static boolean overridesPublicObjectMethod(HierarchicalMethodSignature psiMethod) {
        PsiMethod method;
        PsiClass containingClass;
        List<HierarchicalMethodSignature> signatures = psiMethod.getSuperSignatures();
        if (signatures.isEmpty() && (containingClass = (method = psiMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && method.hasModifierProperty("public")) {
            return true;
        }
        for (HierarchicalMethodSignature superMethod : signatures) {
            if (!LambdaUtil.overridesPublicObjectMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static MethodSignature getMethodSignature(PsiMethod method, PsiClass psiClass, PsiClass containingClass) {
        MethodSignature methodSignature = containingClass != null && containingClass != psiClass ? method.getSignature(TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY)) : method.getSignature(PsiSubstitutor.EMPTY);
        return methodSignature;
    }

    @NotNull
    private static List<HierarchicalMethodSignature> hasSubsignature(List<HierarchicalMethodSignature> signatures) {
        for (HierarchicalMethodSignature signature : signatures) {
            boolean subsignature = true;
            for (HierarchicalMethodSignature methodSignature : signatures) {
                if (signature.equals(methodSignature) || LambdaUtil.skipMethod(signature, methodSignature)) continue;
                subsignature = false;
                break;
            }
            if (!subsignature) continue;
            List<HierarchicalMethodSignature> list2 = Collections.singletonList(signature);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LambdaUtil", "hasSubsignature"));
            }
            return list2;
        }
        List<HierarchicalMethodSignature> list3 = signatures;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LambdaUtil", "hasSubsignature"));
        }
        return list3;
    }

    private static boolean skipMethod(HierarchicalMethodSignature signature, HierarchicalMethodSignature methodSignature) {
        if (methodSignature.getTypeParameters().length == 0) {
            return false;
        }
        return signature.getMethod().getContainingClass() != methodSignature.getMethod().getContainingClass();
    }

    @Contract(value="null -> null")
    @Nullable
    public static List<HierarchicalMethodSignature> findFunctionCandidates(@Nullable PsiClass psiClass) {
        if (!LambdaUtil.isPlainInterface(psiClass)) {
            return null;
        }
        ArrayList<HierarchicalMethodSignature> methods2 = new ArrayList<HierarchicalMethodSignature>();
        Map<MethodSignature, Set<PsiMethod>> overrideEquivalents = PsiSuperMethodUtil.collectOverrideEquivalents(psiClass);
        Collection<HierarchicalMethodSignature> visibleSignatures = psiClass.getVisibleSignatures();
        for (HierarchicalMethodSignature signature : visibleSignatures) {
            PsiMethod psiMethod = signature.getMethod();
            if (!psiMethod.hasModifierProperty("abstract") || psiMethod.hasModifierProperty("static")) continue;
            Set<PsiMethod> equivalentMethods = overrideEquivalents.get(signature);
            if (equivalentMethods != null && equivalentMethods.size() > 1) {
                boolean hasNonAbstractOverrideEquivalent = false;
                for (PsiMethod method : equivalentMethods) {
                    if (method.hasModifierProperty("abstract") || MethodSignatureUtil.isSuperMethod(method, psiMethod)) continue;
                    hasNonAbstractOverrideEquivalent = true;
                    break;
                }
                if (hasNonAbstractOverrideEquivalent) continue;
            }
            if (LambdaUtil.overridesPublicObjectMethod(signature)) continue;
            methods2.add(signature);
        }
        return LambdaUtil.hasSubsignature(methods2);
    }

    @Nullable
    private static PsiType getReturnType(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod method = LambdaUtil.getMethod(psiClass, methodSignature);
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY).substitute(method.getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod[] methodsByName;
        if (methodSignature instanceof MethodSignatureBackedByPsiMethod) {
            return ((MethodSignatureBackedByPsiMethod)methodSignature).getMethod();
        }
        for (PsiMethod psiMethod : methodsByName = psiClass.findMethodsByName(methodSignature.getName(), true)) {
            if (!MethodSignatureUtil.areSignaturesEqual(LambdaUtil.getMethodSignature(psiMethod, psiClass, psiMethod.getContainingClass()), methodSignature)) continue;
            return psiMethod;
        }
        return null;
    }

    public static int getLambdaIdx(PsiExpressionList expressionList, PsiElement element) {
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression2 = expressions[i];
            if (!PsiTreeUtil.isAncestor(expression2, element, false)) continue;
            return i;
        }
        return -1;
    }

    public static boolean dependsOnTypeParams(PsiType type2, PsiType functionalInterfaceType, PsiElement lambdaExpression, PsiTypeParameter ... param2Check) {
        return LambdaUtil.depends(type2, new TypeParamsChecker(lambdaExpression, PsiUtil.resolveClassInType(functionalInterfaceType)), param2Check);
    }

    public static boolean depends(PsiType type2, TypeParamsChecker visitor2, PsiTypeParameter ... param2Check) {
        if (!visitor2.startedInference()) {
            return false;
        }
        Boolean accept = type2.accept(visitor2);
        if (param2Check.length > 0) {
            return visitor2.used(param2Check);
        }
        return accept != null && accept != false;
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression2, boolean tryToSubstitute) {
        PsiType type2;
        PsiElement parent2 = expression2.getParent();
        PsiElement element = expression2;
        while (!(!(parent2 instanceof PsiParenthesizedExpression) && !(parent2 instanceof PsiConditionalExpression) || parent2 instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent2).getThenExpression() != element && ((PsiConditionalExpression)parent2).getElseExpression() != element)) {
            element = parent2;
            parent2 = parent2.getParent();
        }
        Map<PsiElement, PsiType> map2 = ourFunctionTypes.get();
        if (map2 != null && (type2 = map2.get(expression2)) != null) {
            return type2;
        }
        if (parent2 instanceof PsiArrayInitializerExpression) {
            PsiType psiType = ((PsiArrayInitializerExpression)parent2).getType();
            if (psiType instanceof PsiArrayType) {
                return ((PsiArrayType)psiType).getComponentType();
            }
        } else {
            if (parent2 instanceof PsiTypeCastExpression) {
                PsiType conjunct;
                PsiType castType;
                PsiTypeElement castTypeElement = ((PsiTypeCastExpression)parent2).getCastType();
                PsiType psiType = castType = castTypeElement != null ? castTypeElement.getType() : null;
                if (castType instanceof PsiIntersectionType && (conjunct = LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)castType)) != null) {
                    return conjunct;
                }
                return castType;
            }
            if (parent2 instanceof PsiVariable) {
                return ((PsiVariable)parent2).getType();
            }
            if (parent2 instanceof PsiAssignmentExpression && expression2 instanceof PsiExpression && !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression2)) {
                PsiExpression lExpression = ((PsiAssignmentExpression)parent2).getLExpression();
                return lExpression.getType();
            }
            if (parent2 instanceof PsiExpressionList) {
                PsiExpressionList expressionList = (PsiExpressionList)parent2;
                int lambdaIdx = LambdaUtil.getLambdaIdx(expressionList, expression2);
                if (lambdaIdx > -1) {
                    PsiElement gParent = expressionList.getParent();
                    if (gParent instanceof PsiAnonymousClass) {
                        gParent = gParent.getParent();
                    }
                    if (gParent instanceof PsiCall) {
                        PsiCall contextCall = (PsiCall)gParent;
                        MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(contextCall.getArgumentList());
                        if (properties2 != null && properties2.isApplicabilityCheck()) {
                            PsiParameter[] parameters2 = properties2.getMethod().getParameterList().getParameters();
                            int finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, properties2.getMethod(), parameters2);
                            if (finalLambdaIdx < parameters2.length) {
                                return properties2.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]));
                            }
                        }
                        JavaResolveResult resolveResult = properties2 != null ? properties2.getInfo() : contextCall.resolveMethodGenerics();
                        return LambdaUtil.getSubstitutedType(expression2, tryToSubstitute, lambdaIdx, resolveResult);
                    }
                }
            } else {
                if (parent2 instanceof PsiReturnStatement) {
                    return PsiTypesUtil.getMethodReturnType(parent2);
                }
                if (parent2 instanceof PsiLambdaExpression) {
                    return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)parent2);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getSubstitutedType(PsiElement expression2, boolean tryToSubstitute, int lambdaIdx, JavaResolveResult resolveResult) {
        PsiParameter[] parameters2;
        int finalLambdaIdx;
        PsiElement resolve2 = resolveResult.getElement();
        if (resolve2 instanceof PsiMethod && (finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)resolve2, parameters2 = ((PsiMethod)resolve2).getParameterList().getParameters())) < parameters2.length) {
            if (!tryToSubstitute) {
                return LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]);
            }
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression2, !MethodCandidateInfo.isOverloadCheck(), () -> {
                PsiType normalizedType = LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]);
                if (resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isRawSubstitution()) {
                    return TypeConversionUtil.erasure(normalizedType);
                }
                return resolveResult.getSubstitutor().substitute(normalizedType);
            });
        }
        return null;
    }

    public static boolean processParentOverloads(PsiFunctionalExpression functionalExpression, Consumer<PsiType> overloadProcessor) {
        PsiExpressionList expressionList;
        int lambdaIdx;
        LOG.assertTrue(PsiTypesUtil.getExpectedTypeByParent(functionalExpression) == null);
        PsiElement parent2 = functionalExpression.getParent();
        PsiElement expr = functionalExpression;
        while (!(!(parent2 instanceof PsiParenthesizedExpression) && !(parent2 instanceof PsiConditionalExpression) || parent2 instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent2).getThenExpression() != expr && ((PsiConditionalExpression)parent2).getElseExpression() != expr)) {
            expr = parent2;
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof PsiExpressionList && (lambdaIdx = LambdaUtil.getLambdaIdx(expressionList = (PsiExpressionList)parent2, functionalExpression)) > -1) {
            PsiElement gParent = expressionList.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiMethodCallExpression) {
                JavaResolveResult[] results;
                HashSet<PsiType> types = new HashSet<PsiType>();
                for (JavaResolveResult result2 : results = ((PsiMethodCallExpression)gParent).getMethodExpression().multiResolve(true)) {
                    PsiType functionalExpressionType = LambdaUtil.getSubstitutedType(functionalExpression, true, lambdaIdx, result2);
                    if (functionalExpressionType == null || !types.add(functionalExpressionType)) continue;
                    overloadProcessor.consume(functionalExpressionType);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiType extractFunctionalConjunct(PsiIntersectionType type2) {
        PsiType conjunct = null;
        for (PsiType conjunctType : type2.getConjuncts()) {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(conjunctType);
            if (interfaceMethod == null) continue;
            if (conjunct != null && !conjunct.equals(conjunctType)) {
                return null;
            }
            conjunct = conjunctType;
        }
        return conjunct;
    }

    private static PsiType getFunctionalInterfaceTypeByContainingLambda(@NotNull PsiLambdaExpression parentLambda) {
        if (parentLambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLambda", "com/intellij/psi/LambdaUtil", "getFunctionalInterfaceTypeByContainingLambda"));
        }
        PsiType parentInterfaceType = parentLambda.getFunctionalInterfaceType();
        return parentInterfaceType != null ? LambdaUtil.getFunctionalInterfaceReturnType(parentInterfaceType) : null;
    }

    private static int adjustLambdaIdx(int lambdaIdx, PsiMethod resolve2, PsiParameter[] parameters2) {
        int finalLambdaIdx = resolve2.isVarArgs() && lambdaIdx >= parameters2.length ? parameters2.length - 1 : lambdaIdx;
        return finalLambdaIdx;
    }

    private static PsiType getNormalizedType(PsiParameter parameter) {
        PsiType type2 = parameter.getType();
        if (type2 instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)type2).getComponentType();
        }
        return type2;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean notInferredType(PsiType typeByExpression) {
        return typeByExpression instanceof PsiMethodReferenceType || typeByExpression instanceof PsiLambdaExpressionType || typeByExpression instanceof PsiLambdaParameterType;
    }

    public static boolean isLambdaReturnExpression(PsiElement element) {
        PsiElement parent2 = element.getParent();
        return parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, true, PsiMethod.class) != null;
    }

    public static PsiReturnStatement[] getReturnStatements(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        return body instanceof PsiCodeBlock ? PsiUtil.findReturnStatements((PsiCodeBlock)body) : PsiReturnStatement.EMPTY_ARRAY;
    }

    public static List<PsiExpression> getReturnExpressions(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            return Collections.singletonList((PsiExpression)body);
        }
        ArrayList<PsiExpression> result2 = new ArrayList<PsiExpression>();
        for (PsiReturnStatement returnStatement : LambdaUtil.getReturnStatements(lambdaExpression)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            result2.add(returnValue);
        }
        return result2;
    }

    public static boolean isValidQualifier4InterfaceStaticMethodCall(@NotNull PsiMethod method, @NotNull PsiReferenceExpression methodReferenceExpression, @Nullable PsiElement scope, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        return LambdaUtil.getInvalidQualifier4StaticInterfaceMethodMessage(method, methodReferenceExpression, scope, languageLevel) == null;
    }

    @Nullable
    public static String getInvalidQualifier4StaticInterfaceMethodMessage(@NotNull PsiMethod method, @NotNull PsiReferenceExpression methodReferenceExpression, @Nullable PsiElement scope, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
            if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                return "Static interface method invocations are not supported at this language level";
            }
            if (qualifierExpression == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor(containingClass, methodReferenceExpression, true))) {
                return null;
            }
            if (qualifierExpression instanceof PsiReferenceExpression) {
                PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve2 == containingClass) {
                    return null;
                }
                if (resolve2 instanceof PsiTypeParameter) {
                    HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                    for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                        PsiClass aClass2 = type2.resolve();
                        if (aClass2 == null) continue;
                        classes2.add(aClass2);
                    }
                    if (classes2.size() == 1 && classes2.contains(containingClass)) {
                        return null;
                    }
                }
            }
            return "Static method may be invoked on containing interface class only";
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isExpressionStatementExpression(PsiElement body) {
        return body instanceof PsiAssignmentExpression || body instanceof PsiPrefixExpression && (((PsiPrefixExpression)body).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiPrefixExpression)body).getOperationTokenType() == JavaTokenType.MINUSMINUS) || body instanceof PsiPostfixExpression || body instanceof PsiCallExpression || body instanceof PsiReferenceExpression && !body.isPhysical();
    }

    public static PsiExpression extractSingleExpressionFromBody(PsiElement body) {
        PsiExpression expression2 = null;
        if (body instanceof PsiExpression) {
            expression2 = (PsiExpression)body;
        } else if (body instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length == 1) {
                if (statements[0] instanceof PsiReturnStatement) {
                    expression2 = ((PsiReturnStatement)statements[0]).getReturnValue();
                } else if (statements[0] instanceof PsiExpressionStatement) {
                    expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
                } else if (statements[0] instanceof PsiBlockStatement) {
                    return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)statements[0]).getCodeBlock());
                }
            }
        } else {
            if (body instanceof PsiBlockStatement) {
                return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)body).getCodeBlock());
            }
            if (body instanceof PsiExpressionStatement) {
                expression2 = ((PsiExpressionStatement)body).getExpression();
            }
        }
        return expression2;
    }

    public static boolean isPotentiallyCompatibleWithTypeParameter(PsiFunctionalExpression expression2, PsiExpressionList argsList, PsiMethod method) {
        PsiParameter[] parameters2;
        PsiParameter lambdaParameter;
        PsiClass paramClass;
        PsiCallExpression callExpression;
        if (!(Registry.is("JDK8042508.bug.fixed", false) || (callExpression = PsiTreeUtil.getParentOfType((PsiElement)argsList, PsiCallExpression.class)) != null && callExpression.getTypeArguments().length <= 0)) {
            return false;
        }
        int lambdaIdx = LambdaUtil.getLambdaIdx(argsList, expression2);
        return lambdaIdx >= 0 && (paramClass = PsiUtil.resolveClassInType((lambdaParameter = (parameters2 = method.getParameterList().getParameters())[Math.min(lambdaIdx, parameters2.length - 1)]).getType())) instanceof PsiTypeParameter && ((PsiTypeParameter)paramClass).getOwner() == method;
    }

    @NotNull
    public static Map<PsiElement, PsiType> getFunctionalTypeMap() {
        Map<PsiElement, PsiType> map2 = ourFunctionTypes.get();
        if (map2 == null) {
            map2 = new HashMap<PsiElement, PsiType>();
            ourFunctionTypes.set(map2);
        }
        Map<PsiElement, PsiType> map3 = map2;
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LambdaUtil", "getFunctionalTypeMap"));
        }
        return map3;
    }

    public static Map<PsiElement, String> checkReturnTypeCompatible(PsiLambdaExpression lambdaExpression, PsiType functionalInterfaceReturnType) {
        LinkedHashMap<PsiElement, String> errors;
        block15: {
            errors = new LinkedHashMap<PsiElement, String>();
            if (PsiType.VOID.equals(functionalInterfaceReturnType)) {
                PsiElement body = lambdaExpression.getBody();
                if (body instanceof PsiCodeBlock) {
                    for (PsiExpression expression2 : LambdaUtil.getReturnExpressions(lambdaExpression)) {
                        errors.put(expression2, "Unexpected return value");
                    }
                } else if (body instanceof PsiExpression) {
                    PsiType type2 = ((PsiExpression)body).getType();
                    try {
                        if (PsiUtil.isStatement(JavaPsiFacade.getElementFactory(body.getProject()).createStatementFromText(body.getText(), body))) break block15;
                        if (PsiType.VOID.equals(type2)) {
                            errors.put(body, "Lambda body must be a statement expression");
                            break block15;
                        }
                        errors.put(body, "Bad return type in lambda expression: " + (type2 == PsiType.NULL || type2 == null ? "<null>" : type2.getPresentableText()) + " cannot be converted to void");
                    }
                    catch (IncorrectOperationException expression2) {}
                }
            } else if (functionalInterfaceReturnType != null) {
                List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
                for (PsiExpression expression3 : returnExpressions) {
                    PsiType expressionType = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression3, true, () -> expression3.getType());
                    if (expressionType == null || functionalInterfaceReturnType.isAssignableFrom(expressionType)) continue;
                    errors.put(expression3, "Bad return type in lambda expression: " + expressionType.getPresentableText() + " cannot be converted to " + functionalInterfaceReturnType.getPresentableText());
                }
                PsiReturnStatement[] returnStatements = LambdaUtil.getReturnStatements(lambdaExpression);
                if (returnStatements.length > returnExpressions.size()) {
                    for (PsiReturnStatement statement2 : returnStatements) {
                        PsiExpression value = statement2.getReturnValue();
                        if (value != null) continue;
                        errors.put(statement2, "Missing return value");
                    }
                } else if (returnExpressions.isEmpty() && !lambdaExpression.isVoidCompatible()) {
                    errors.put(lambdaExpression, "Missing return value");
                }
            }
        }
        return errors.isEmpty() ? null : errors;
    }

    @Nullable
    public static PsiType getLambdaParameterFromType(PsiType functionalInterfaceType, int parameterIndex) {
        PsiParameter[] parameters2;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (method != null && parameterIndex < (parameters2 = method.getParameterList().getParameters()).length) {
            return LambdaUtil.getSubstitutor(method, resolveResult).substitute(parameters2[parameterIndex].getType());
        }
        return null;
    }

    public static boolean isLambdaParameterCheck() {
        return !ourParameterGuard.currentStack().isEmpty();
    }

    @Nullable
    public static PsiCall treeWalkUp(PsiElement context) {
        PsiCall top = null;
        Object parent2 = PsiTreeUtil.getParentOfType(context, PsiExpressionList.class, PsiLambdaExpression.class, PsiConditionalExpression.class, PsiCodeBlock.class, PsiCall.class);
        while (!(parent2 instanceof PsiCall)) {
            MethodCandidateInfo.CurrentCandidateProperties properties2;
            PsiCall psiCall;
            PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class);
            if (parent2 instanceof PsiCodeBlock) {
                if (lambdaExpression == null) break;
                boolean inReturnExpressions = false;
                for (PsiExpression expression2 : LambdaUtil.getReturnExpressions(lambdaExpression)) {
                    inReturnExpressions |= PsiTreeUtil.isAncestor(expression2, context, false);
                }
                if (!inReturnExpressions || LambdaUtil.getFunctionalTypeMap().containsKey(lambdaExpression)) break;
            }
            if (parent2 instanceof PsiConditionalExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent2) || parent2 instanceof PsiLambdaExpression && LambdaUtil.getFunctionalTypeMap().containsKey(parent2) || (psiCall = PsiTreeUtil.getParentOfType(parent2, PsiCall.class, false, new Class[]{PsiMember.class, PsiVariable.class})) == null || (properties2 = MethodCandidateInfo.getCurrentMethod(psiCall.getArgumentList())) != null && (properties2.isApplicabilityCheck() || lambdaExpression != null && lambdaExpression.hasFormalParameterTypes()) || !((top = psiCall) instanceof PsiExpression) || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)((Object)top))) break;
            parent2 = PsiTreeUtil.getParentOfType(parent2.getParent(), PsiExpressionList.class, PsiLambdaExpression.class, PsiCodeBlock.class);
        }
        if (top == null) {
            return null;
        }
        PsiExpressionList argumentList2 = top.getArgumentList();
        if (argumentList2 == null) {
            return null;
        }
        LOG.assertTrue(MethodCandidateInfo.getCurrentMethod(argumentList2) == null);
        return top;
    }

    public static PsiCall copyTopLevelCall(@NotNull PsiCall call2) {
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/psi/LambdaUtil", "copyTopLevelCall"));
        }
        PsiCall copyCall = (PsiCall)call2.copy();
        if (call2 instanceof PsiEnumConstant) {
            PsiClass containingClass = ((PsiEnumConstant)call2).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String enumName = containingClass.getName();
            if (enumName == null) {
                return null;
            }
            PsiMethod resolveMethod = call2.resolveMethod();
            if (resolveMethod == null) {
                return null;
            }
            PsiClass anEnum = JavaPsiFacade.getElementFactory(call2.getProject()).createEnum(enumName);
            anEnum.add(resolveMethod);
            return (PsiCall)anEnum.add(call2);
        }
        return copyCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T performWithSubstitutedParameterBounds(PsiTypeParameter[] typeParameters, PsiSubstitutor substitutor2, Producer<T> producer) {
        try {
            for (PsiTypeParameter parameter : typeParameters) {
                PsiClassType[] types = parameter.getExtendsListTypes();
                if (types.length <= 0) continue;
                List<PsiType> conjuncts = ContainerUtil.map(types, type2 -> substitutor2.substitute((PsiType)type2));
                PsiType upperBound = PsiIntersectionType.createIntersection(false, conjuncts.toArray(new PsiType[conjuncts.size()]));
                LambdaUtil.getFunctionalTypeMap().put(parameter, upperBound);
            }
            T t = producer.produce();
            return t;
        }
        finally {
            for (PsiTypeParameter parameter : typeParameters) {
                LambdaUtil.getFunctionalTypeMap().remove(parameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T performWithLambdaTargetType(PsiLambdaExpression lambdaExpression, PsiType targetType, Producer<T> producer) {
        try {
            LambdaUtil.getFunctionalTypeMap().put(lambdaExpression, targetType);
            T t = producer.produce();
            return t;
        }
        finally {
            LambdaUtil.getFunctionalTypeMap().remove(lambdaExpression);
        }
    }

    public static String createLambda(@NotNull PsiVariable variable, @NotNull PsiExpression expression2) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/LambdaUtil", "createLambda"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/LambdaUtil", "createLambda"));
        }
        return variable.getName() + " -> " + expression2.getText();
    }

    public static boolean isIdentityLambda(PsiLambdaExpression lambda2) {
        PsiParameterList parameters2 = lambda2.getParameterList();
        if (parameters2.getParametersCount() != 1) {
            return false;
        }
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown(LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody()));
        return expression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).isReferenceTo(parameters2.getParameters()[0]);
    }

    public static class TypeParamsChecker
    extends PsiTypeVisitor<Boolean> {
        private PsiMethod myMethod;
        private final PsiClass myClass;
        public final Set<PsiTypeParameter> myUsedTypeParams = new HashSet<PsiTypeParameter>();

        public TypeParamsChecker(PsiElement expression2, PsiClass aClass2) {
            PsiElement gParent;
            PsiElement parent2;
            this.myClass = aClass2;
            PsiElement psiElement = parent2 = expression2 != null ? expression2.getParent() : null;
            while (parent2 instanceof PsiParenthesizedExpression) {
                parent2 = parent2.getParent();
            }
            if (parent2 instanceof PsiExpressionList && (gParent = parent2.getParent()) instanceof PsiCall) {
                MethodCandidateInfo.CurrentCandidateProperties pair = MethodCandidateInfo.getCurrentMethod(parent2);
                PsiMethod psiMethod = this.myMethod = pair != null ? pair.getMethod() : null;
                if (this.myMethod == null) {
                    this.myMethod = ((PsiCall)gParent).resolveMethod();
                }
                if (this.myMethod != null && PsiTreeUtil.isAncestor(this.myMethod, expression2, false)) {
                    this.myMethod = null;
                }
            }
        }

        public boolean startedInference() {
            return this.myMethod != null;
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiTypeParameter typeParameter;
            boolean used = false;
            for (PsiType paramType : classType.getParameters()) {
                Boolean paramAccepted = paramType.accept(this);
                used |= paramAccepted != null && paramAccepted != false;
            }
            PsiClass resolve2 = classType.resolve();
            if (resolve2 instanceof PsiTypeParameter && this.check(typeParameter = (PsiTypeParameter)resolve2)) {
                this.myUsedTypeParams.add(typeParameter);
                return true;
            }
            return used;
        }

        @Override
        @Nullable
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                return bound.accept(this);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitType(PsiType type2) {
            return false;
        }

        private boolean check(PsiTypeParameter check2) {
            PsiTypeParameterListOwner owner = check2.getOwner();
            return owner == this.myMethod || owner == this.myClass;
        }

        public boolean used(PsiTypeParameter ... parameters2) {
            for (PsiTypeParameter parameter : parameters2) {
                if (!this.myUsedTypeParams.contains(parameter)) continue;
                return true;
            }
            return false;
        }
    }
}

