/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMapMappingConsumer;

public class SourceMapBuilderConsumer
implements SourceLocationConsumer {
    @NotNull
    private final SourceMapMappingConsumer mappingConsumer;
    @NotNull
    private final SourceFilePathResolver pathResolver;
    private final boolean provideCurrentModuleContent;
    private final boolean provideExternalModuleContent;
    @NotNull
    private final List<Object> sourceStack;

    public SourceMapBuilderConsumer(@NotNull SourceMapMappingConsumer mappingConsumer, @NotNull SourceFilePathResolver pathResolver, boolean provideCurrentModuleContent, boolean provideExternalModuleContent) {
        if (mappingConsumer == null) {
            SourceMapBuilderConsumer.$$$reportNull$$$0(0);
        }
        if (pathResolver == null) {
            SourceMapBuilderConsumer.$$$reportNull$$$0(1);
        }
        this.sourceStack = new ArrayList<Object>();
        this.mappingConsumer = mappingConsumer;
        this.pathResolver = pathResolver;
        this.provideCurrentModuleContent = provideCurrentModuleContent;
        this.provideExternalModuleContent = provideExternalModuleContent;
    }

    @Override
    public void newLine() {
        this.mappingConsumer.newLine();
    }

    @Override
    public void pushSourceInfo(@Nullable Object info) {
        this.sourceStack.add(info);
        this.addMapping(info);
    }

    @Override
    public void popSourceInfo() {
        this.sourceStack.remove(this.sourceStack.size() - 1);
        Object sourceInfo = !this.sourceStack.isEmpty() ? this.sourceStack.get(this.sourceStack.size() - 1) : null;
        this.addMapping(sourceInfo);
    }

    private void addMapping(@Nullable Object sourceInfo) {
        if (sourceInfo == null) {
            this.mappingConsumer.addEmptyMapping();
        }
        if (sourceInfo instanceof PsiElement) {
            PsiElement element = (PsiElement)sourceInfo;
            PsiFile psiFile = element.getContainingFile();
            int offset2 = element.getNode().getStartOffset();
            Document document = psiFile.getViewProvider().getDocument();
            assert (document != null);
            int sourceLine = document.getLineNumber(offset2);
            int sourceColumn = offset2 - document.getLineStartOffset(sourceLine);
            File file = new File(psiFile.getViewProvider().getVirtualFile().getPath());
            try {
                Supplier<Reader> contentSupplier = this.provideCurrentModuleContent ? () -> {
                    try {
                        return new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
                    }
                    catch (IOException e) {
                        return null;
                    }
                } : () -> null;
                this.mappingConsumer.addMapping(this.pathResolver.getPathRelativeToSourceRoots(file), null, contentSupplier, sourceLine, sourceColumn);
            }
            catch (IOException e) {
                throw new RuntimeException("IO error occurred generating source maps", e);
            }
        } else if (sourceInfo instanceof JsLocationWithSource) {
            JsLocationWithSource location2 = (JsLocationWithSource)sourceInfo;
            Supplier<Reader> contentSupplier = this.provideExternalModuleContent ? location2.getSourceProvider()::invoke : () -> null;
            this.mappingConsumer.addMapping(location2.getFile(), location2.getIdentityObject(), contentSupplier, location2.getStartLine(), location2.getStartChar());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "mappingConsumer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pathResolver";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/js/facade/SourceMapBuilderConsumer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

