/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.docprovider.formatters.formatters;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.ReplacingTextFormatter;
import sun.security.action.GetPropertyAction;

public class PlainTextFormatter
extends ReplacingTextFormatter {
    private static final String LINE_SEPARATOR = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private final Map<String, Integer> LongestKeys = new TreeMap<String, Integer>();
    private String currentSection = "none";
    public static final String SUFFIX = "txt";
    private final String pargraohIndentation;
    private final int maxLineLength;
    public static final String DEFAULT_INDENT = "    ";

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public PlainTextFormatter(String pargraohIndentation, int maxLineLength) {
        this.pargraohIndentation = pargraohIndentation;
        this.maxLineLength = maxLineLength;
    }

    public PlainTextFormatter(String pargraohIndentation) {
        this(pargraohIndentation, Integer.MAX_VALUE);
    }

    public PlainTextFormatter(int maxLineLength) {
        this(DEFAULT_INDENT, maxLineLength);
    }

    public PlainTextFormatter() {
        this.pargraohIndentation = DEFAULT_INDENT;
        this.maxLineLength = Integer.MAX_VALUE;
    }

    @Override
    public String getBoldOpening() {
        return "";
    }

    @Override
    public String getBoldClosing() {
        return "";
    }

    @Override
    public String getTitle(String s) {
        this.currentSection = s;
        return this.localizeTitle(s) + this.getNewLine();
    }

    @Override
    public String getNewLine() {
        return LINE_SEPARATOR;
    }

    @Override
    public String getHeaders(String id, String encoding) {
        return "  ***  icedtea-web " + this.getVersion() + "  ***  ";
    }

    @Override
    public String getTail() {
        return "";
    }

    @Override
    public String getSeeAlso(String s) {
        return "  * " + s + this.getNewLine();
    }

    @Override
    public String getFileSuffix() {
        return ".txt";
    }

    @Override
    public String wrapParagraph(String s) {
        return PlainTextFormatter.wrapParagraph(s, this.maxLineLength, this.pargraohIndentation);
    }

    static String wrapParagraph(String input, int maxWidth, String indent) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(input.split(PlainTextFormatter.getLineSeparator())));
        for (int i = 0; i < l.size(); ++i) {
            String s = indent + ((String)l.get(i)).trim();
            if (s.length() > maxWidth) {
                String split1 = s.substring(0, maxWidth);
                int split2 = split1.lastIndexOf(" ");
                int splitTest = split1.trim().lastIndexOf(" ");
                if (split2 < 1 || splitTest < 1) {
                    split2 = maxWidth;
                }
                l.set(i, s.substring(0, split2));
                l.add(i + 1, s.substring(split2));
                continue;
            }
            l.set(i, s);
        }
        return PlainTextFormatter.listToString(l);
    }

    static String listToString(List<String> l) {
        StringBuilder sb = new StringBuilder();
        for (String string : l) {
            sb.append(string).append(PlainTextFormatter.getLineSeparator());
        }
        return sb.toString();
    }

    @Override
    public String getBreakAndBold() {
        return this.getNewLine();
    }

    @Override
    public String getCloseBoldAndBreak() {
        return this.getNewLine();
    }

    @Override
    public String getBoldCloseNwlineBoldOpen() {
        return this.getNewLine();
    }

    @Override
    public String getOption(String key, String value) {
        Integer longestKey = this.LongestKeys.get(this.currentSection);
        if (longestKey == null) {
            longestKey = 0;
        }
        if (key.length() > longestKey) {
            longestKey = key.length();
            this.LongestKeys.put(this.currentSection, longestKey);
        }
        return key + this.getSpaces(longestKey + 3, key.length()) + this.process(value) + this.getNewLine();
    }

    private String getSpaces(int l, int k) {
        if (l - k <= 3) {
            return " - ";
        }
        String s = "";
        while (s.length() < l - k - 2) {
            s = s + " ";
        }
        return s + "- ";
    }
}

