/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.gui.EditAbbrevDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.StandardUtilities;

public class AbbrevsOptionPane
extends AbstractOptionPane {
    private JComboBox<String> setsComboBox;
    private JCheckBox expandOnInput;
    private JTable abbrevsTable;
    private AbbrevsModel globalAbbrevs;
    private Map<String, AbbrevsModel> modeAbbrevs;
    private JButton add;
    private JButton edit;
    private JButton remove;

    public AbbrevsOptionPane() {
        super("abbrevs");
    }

    @Override
    protected void _init() {
        Object object;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this.expandOnInput = new JCheckBox(jEdit.getProperty("options.abbrevs.expandOnInput"), Abbrevs.getExpandOnInput());
        jPanel.add((Component)this.expandOnInput, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add(Box.createGlue());
        JLabel jLabel = new JLabel(jEdit.getProperty("options.abbrevs.set"));
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        jPanel2.add(jLabel);
        Hashtable<String, Hashtable<String, String>> hashtable = Abbrevs.getModeAbbrevs();
        this.modeAbbrevs = new HashMap<String, AbbrevsModel>();
        Mode[] modeArray = jEdit.getModes();
        Arrays.sort(modeArray, new StandardUtilities.StringCompare(true));
        String[] stringArray = new String[modeArray.length + 1];
        stringArray[0] = "global";
        for (int i = 0; i < modeArray.length; ++i) {
            object = modeArray[i].getName();
            stringArray[i + 1] = object;
            this.modeAbbrevs.put((String)object, new AbbrevsModel((Map)hashtable.get(object)));
        }
        this.setsComboBox = new JComboBox<String>(stringArray);
        ActionHandler actionHandler = new ActionHandler();
        this.setsComboBox.addActionListener(actionHandler);
        jPanel2.add(this.setsComboBox);
        jPanel2.add(Box.createGlue());
        jPanel.add((Component)jPanel2, "South");
        this.add("North", jPanel);
        this.globalAbbrevs = new AbbrevsModel(Abbrevs.getGlobalAbbrevs());
        this.abbrevsTable = new JTable(this.globalAbbrevs);
        this.abbrevsTable.setRowHeight(GenericGUIUtilities.defaultRowHeight());
        this.abbrevsTable.getColumnModel().getColumn(1).setCellRenderer(new Renderer());
        this.abbrevsTable.setAutoResizeMode(4);
        this.abbrevsTable.getTableHeader().setReorderingAllowed(false);
        this.abbrevsTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.abbrevsTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.abbrevsTable.getSelectionModel().setSelectionMode(0);
        this.abbrevsTable.addMouseListener(new TableMouseHandler());
        object = this.abbrevsTable.getPreferredSize();
        ((Dimension)object).height = Math.min(((Dimension)object).height, 200);
        JScrollPane jScrollPane = new JScrollPane(this.abbrevsTable);
        jScrollPane.setPreferredSize((Dimension)object);
        this.add("Center", jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.abbrevs.add.icon")));
        this.add.setToolTipText(jEdit.getProperty("options.abbrevs.add"));
        this.add.addActionListener(actionHandler);
        jPanel3.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.abbrevs.remove.icon")));
        this.remove.setToolTipText(jEdit.getProperty("options.abbrevs.remove"));
        this.remove.addActionListener(actionHandler);
        jPanel3.add(this.remove);
        this.edit = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.abbrevs.edit.icon")));
        this.edit.setToolTipText(jEdit.getProperty("options.abbrevs.edit"));
        this.edit.addActionListener(actionHandler);
        jPanel3.add(this.edit);
        jPanel3.add(Box.createGlue());
        this.add("South", jPanel3);
        this.setsComboBox.setSelectedIndex(jEdit.getIntegerProperty("options.abbrevs.combobox.index", 0));
        this.updateEnabled();
    }

    @Override
    protected void _save() {
        if (this.abbrevsTable.getCellEditor() != null) {
            this.abbrevsTable.getCellEditor().stopCellEditing();
        }
        Abbrevs.setExpandOnInput(this.expandOnInput.isSelected());
        Abbrevs.setGlobalAbbrevs(this.globalAbbrevs.toHashtable());
        Hashtable<String, Hashtable<String, String>> hashtable = new Hashtable<String, Hashtable<String, String>>();
        Set<Map.Entry<String, AbbrevsModel>> set = this.modeAbbrevs.entrySet();
        for (Map.Entry<String, AbbrevsModel> entry : set) {
            hashtable.put(entry.getKey(), entry.getValue().toHashtable());
        }
        Abbrevs.setModeAbbrevs(hashtable);
    }

    private void updateEnabled() {
        int n = this.abbrevsTable.getSelectedRow();
        this.edit.setEnabled(n != -1);
        this.remove.setEnabled(n != -1);
    }

    private void edit() {
        AbbrevsModel abbrevsModel = (AbbrevsModel)this.abbrevsTable.getModel();
        int n = this.abbrevsTable.getSelectedRow();
        String string = (String)abbrevsModel.getValueAt(n, 0);
        String string2 = (String)abbrevsModel.getValueAt(n, 1);
        String string3 = string;
        EditAbbrevDialog editAbbrevDialog = new EditAbbrevDialog((Dialog)GenericGUIUtilities.getParentDialog(this), string, string2, abbrevsModel.toHashtable());
        string = editAbbrevDialog.getAbbrev();
        string2 = editAbbrevDialog.getExpansion();
        if (string != null && string2 != null) {
            for (int i = 0; i < abbrevsModel.getRowCount(); ++i) {
                if (!abbrevsModel.getValueAt(i, 0).equals(string3)) continue;
                abbrevsModel.remove(i);
                break;
            }
            this.add(abbrevsModel, string, string2);
        }
    }

    private void add(AbbrevsModel abbrevsModel, String string, String string2) {
        for (int i = 0; i < abbrevsModel.getRowCount(); ++i) {
            if (!abbrevsModel.getValueAt(i, 0).equals(string)) continue;
            abbrevsModel.remove(i);
            break;
        }
        abbrevsModel.add(string, string2);
        this.updateEnabled();
    }

    private static class AbbrevsModel
    extends AbstractTableModel {
        List<Abbrev> abbrevs = new Vector<Abbrev>();
        int lastSort;

        AbbrevsModel(Map<String, String> map) {
            if (map != null) {
                Set<Map.Entry<String, String>> set = map.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    this.abbrevs.add(new Abbrev(entry.getKey(), entry.getValue()));
                }
                this.sort(0);
            }
        }

        void sort(int n) {
            this.lastSort = n;
            Collections.sort(this.abbrevs, new AbbrevCompare(n));
            this.fireTableDataChanged();
        }

        void add(String string, String string2) {
            this.abbrevs.add(new Abbrev(string, string2));
            this.sort(this.lastSort);
        }

        void remove(int n) {
            this.abbrevs.remove(n);
            this.fireTableStructureChanged();
        }

        public Hashtable<String, String> toHashtable() {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (Abbrev abbrev : this.abbrevs) {
                if (abbrev.abbrev.length() <= 0 || abbrev.expand.length() <= 0) continue;
                hashtable.put(abbrev.abbrev, abbrev.expand);
            }
            return hashtable;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.abbrevs.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Abbrev abbrev = this.abbrevs.get(n);
            switch (n2) {
                case 0: {
                    return abbrev.abbrev;
                }
                case 1: {
                    return abbrev.expand;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null) {
                object = "";
            }
            Abbrev abbrev = this.abbrevs.get(n);
            if (n2 == 0) {
                abbrev.abbrev = (String)object;
            } else {
                abbrev.expand = (String)object;
            }
            this.fireTableRowsUpdated(n, n);
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return jEdit.getProperty("options.abbrevs.abbrev");
                }
                case 1: {
                    return jEdit.getProperty("options.abbrevs.expand");
                }
            }
            return null;
        }

        private static class Abbrev {
            String abbrev;
            String expand;

            Abbrev() {
            }

            Abbrev(String string, String string2) {
                this.abbrev = string;
                this.expand = string2;
            }
        }

        private static class AbbrevCompare
        implements Comparator<Abbrev> {
            private int col;

            AbbrevCompare(int n) {
                this.col = n;
            }

            @Override
            public int compare(Abbrev abbrev, Abbrev abbrev2) {
                if (this.col == 0) {
                    String string = abbrev.abbrev.toLowerCase();
                    String string2 = abbrev2.abbrev.toLowerCase();
                    return StandardUtilities.compareStrings(string, string2, true);
                }
                String string = abbrev.expand.toLowerCase();
                String string3 = abbrev2.expand.toLowerCase();
                return StandardUtilities.compareStrings(string, string3, true);
            }
        }
    }

    private static class Renderer
    extends DefaultTableCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder(object.toString());
            if (stringBuilder.toString().toLowerCase().startsWith("<html>")) {
                stringBuilder.insert(32, 0);
            }
            return super.getTableCellRendererComponent(jTable, stringBuilder.toString(), bl, bl2, n, n2);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbbrevsModel abbrevsModel = (AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel();
            Object object = actionEvent.getSource();
            if (object == AbbrevsOptionPane.this.setsComboBox) {
                jEdit.setIntegerProperty("options.abbrevs.combobox.index", AbbrevsOptionPane.this.setsComboBox.getSelectedIndex());
                String string = (String)AbbrevsOptionPane.this.setsComboBox.getSelectedItem();
                if (string.equals("global")) {
                    AbbrevsOptionPane.this.abbrevsTable.setModel(AbbrevsOptionPane.this.globalAbbrevs);
                } else {
                    AbbrevsOptionPane.this.abbrevsTable.setModel((TableModel)AbbrevsOptionPane.this.modeAbbrevs.get(string));
                }
                AbbrevsOptionPane.this.updateEnabled();
            } else if (object == AbbrevsOptionPane.this.add) {
                EditAbbrevDialog editAbbrevDialog = new EditAbbrevDialog((Dialog)GenericGUIUtilities.getParentDialog(AbbrevsOptionPane.this), null, null, abbrevsModel.toHashtable());
                String string = editAbbrevDialog.getAbbrev();
                String string2 = editAbbrevDialog.getExpansion();
                if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                    AbbrevsOptionPane.this.add(abbrevsModel, string, string2);
                }
            } else if (object == AbbrevsOptionPane.this.edit) {
                AbbrevsOptionPane.this.edit();
            } else if (object == AbbrevsOptionPane.this.remove) {
                int n = AbbrevsOptionPane.this.abbrevsTable.getSelectedRow();
                abbrevsModel.remove(n);
                AbbrevsOptionPane.this.updateEnabled();
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AbbrevsOptionPane.this.updateEnabled();
        }
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                AbbrevsOptionPane.this.edit();
            }
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            switch (AbbrevsOptionPane.this.abbrevsTable.getTableHeader().columnAtPoint(mouseEvent.getPoint())) {
                case 0: {
                    ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(0);
                    break;
                }
                case 1: {
                    ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(1);
                }
            }
        }
    }
}

