/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ant;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u00103\u001a\u00020\u0005J\u0006\u00104\u001a\u00020+J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000206J\b\u00108\u001a\u000206H&J\u000e\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020;R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0012\u0010\u000b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0018\"\u0004\b2\u0010\u001a\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ant/KotlinCompilerBaseTask;", "Lorg/apache/tools/ant/Task;", "()V", "additionalArguments", "", "Lorg/apache/tools/ant/types/Commandline$Argument;", "getAdditionalArguments", "()Ljava/util/List;", "args", "", "getArgs", "compilerFqName", "getCompilerFqName", "()Ljava/lang/String;", "exitCode", "", "getExitCode", "()Ljava/lang/Integer;", "setExitCode", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "failOnError", "", "getFailOnError", "()Z", "setFailOnError", "(Z)V", "noStdlib", "getNoStdlib", "setNoStdlib", "nowarn", "getNowarn", "setNowarn", "output", "Ljava/io/File;", "getOutput", "()Ljava/io/File;", "setOutput", "(Ljava/io/File;)V", "printVersion", "getPrintVersion", "setPrintVersion", "src", "Lorg/apache/tools/ant/types/Path;", "getSrc", "()Lorg/apache/tools/ant/types/Path;", "setSrc", "(Lorg/apache/tools/ant/types/Path;)V", "verbose", "getVerbose", "setVerbose", "createCompilerArg", "createSrc", "execute", "", "fillArguments", "fillSpecificArguments", "setSrcRef", "ref", "Lorg/apache/tools/ant/types/Reference;", "kotlin-ant-tools"})
public abstract class KotlinCompilerBaseTask
extends Task {
    @NotNull
    private final List<String> args;
    @Nullable
    private Path src;
    @Nullable
    private File output;
    private boolean nowarn;
    private boolean verbose;
    private boolean printVersion;
    private boolean failOnError;
    private boolean noStdlib;
    @NotNull
    private final List<Commandline.Argument> additionalArguments;
    @Nullable
    private Integer exitCode;

    @NotNull
    protected abstract String getCompilerFqName();

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @Nullable
    public final Path getSrc() {
        return this.src;
    }

    public final void setSrc(@Nullable Path path) {
        this.src = path;
    }

    @Nullable
    public final File getOutput() {
        return this.output;
    }

    public final void setOutput(@Nullable File file) {
        this.output = file;
    }

    public final boolean getNowarn() {
        return this.nowarn;
    }

    public final void setNowarn(boolean bl) {
        this.nowarn = bl;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final boolean getPrintVersion() {
        return this.printVersion;
    }

    public final void setPrintVersion(boolean bl) {
        this.printVersion = bl;
    }

    public final boolean getFailOnError() {
        return this.failOnError;
    }

    public final void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public final boolean getNoStdlib() {
        return this.noStdlib;
    }

    public final void setNoStdlib(boolean bl) {
        this.noStdlib = bl;
    }

    @NotNull
    public final List<Commandline.Argument> getAdditionalArguments() {
        return this.additionalArguments;
    }

    @Nullable
    public final Integer getExitCode() {
        return this.exitCode;
    }

    public final void setExitCode(@Nullable Integer n) {
        this.exitCode = n;
    }

    @NotNull
    public final Path createSrc() {
        Path srcPath = this.src;
        if (srcPath == null) {
            Path t;
            this.src = t = new Path(this.getProject());
            return t;
        }
        Path path = srcPath.createPath();
        Intrinsics.checkExpressionValueIsNotNull(path, "srcPath.createPath()");
        return path;
    }

    public final void setSrcRef(@NotNull Reference ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        this.createSrc().setRefid(ref);
    }

    @NotNull
    public final Commandline.Argument createCompilerArg() {
        Commandline.Argument argument = new Commandline.Argument();
        this.additionalArguments.add(argument);
        return argument;
    }

    public abstract void fillSpecificArguments();

    public final void fillArguments() {
        Commandline.Argument it;
        Collection<String> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Path path = this.src;
        if (path == null) {
            throw (Throwable)new BuildException("\"src\" should be specified");
        }
        Path sourcePaths = path;
        Object[] objectArray = sourcePaths.list();
        List<String> list = this.args;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void item$iv$iv = $receiver$iv$iv[i];
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = new File((String)it).getCanonicalPath();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        list.addAll(collection);
        if (this.output == null) {
            throw (Throwable)new BuildException("\"output\" should be specified");
        }
        if (this.nowarn) {
            this.args.add("-nowarn");
        }
        if (this.verbose) {
            this.args.add("-verbose");
        }
        if (this.printVersion) {
            this.args.add("-version");
        }
        $receiver$iv = this.additionalArguments;
        list = this.args;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Commandline.Argument)element$iv$iv;
            Iterable list$iv$iv = ArraysKt.toList((Object[])it.getParts());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        list.addAll(collection);
        this.fillSpecificArguments();
    }

    /*
     * WARNING - void declaration
     */
    public final void execute() {
        Object result;
        String[] stringArray;
        void $receiver$iv;
        this.fillArguments();
        Class<?> compilerClass = KotlinAntTaskUtil.INSTANCE.getOrCreateClassLoader().loadClass(this.getCompilerFqName());
        Object compiler = compilerClass.newInstance();
        Method exec = compilerClass.getMethod("execFullPathsInMessages", PrintStream.class, String[].class);
        StringBuilder stringBuilder = new StringBuilder().append("Compiling ");
        Path path = this.src;
        if (path == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder stringBuilder2 = stringBuilder.append(ArraysKt.toList((Object[])path.list())).append(" => [");
        File file = this.output;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        this.log(stringBuilder2.append(file.getCanonicalPath()).append(']').toString());
        Object[] objectArray = new Object[2];
        objectArray[0] = System.err;
        Collection collection = this.args;
        int n = 1;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        Object obj = compiler;
        Method method = exec;
        void v5 = $receiver$iv;
        if (v5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v5;
        String[] stringArray2 = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray2[n] = stringArray = stringArray2;
        Object object = result = method.invoke(obj, objectArray3);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
        }
        this.exitCode = ((Enum)object).ordinal();
        if (this.failOnError && Intrinsics.areEqual(this.exitCode, (Object)0) ^ true) {
            throw (Throwable)new BuildException("Compile failed; see the compiler error output for details.");
        }
    }

    public KotlinCompilerBaseTask() {
        KotlinCompilerBaseTask kotlinCompilerBaseTask = this;
        ArrayList arrayList = new ArrayList();
        kotlinCompilerBaseTask.args = arrayList;
        this.failOnError = true;
        kotlinCompilerBaseTask = this;
        arrayList = new ArrayList();
        kotlinCompilerBaseTask.additionalArguments = arrayList;
    }
}

