/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.java.lexer.JavaDocLexer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class RecordUtil {
    private RecordUtil() {
    }

    public static boolean isDeprecatedByAnnotation(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByAnnotation"));
        }
        if (modList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modList", "com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByAnnotation"));
        }
        for (LighterASTNode child : tree.getChildren(modList)) {
            String name;
            LighterASTNode id;
            LighterASTNode ref;
            if (child.getTokenType() != JavaElementType.ANNOTATION || (ref = LightTreeUtil.firstChildOfType(tree, child, JavaElementType.JAVA_CODE_REFERENCE)) == null || (id = LightTreeUtil.firstChildOfType(tree, ref, JavaTokenType.IDENTIFIER)) == null || !"Deprecated".equals(name = RecordUtil.intern(tree.getCharTable(), id))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeprecatedByDocComment(@NotNull LighterAST tree, @NotNull LighterASTNode comment) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByDocComment"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByDocComment"));
        }
        String text2 = LightTreeUtil.toFilteredString(tree, comment, null);
        if (text2.contains("@deprecated")) {
            IElementType token;
            JavaDocLexer lexer = new JavaDocLexer(LanguageLevel.HIGHEST);
            lexer.start(text2);
            while ((token = lexer.getTokenType()) != null) {
                if (token == JavaDocTokenType.DOC_TAG_NAME && "@deprecated".equals(lexer.getTokenText())) {
                    return true;
                }
                lexer.advance();
            }
        }
        return false;
    }

    public static int packModifierList(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/cache/RecordUtil", "packModifierList"));
        }
        if (modList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modList", "com/intellij/psi/impl/cache/RecordUtil", "packModifierList"));
        }
        int packed = 0;
        for (LighterASTNode child : tree.getChildren(modList)) {
            packed |= ModifierFlags.KEYWORD_TO_MODIFIER_FLAG_MAP.get(child.getTokenType());
        }
        return packed;
    }

    @NotNull
    public static String intern(@NotNull CharTable table, @NotNull LighterASTNode node) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        assert (node instanceof LighterASTTokenNode) : node;
        String string = table.intern(((LighterASTTokenNode)node).getText()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        return string;
    }

    public static boolean isStaticNonPrivateMember(@NotNull StubElement<?> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/cache/RecordUtil", "isStaticNonPrivateMember"));
        }
        StubElement<PsiModifierList> type2 = stub.findChildStubByType(JavaStubElementTypes.MODIFIER_LIST);
        if (!(type2 instanceof PsiModifierListStub)) {
            return false;
        }
        int mask = ((PsiModifierListStub)type2).getModifiersMask();
        if (ModifierFlags.hasModifierProperty("private", mask)) {
            return false;
        }
        if (ModifierFlags.hasModifierProperty("static", mask)) {
            return true;
        }
        return stub instanceof PsiFieldStub && stub.getStubType() == JavaElementType.ENUM_CONSTANT || stub.getParentStub() instanceof PsiClassStub && ((PsiClassStub)stub.getParentStub()).isInterface();
    }
}

