/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import org.gephi.appearance.AppearanceModelImpl;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.openide.util.Lookup;

public class AppearanceControllerImpl
implements AppearanceController {
    private AppearanceModelImpl model;

    public AppearanceControllerImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                AppearanceControllerImpl.this.model = (AppearanceModelImpl)workspace.getLookup().lookup(AppearanceModelImpl.class);
                if (AppearanceControllerImpl.this.model == null) {
                    AppearanceControllerImpl.this.model = new AppearanceModelImpl(workspace);
                    workspace.add((Object)AppearanceControllerImpl.this.model);
                }
            }

            public void unselect(Workspace workspace) {
                AppearanceControllerImpl.this.model = null;
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                AppearanceControllerImpl.this.model = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.model = (AppearanceModelImpl)pc.getCurrentWorkspace().getLookup().lookup(AppearanceModelImpl.class);
            if (this.model == null) {
                this.model = new AppearanceModelImpl(pc.getCurrentWorkspace());
                pc.getCurrentWorkspace().add((Object)this.model);
            }
        }
    }

    @Override
    public void transform(Function function) {
        if (this.model != null) {
            GraphModel graphModel = this.model.getGraphModel();
            Graph graph = graphModel.getGraphVisible();
            Object iterable = function.getElementClass().equals(Node.class) ? graph.getNodes() : graph.getEdges();
            try {
                for (Element element : iterable) {
                    function.transform(element, graph);
                }
            }
            catch (Exception e) {
                iterable.doBreak();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public AppearanceModelImpl getModel() {
        return this.model;
    }

    @Override
    public AppearanceModelImpl getModel(Workspace workspace) {
        AppearanceModelImpl m = (AppearanceModelImpl)workspace.getLookup().lookup(AppearanceModelImpl.class);
        if (m == null) {
            m = new AppearanceModelImpl(workspace);
            workspace.add((Object)m);
        }
        return m;
    }

    @Override
    public Transformer getTransformer(TransformerUI ui) {
        Class transformerClass = ui.getTransformerClass();
        Transformer transformer = (Transformer)Lookup.getDefault().lookup(transformerClass);
        if (transformer != null) {
            return transformer;
        }
        return null;
    }

    @Override
    public void setUseLocalScale(boolean useLocalScale) {
        if (this.model != null) {
            this.model.setLocalScale(useLocalScale);
        }
    }

    @Override
    public void forcePartitionFunction(Function function) {
        if (this.model != null) {
            this.model.forcePartition(function);
        }
    }

    @Override
    public void forceRankingFunction(Function function) {
        if (this.model != null) {
            this.model.forceRanking(function);
        }
    }
}

