/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import org.gephi.appearance.RankingImpl;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.types.TimeMap;

public class EdgeWeightRankingImpl
extends RankingImpl {
    private final Graph graph;

    public EdgeWeightRankingImpl(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Number getValue(Element element, Graph gr) {
        return ((Edge)element).getWeight(gr.getView());
    }

    @Override
    protected void refresh() {
        if (this.graph.getEdgeCount() > 0) {
            double minV = Double.MAX_VALUE;
            double maxV = Double.MIN_VALUE;
            for (Edge e : this.graph.getEdges()) {
                if (e.hasDynamicWeight()) {
                    TimeMap timeMap = (TimeMap)e.getAttribute("weight");
                    if (timeMap == null) continue;
                    Double numMin = (Double)timeMap.get(this.graph.getView().getTimeInterval(), Estimator.MIN);
                    Double numMax = (Double)timeMap.get(this.graph.getView().getTimeInterval(), Estimator.MAX);
                    minV = Math.min(numMin, minV);
                    maxV = Math.max(numMax, maxV);
                    continue;
                }
                minV = e.getWeight();
                maxV = e.getWeight();
            }
            this.min = minV;
            this.max = maxV;
        }
    }
}

