/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import org.gephi.appearance.PartitionImpl;
import org.gephi.appearance.RankingImpl;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.api.Interpolator;
import org.gephi.appearance.spi.PartitionTransformer;
import org.gephi.appearance.spi.RankingTransformer;
import org.gephi.appearance.spi.SimpleTransformer;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;

public abstract class FunctionImpl
implements Function {
    protected final String id;
    protected final Class<? extends Element> elementClass;
    protected final String name;
    protected final Graph graph;
    protected final Column column;
    protected final Transformer transformer;
    protected final TransformerUI transformerUI;
    protected final PartitionImpl partition;
    protected final RankingImpl ranking;
    protected Interpolator interpolator;

    protected FunctionImpl(String id, String name, Class<? extends Element> elementClass, Graph graph, Column column, Transformer transformer, TransformerUI transformerUI, PartitionImpl partition, RankingImpl ranking, Interpolator interpolator) {
        if (id == null) {
            throw new NullPointerException("The id can't be null");
        }
        this.id = id;
        this.name = name;
        this.elementClass = elementClass;
        this.column = column;
        this.graph = graph;
        this.interpolator = interpolator;
        try {
            this.transformer = (Transformer)transformer.getClass().newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.transformerUI = transformerUI;
        this.partition = partition;
        this.ranking = ranking;
    }

    @Override
    public void transform(Element element, Graph graph) {
        if (this.isSimple()) {
            ((SimpleTransformer)this.transformer).transform(element);
        } else if (this.isRanking()) {
            Number val = this.ranking.getValue(element, graph);
            if (val == null) {
                throw new NullPointerException("The element with id '" + element.getId() + "' has a null value for ranking");
            }
            ((RankingTransformer)this.transformer).transform(element, this.ranking, this.interpolator, val);
        } else if (this.isPartition()) {
            Object val = this.partition.getValue(element, graph);
            ((PartitionTransformer)this.transformer).transform(element, this.partition, val);
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public TransformerUI getUI() {
        return this.transformerUI;
    }

    @Override
    public boolean isSimple() {
        return this.ranking == null && this.partition == null;
    }

    @Override
    public boolean isAttribute() {
        return this.column != null;
    }

    @Override
    public boolean isPartition() {
        return this.partition != null;
    }

    @Override
    public boolean isRanking() {
        return this.ranking != null;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Class<? extends Element> getElementClass() {
        return this.elementClass;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionImpl other = (FunctionImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

