/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.context;

import java.util.Timer;
import java.util.TimerTask;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphObserver;

public class ContextRefreshThread
extends TimerTask {
    private static final long PERIOD = 500L;
    private final Timer timer = new Timer("Context Refresh Thread", true);
    private final GraphModel graphModel;
    private final Runnable listener;
    private GraphObserver observer;

    public ContextRefreshThread(GraphModel graphModel, Runnable listener) {
        this.graphModel = graphModel;
        this.listener = listener;
        this.timer.schedule((TimerTask)this, 500L, 500L);
    }

    private void initObserver() {
        if (this.observer == null || this.observer.isDestroyed() || this.observer.getGraph().getView() != this.graphModel.getVisibleView()) {
            if (this.observer != null && !this.observer.isDestroyed()) {
                this.observer.destroy();
            }
            this.observer = this.graphModel.createGraphObserver(this.graphModel.getGraphVisible(), false);
            this.listener.run();
        }
    }

    @Override
    public void run() {
        this.initObserver();
        if (this.observer.hasGraphChanged()) {
            this.listener.run();
        }
    }

    public void shutdown() {
        this.timer.cancel();
        if (this.observer != null && !this.observer.isDestroyed()) {
            this.observer.destroy();
        }
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }
}

