/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.api;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.gephi.io.importer.api.PropertyAssociation;

public final class PropertiesAssociations
implements Serializable {
    private final List<PropertyAssociation<NodeProperties>> nodePropertyAssociations = new LinkedList<PropertyAssociation<NodeProperties>>();
    private final List<PropertyAssociation<EdgeProperties>> edgePropertyAssociations = new LinkedList<PropertyAssociation<EdgeProperties>>();

    public void addEdgePropertyAssociation(EdgeProperties property, String title) {
        PropertyAssociation<EdgeProperties> association = new PropertyAssociation<EdgeProperties>(property, title);
        this.edgePropertyAssociations.add(association);
    }

    public void addNodePropertyAssociation(NodeProperties property, String title) {
        PropertyAssociation<NodeProperties> association = new PropertyAssociation<NodeProperties>(property, title);
        this.nodePropertyAssociations.add(association);
    }

    PropertyAssociation<EdgeProperties>[] getEdgePropertiesAssociation() {
        return this.edgePropertyAssociations.toArray(new PropertyAssociation[0]);
    }

    PropertyAssociation<NodeProperties>[] getNodePropertiesAssociation() {
        return this.nodePropertyAssociations.toArray(new PropertyAssociation[0]);
    }

    public NodeProperties getNodeProperty(String title) {
        for (PropertyAssociation<NodeProperties> p : this.nodePropertyAssociations) {
            if (!p.getTitle().equalsIgnoreCase(title)) continue;
            return p.getProperty();
        }
        return null;
    }

    public EdgeProperties getEdgeProperty(String title) {
        for (PropertyAssociation<EdgeProperties> p : this.edgePropertyAssociations) {
            if (!p.getTitle().equalsIgnoreCase(title)) continue;
            return p.getProperty();
        }
        return null;
    }

    public String getNodePropertyTitle(NodeProperties property) {
        for (PropertyAssociation<NodeProperties> p : this.nodePropertyAssociations) {
            if (!p.getProperty().equals((Object)property)) continue;
            return p.getTitle();
        }
        return null;
    }

    public String getEdgePropertyTitle(EdgeProperties property) {
        for (PropertyAssociation<EdgeProperties> p : this.edgePropertyAssociations) {
            if (!p.getProperty().equals((Object)property)) continue;
            return p.getTitle();
        }
        return null;
    }

    public String getInfos() {
        String res = "***Node Properties Associations***\n";
        for (PropertyAssociation<NodeProperties> propertyAssociation : this.nodePropertyAssociations) {
            res = res + "Property " + propertyAssociation.getProperty().toString() + " = " + propertyAssociation.getTitle() + " Column\n";
        }
        res = res + "*********************************\n";
        res = "***Edge Properties Associations***\n";
        for (PropertyAssociation<Enum> propertyAssociation : this.edgePropertyAssociations) {
            res = res + "Property " + ((EdgeProperties)propertyAssociation.getProperty()).toString() + " = " + propertyAssociation.getTitle() + " Column\n";
        }
        res = res + "*********************************\n";
        return res;
    }

    public static enum EdgeProperties {
        R,
        G,
        B,
        COLOR,
        WEIGHT,
        ID,
        LABEL,
        ALPHA,
        SOURCE,
        TARGET,
        START,
        END,
        START_OPEN,
        END_OPEN;

    }

    public static enum NodeProperties {
        X,
        Y,
        Z,
        R,
        G,
        B,
        COLOR,
        SIZE,
        ID,
        LABEL,
        FIXED,
        START,
        END,
        START_OPEN,
        END_OPEN;

    }
}

