/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.impl;

import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.impl.ColumnDraftImpl;
import org.gephi.io.importer.impl.ElementDraftImpl;
import org.gephi.io.importer.impl.ImportContainerImpl;
import org.gephi.io.importer.impl.NodeDraftImpl;

public class EdgeDraftImpl
extends ElementDraftImpl
implements EdgeDraft {
    private NodeDraftImpl source;
    private NodeDraftImpl target;
    private double weight = 1.0;
    private Object type;
    private EdgeDirection direction;

    public EdgeDraftImpl(ImportContainerImpl container, String id) {
        super(container, id);
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public void setType(Object type) {
        this.type = type;
    }

    @Override
    public void setDirection(EdgeDirection direction) {
        this.direction = direction;
    }

    @Override
    public void setSource(NodeDraft nodeSource) {
        this.source = (NodeDraftImpl)nodeSource;
    }

    @Override
    public void setTarget(NodeDraft nodeTarget) {
        this.target = (NodeDraftImpl)nodeTarget;
    }

    @Override
    public NodeDraftImpl getSource() {
        return this.source;
    }

    @Override
    public NodeDraftImpl getTarget() {
        return this.target;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public EdgeDirection getDirection() {
        return this.direction;
    }

    @Override
    public Object getType() {
        return this.type;
    }

    @Override
    public boolean isSelfLoop() {
        return this.source != null && this.source == this.target;
    }

    @Override
    public Object getValue(String key) {
        ColumnDraft column = this.container.getEdgeColumn(key);
        if (column != null) {
            return this.getAttributeValue(((ColumnDraftImpl)column).getIndex());
        }
        return null;
    }

    @Override
    ColumnDraft getColumn(String key, Class type) {
        return this.container.addEdgeColumn(key, type);
    }

    @Override
    ColumnDraft getColumn(String key) {
        return this.container.getEdgeColumn(key);
    }

    @Override
    public Iterable<ColumnDraft> getColumns() {
        return this.container.getEdgeColumns();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.source.getId());
        sb.append(" -> ");
        sb.append(this.target.getId());
        sb.append(" (id = ");
        sb.append(this.id);
        if (this.type != null && !this.type.toString().isEmpty()) {
            sb.append("; type = ");
            sb.append(this.type);
        }
        sb.append(")");
        return sb.toString();
    }
}

