/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.appearance.plugin;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.gephi.appearance.plugin.RankingElementColorTransformer;
import org.openide.util.NbPreferences;

public class RecentPalettes {
    protected static String DEFAULT_NODE_NAME = "prefs";
    public static final String COLORS = "PaletteColors";
    public static final String POSITIONS = "PalettePositions";
    private final LinkedList<RankingElementColorTransformer.LinearGradient> gradients = new LinkedList();
    private final int maxSize;
    protected String nodeName = "recentrankingpalettes";

    public RecentPalettes() {
        this.maxSize = 14;
        this.retrieve();
    }

    public void add(RankingElementColorTransformer.LinearGradient gradient) {
        this.gradients.remove(gradient);
        this.gradients.push(new RankingElementColorTransformer.LinearGradient(gradient.getColors(), gradient.getPositions()));
        while (this.gradients.size() > this.maxSize) {
            this.gradients.removeLast();
        }
        this.store();
    }

    public RankingElementColorTransformer.LinearGradient[] getPalettes() {
        return this.gradients.toArray(new RankingElementColorTransformer.LinearGradient[0]);
    }

    private void store() {
        Preferences prefs = this.getPreferences();
        try {
            prefs.clear();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        int i = 0;
        for (RankingElementColorTransformer.LinearGradient gradient : this.gradients) {
            try {
                prefs.putByteArray(COLORS + i, this.serializeColors(gradient.getColors()));
                prefs.putByteArray(POSITIONS + i, this.serializePositions(gradient.getPositions()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void retrieve() {
        this.gradients.clear();
        Preferences prefs = this.getPreferences();
        for (int i = 0; i < this.maxSize; ++i) {
            byte[] cols = prefs.getByteArray(COLORS + i, null);
            byte[] poss = prefs.getByteArray(POSITIONS + i, null);
            if (cols == null || poss == null) break;
            try {
                Color[] colors = this.deserializeColors(cols);
                float[] posisitons = this.deserializePositions(poss);
                RankingElementColorTransformer.LinearGradient linearGradient = new RankingElementColorTransformer.LinearGradient(colors, posisitons);
                this.gradients.addLast(linearGradient);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected final Preferences getPreferences() {
        String name = DEFAULT_NODE_NAME;
        if (this.nodeName != null) {
            name = this.nodeName;
        }
        Preferences prefs = NbPreferences.forModule(this.getClass()).node("options").node(name);
        return prefs;
    }

    private byte[] serializePositions(float[] positions) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(positions);
        out.close();
        return bos.toByteArray();
    }

    private float[] deserializePositions(byte[] positions) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(positions);
        ObjectInputStream in = new ObjectInputStream(bis);
        float[] array = (float[])in.readObject();
        in.close();
        return array;
    }

    private byte[] serializeColors(Color[] colors) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(colors);
        out.close();
        return bos.toByteArray();
    }

    private Color[] deserializeColors(byte[] colors) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(colors);
        ObjectInputStream in = new ObjectInputStream(bis);
        Color[] array = (Color[])in.readObject();
        in.close();
        return array;
    }
}

