/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import java.awt.Color;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.project.api.Workspace;
import org.gephi.utils.progress.ProgressTicket;

public abstract class AbstractProcessor {
    protected ProgressTicket progressTicket;
    protected Workspace workspace;
    protected ContainerUnloader[] containers;
    protected GraphModel graphModel;

    protected void flushColumns(ContainerUnloader container) {
        TimeRepresentation timeRepresentation = container.getTimeRepresentation();
        Table nodeTable = this.graphModel.getNodeTable();
        for (ColumnDraft col : container.getNodeColumns()) {
            if (nodeTable.hasColumn(col.getId())) continue;
            Class typeClass = col.getTypeClass();
            if (col.isDynamic()) {
                typeClass = timeRepresentation.equals((Object)TimeRepresentation.TIMESTAMP) ? AttributeUtils.getTimestampMapType((Class)typeClass) : AttributeUtils.getIntervalMapType((Class)typeClass);
            }
            nodeTable.addColumn(col.getId(), col.getTitle(), typeClass, Origin.DATA, col.getDefaultValue(), !col.isDynamic());
        }
        Table edgeTable = this.graphModel.getEdgeTable();
        for (ColumnDraft col : container.getEdgeColumns()) {
            if (edgeTable.hasColumn(col.getId())) continue;
            Class typeClass = col.getTypeClass();
            if (col.isDynamic()) {
                typeClass = timeRepresentation.equals((Object)TimeRepresentation.TIMESTAMP) ? AttributeUtils.getTimestampMapType((Class)typeClass) : AttributeUtils.getIntervalMapType((Class)typeClass);
            }
            edgeTable.addColumn(col.getId(), col.getTitle(), typeClass, Origin.DATA, col.getDefaultValue(), !col.isDynamic());
        }
    }

    protected void flushToNode(NodeDraft nodeDraft, Node node) {
        if (nodeDraft.getColor() != null) {
            node.setColor(nodeDraft.getColor());
        }
        if (!(nodeDraft.getLabel() == null || node.getLabel() != null && nodeDraft.isCreatedAuto())) {
            node.setLabel(nodeDraft.getLabel());
        }
        if (node.getTextProperties() != null) {
            node.getTextProperties().setVisible(nodeDraft.isLabelVisible());
        }
        if (nodeDraft.getLabelColor() != null && node.getTextProperties() != null) {
            Color labelColor = nodeDraft.getLabelColor();
            node.getTextProperties().setColor(labelColor);
        } else {
            node.getTextProperties().setColor(new Color(0, 0, 0, 0));
        }
        if (nodeDraft.getLabelSize() != -1.0f && node.getTextProperties() != null) {
            node.getTextProperties().setSize(nodeDraft.getLabelSize());
        }
        if ((nodeDraft.getX() != 0.0f || nodeDraft.getY() != 0.0f || nodeDraft.getZ() != 0.0f) && node.x() == 0.0f && node.y() == 0.0f && node.z() == 0.0f) {
            node.setX(nodeDraft.getX());
            node.setY(nodeDraft.getY());
            node.setZ(nodeDraft.getZ());
        }
        if (nodeDraft.getSize() != 0.0f && !Float.isNaN(nodeDraft.getSize())) {
            node.setSize(nodeDraft.getSize());
        } else if (node.size() == 0.0f) {
            node.setSize(10.0f);
        }
        if (nodeDraft.getTimeSet() != null) {
            this.flushTimeSet(nodeDraft.getTimeSet(), (Element)node);
        }
        if (nodeDraft.getGraphTimestamp() != null) {
            node.addTimestamp(nodeDraft.getGraphTimestamp().doubleValue());
        } else if (nodeDraft.getGraphInterval() != null) {
            node.addInterval(nodeDraft.getGraphInterval());
        }
        this.flushToElementAttributes((ElementDraft)nodeDraft, (Element)node);
    }

    protected void flushEdgeWeight(EdgeDraft edgeDraft, Edge edge) {
        Object val = edgeDraft.getValue("weight");
        if (val != null && val instanceof TimeMap) {
            TimeMap valMap = (TimeMap)val;
            TimeMap existingMap = (TimeMap)edge.getAttribute("weight");
            if (existingMap != null) {
                Object[] keys = ((TimeMap)val).toKeysArray();
                Object[] vals = ((TimeMap)val).toValuesArray();
                for (int i = 0; i < keys.length; ++i) {
                    valMap.put(keys[i], (Object)((Number)vals[i]).doubleValue());
                }
            }
            edge.setAttribute("weight", val);
        }
    }

    protected void flushToElementAttributes(ElementDraft elementDraft, Element element) {
        for (ColumnDraft col : elementDraft.getColumns()) {
            TimeMap existingMap;
            Object val;
            if (elementDraft instanceof EdgeDraft && col.getId().equals("weight") || (val = elementDraft.getValue(col.getId())) == null) continue;
            if (col.isDynamic() && (existingMap = (TimeMap)element.getAttribute(col.getId())) != null && !existingMap.isEmpty()) {
                TimeMap valMap = (TimeMap)val;
                Object[] keys = existingMap.toKeysArray();
                Object[] vals = existingMap.toValuesArray();
                for (int i = 0; i < keys.length; ++i) {
                    valMap.put(keys[i], vals[i]);
                }
                element.setAttribute(col.getId(), (Object)valMap);
                continue;
            }
            element.setAttribute(col.getId(), val);
        }
    }

    protected void flushToEdge(EdgeDraft edgeDraft, Edge edge) {
        if (edgeDraft.getColor() != null) {
            edge.setColor(edgeDraft.getColor());
        } else {
            edge.setR(0.0f);
            edge.setG(0.0f);
            edge.setB(0.0f);
            edge.setAlpha(0.0f);
        }
        if (edgeDraft.getLabel() != null) {
            edge.setLabel(edgeDraft.getLabel());
        }
        if (edge.getTextProperties() != null) {
            edge.getTextProperties().setVisible(edgeDraft.isLabelVisible());
        }
        if (edgeDraft.getLabelSize() != -1.0f && edge.getTextProperties() != null) {
            edge.getTextProperties().setSize(edgeDraft.getLabelSize());
        }
        if (edgeDraft.getLabelColor() != null && edge.getTextProperties() != null) {
            Color labelColor = edgeDraft.getLabelColor();
            edge.getTextProperties().setColor(labelColor);
        } else {
            edge.getTextProperties().setColor(new Color(0, 0, 0, 0));
        }
        if (edgeDraft.getTimeSet() != null) {
            this.flushTimeSet(edgeDraft.getTimeSet(), (Element)edge);
        }
        if (edgeDraft.getGraphTimestamp() != null) {
            edge.addTimestamp(edgeDraft.getGraphTimestamp().doubleValue());
        } else if (edgeDraft.getGraphInterval() != null) {
            edge.addInterval(edgeDraft.getGraphInterval());
        }
        this.flushEdgeWeight(edgeDraft, edge);
        this.flushToElementAttributes((ElementDraft)edgeDraft, (Element)edge);
    }

    protected void flushTimeSet(TimeSet timeSet, Element element) {
        TimeSet existingTimeSet = (TimeSet)element.getAttribute("timeset");
        if (existingTimeSet != null && !existingTimeSet.isEmpty()) {
            for (Object o : existingTimeSet.toArray()) {
                existingTimeSet.add(o);
            }
        }
        element.setAttribute("timeset", (Object)timeSet);
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setContainers(ContainerUnloader[] containers) {
        this.containers = containers;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

