/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputKind;
import org.netbeans.core.output2.PairMap;
import org.netbeans.spi.io.InputOutputProvider;
import org.netbeans.spi.io.support.Hyperlinks;
import org.netbeans.spi.io.support.OutputColorType;
import org.netbeans.spi.io.support.OutputColors;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.IOColors;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class NbIOProvider
extends IOProvider
implements InputOutputProvider<InputOutput, OutputWriter, Integer, Integer> {
    private static final WeakHashMap<IOContainer, PairMap> containerPairMaps = new WeakHashMap();
    private static final String STDOUT = NbBundle.getMessage(NbIOProvider.class, (String)"LBL_STDOUT");
    private static final String NAME = "output2";

    public OutputWriter getStdOut() {
        if (Controller.LOG) {
            Controller.log("NbIOProvider.getStdOut");
        }
        NbIO stdout = (NbIO)this.getIO(STDOUT, false);
        NbWriter out = stdout.writer();
        NbIO.post(new IOEvent(stdout, 0, true));
        if (out != null && out.isClosed()) {
            try {
                out.reset();
                out = (NbWriter)stdout.getOut();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
                stdout = (NbIO)this.getIO(STDOUT, true);
                out = (NbWriter)stdout.getOut();
            }
        } else {
            out = (NbWriter)stdout.getOut();
        }
        return out;
    }

    public InputOutput getIO(String name, boolean newIO) {
        return this.getIO(name, newIO, new Action[0], null);
    }

    public InputOutput getIO(String name, Action[] toolbarActions) {
        return this.getIO(name, true, toolbarActions, null);
    }

    public InputOutput getIO(String name, Action[] additionalActions, IOContainer ioContainer) {
        return this.getIO(name, true, additionalActions, ioContainer);
    }

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputOutput getIO(String name, boolean newIO, Action[] toolbarActions, IOContainer ioContainer) {
        NbIO result;
        PairMap namesToIos;
        if (Controller.LOG) {
            Controller.log("GETIO: " + name + " new:" + newIO);
        }
        IOContainer realIoContainer = ioContainer == null ? IOContainer.getDefault() : ioContainer;
        WeakHashMap<IOContainer, PairMap> weakHashMap = containerPairMaps;
        synchronized (weakHashMap) {
            namesToIos = containerPairMaps.get(realIoContainer);
            result = namesToIos != null ? namesToIos.get(name) : null;
        }
        if (result == null || newIO) {
            result = new NbIO(name, toolbarActions, realIoContainer);
            weakHashMap = containerPairMaps;
            synchronized (weakHashMap) {
                namesToIos = containerPairMaps.get(realIoContainer);
                if (namesToIos == null) {
                    namesToIos = new PairMap();
                    containerPairMaps.put(realIoContainer, namesToIos);
                }
                namesToIos.add(name, result);
            }
            NbIO.post(new IOEvent(result, 0, newIO));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispose(NbIO io) {
        IOContainer ioContainer = io.getIOContainer();
        if (ioContainer == null) {
            ioContainer = IOContainer.getDefault();
        }
        WeakHashMap<IOContainer, PairMap> weakHashMap = containerPairMaps;
        synchronized (weakHashMap) {
            PairMap namesToIos = containerPairMaps.get(ioContainer);
            if (namesToIos != null) {
                namesToIos.remove(io);
                if (namesToIos.isEmpty()) {
                    containerPairMaps.remove(ioContainer);
                }
            }
        }
    }

    public String getId() {
        return this.getName();
    }

    public InputOutput getIO(String name, boolean newIO, Lookup lookup) {
        Action[] actions = (Action[])lookup.lookup(Action[].class);
        IOContainer container = (IOContainer)lookup.lookup(IOContainer.class);
        return this.getIO(name, newIO, actions == null ? new Action[]{} : actions, container);
    }

    public Reader getIn(InputOutput io) {
        return io.getIn();
    }

    public OutputWriter getOut(InputOutput io) {
        return io.getOut();
    }

    public OutputWriter getErr(InputOutput io) {
        return io.getErr();
    }

    public void print(InputOutput io, OutputWriter writer, String text, Hyperlink link, OutputColor outputColor, boolean printLineEnd) {
        boolean listenerImportant;
        Color awtColor = NbIOProvider.outputColorToAwtColor(io, outputColor);
        OutputListener listener = NbIOProvider.hyperlinkToOutputListener(link);
        boolean bl = listenerImportant = link != null && Hyperlinks.isImportant((Hyperlink)link);
        if (io instanceof NbIO) {
            OutWriter out = ((NbIO)io).out();
            if (out != null) {
                out.print(text, listener, listenerImportant, awtColor, null, OutputKind.OUT, printLineEnd);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Lookup getIOLookup(InputOutput io) {
        if (io instanceof NbIO) {
            return ((NbIO)io).getLookup();
        }
        throw new IllegalArgumentException();
    }

    public void resetIO(InputOutput io) {
        if (!(io instanceof NbIO)) {
            throw new IllegalArgumentException();
        }
        ((NbIO)io).reset();
    }

    public void showIO(InputOutput io, Set<ShowOperation> operations) {
        if (operations.contains(ShowOperation.OPEN) && operations.contains(ShowOperation.MAKE_VISIBLE) && operations.size() == 2) {
            io.select();
        } else {
            IOSelect.select((InputOutput)io, this.showOperationsToIoSelect(operations));
        }
    }

    public void closeIO(InputOutput io) {
        io.closeInputOutput();
    }

    public boolean isIOClosed(InputOutput io) {
        return io.isClosed();
    }

    public Integer getCurrentPosition(InputOutput io, OutputWriter writer) {
        if (io instanceof NbIO) {
            OutWriter out = ((NbIO)io).out();
            int size = 0;
            if (out != null) {
                size = out.getLines().getCharCount();
            }
            return size;
        }
        throw new IllegalArgumentException();
    }

    public void scrollTo(InputOutput io, OutputWriter writer, Integer position) {
        if (io instanceof NbIO) {
            NbIO.post(new IOEvent((NbIO)io, 13, position));
        }
    }

    public Integer startFold(InputOutput io, OutputWriter writer, boolean expanded) {
        if (io instanceof NbIO) {
            return ((NbIO)io).startFold(expanded);
        }
        throw new IllegalArgumentException();
    }

    public void endFold(InputOutput io, OutputWriter writer, Integer fold) {
        if (!(io instanceof NbIO)) {
            throw new IllegalArgumentException();
        }
        ((NbIO)io).endFold(fold);
    }

    public void setFoldExpanded(InputOutput io, OutputWriter writer, Integer fold, boolean expanded) {
        if (io instanceof NbIO) {
            NbIO nbIO = (NbIO)io;
            if (expanded) {
                nbIO.out().getLines().showFoldAndParentFolds(fold);
            } else {
                nbIO.out().getLines().hideFold(fold);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String getIODescription(InputOutput io) {
        if (io instanceof NbIO) {
            return ((NbIO)io).getToolTipText();
        }
        throw new IllegalArgumentException();
    }

    public void setIODescription(InputOutput io, String description) {
        if (!(io instanceof NbIO)) {
            throw new IllegalArgumentException();
        }
        ((NbIO)io).setTooltipText(description);
    }

    private Set<IOSelect.AdditionalOperation> showOperationsToIoSelect(Set<ShowOperation> operations) {
        EnumSet<IOSelect.AdditionalOperation> res = EnumSet.noneOf(IOSelect.AdditionalOperation.class);
        for (ShowOperation so : operations) {
            switch (so) {
                case OPEN: {
                    res.add(IOSelect.AdditionalOperation.OPEN);
                    break;
                }
                case MAKE_VISIBLE: {
                    res.add(IOSelect.AdditionalOperation.REQUEST_VISIBLE);
                    break;
                }
                case ACTIVATE: {
                    res.add(IOSelect.AdditionalOperation.REQUEST_ACTIVE);
                }
            }
        }
        return res;
    }

    private static OutputListener hyperlinkToOutputListener(final Hyperlink link) {
        if (link == null) {
            return null;
        }
        return new OutputListener(){

            public void outputLineSelected(OutputEvent ev) {
            }

            public void outputLineAction(OutputEvent ev) {
                Hyperlinks.invoke((Hyperlink)link);
            }

            public void outputLineCleared(OutputEvent ev) {
            }
        };
    }

    private static Color outputColorToAwtColor(InputOutput io, OutputColor color) {
        if (color == null) {
            return null;
        }
        OutputColorType type = OutputColors.getType((OutputColor)color);
        if (type == OutputColorType.RGB) {
            return new Color(OutputColors.getRGB((OutputColor)color));
        }
        switch (type) {
            case DEBUG: {
                return IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG);
            }
            case FAILURE: {
                return IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_FAILURE);
            }
            case WARNING: {
                return IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_WARNING);
            }
            case SUCCESS: {
                return IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_SUCCESS);
            }
        }
        return null;
    }
}

