/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.utils.StatisticsUtils;
import org.joda.time.DateTimeZone;
import org.openide.util.Lookup;

public class AttributeColumnsControllerImpl
implements AttributeColumnsController {
    @Override
    public boolean setAttributeValue(Object value, Element row, Column column) {
        if (!this.canChangeColumnData(column)) {
            return false;
        }
        Class targetType = column.getTypeClass();
        if (value != null && !value.getClass().equals(targetType)) {
            try {
                GraphModel graphModel = column.getTable().getGraph().getModel();
                String stringValue = AttributeUtils.print((Object)value, (TimeFormat)graphModel.getTimeFormat(), (DateTimeZone)graphModel.getTimeZone());
                value = AttributeUtils.parse((String)stringValue, (Class)targetType);
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (value == null && !this.canClearColumnData(column)) {
            return false;
        }
        try {
            if (value == null) {
                row.removeAttribute(column);
            } else {
                row.setAttribute(column, value);
            }
            return true;
        }
        catch (Exception e) {
            Logger.getLogger("").log(Level.SEVERE, null, e);
            return false;
        }
    }

    @Override
    public Column addAttributeColumn(Table table, String title, Class type) {
        if (title == null || title.isEmpty()) {
            return null;
        }
        if (table.hasColumn(title)) {
            return null;
        }
        return table.addColumn(title, type, Origin.DATA);
    }

    @Override
    public void deleteAttributeColumn(Table table, Column column) {
        if (this.canDeleteColumn(column)) {
            table.removeColumn(column);
        }
    }

    @Override
    public Column convertAttributeColumnToDynamic(Table table, Column column, double low, double high) {
        return this.convertColumnToDynamic(table, column, low, high, null);
    }

    @Override
    public Column convertAttributeColumnToNewDynamicColumn(Table table, Column column, double low, double high, String newColumnTitle) {
        return this.convertColumnToDynamic(table, column, low, high, newColumnTitle);
    }

    private Column convertColumnToDynamic(Table table, Column column, double low, double high, String newColumnTitle) {
        Column newColumn;
        Class oldType = column.getTypeClass();
        TimeRepresentation timeRepresentation = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getConfiguration().getTimeRepresentation();
        Class newType = timeRepresentation == TimeRepresentation.TIMESTAMP ? AttributeUtils.getTimestampMapType((Class)oldType) : AttributeUtils.getIntervalMapType((Class)oldType);
        if (newColumnTitle != null && newColumnTitle.equals(column.getTitle())) {
            throw new IllegalArgumentException("Column titles can't be equal");
        }
        Element[] rows = this.getTableAttributeRows(table);
        Object[] oldValues = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            oldValues[i] = rows[i].getAttribute(column);
        }
        if (newColumnTitle == null) {
            table.removeColumn(column);
            newColumn = table.addColumn(column.getTitle(), newType, column.getOrigin());
        } else {
            newColumn = table.addColumn(newColumnTitle, newType, column.getOrigin());
        }
        if (timeRepresentation == TimeRepresentation.TIMESTAMP) {
            for (int i = 0; i < rows.length; ++i) {
                if (oldValues[i] == null) continue;
                rows[i].setAttribute(newColumn, oldValues[i], low);
            }
        } else {
            Interval interval = new Interval(low, high);
            for (int i = 0; i < rows.length; ++i) {
                if (oldValues[i] == null) continue;
                rows[i].setAttribute(newColumn, oldValues[i], interval);
            }
        }
        return newColumn;
    }

    @Override
    public Column duplicateColumn(Table table, Column column, String title, Class type) {
        Column newColumn = this.addAttributeColumn(table, title, type);
        if (newColumn == null) {
            return null;
        }
        this.copyColumnDataToOtherColumn(table, column, newColumn);
        return newColumn;
    }

    @Override
    public void copyColumnDataToOtherColumn(Table table, Column sourceColumn, Column targetColumn) {
        if (sourceColumn == targetColumn) {
            throw new IllegalArgumentException("Source and target columns can't be equal");
        }
        Class targetType = targetColumn.getTypeClass();
        if (!targetType.equals(sourceColumn.getTypeClass())) {
            for (Element row : this.getTableAttributeRows(table)) {
                Object value = row.getAttribute(sourceColumn);
                this.setAttributeValue(value, row, targetColumn);
            }
        } else {
            for (Element row : this.getTableAttributeRows(table)) {
                Object value = row.getAttribute(sourceColumn);
                if (value == null) {
                    row.removeAttribute(targetColumn);
                    continue;
                }
                row.setAttribute(targetColumn, value);
            }
        }
    }

    @Override
    public void fillColumnWithValue(Table table, Column column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Element row : this.getTableAttributeRows(table)) {
                this.setAttributeValue(value, row, column);
            }
        }
    }

    @Override
    public void fillNodesColumnWithValue(Node[] nodes, Column column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Node node : nodes) {
                this.setAttributeValue(value, (Element)node, column);
            }
        }
    }

    @Override
    public void fillEdgesColumnWithValue(Edge[] edges, Column column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Edge edge : edges) {
                this.setAttributeValue(value, (Element)edge, column);
            }
        }
    }

    @Override
    public void clearColumnData(Table table, Column column) {
        if (this.canClearColumnData(column)) {
            for (Element row : this.getTableAttributeRows(table)) {
                row.removeAttribute(column);
            }
        }
    }

    @Override
    public Map<Object, Integer> calculateColumnValuesFrequencies(Table table, Column column) {
        HashMap<Object, Integer> valuesFrequencies = new HashMap<Object, Integer>();
        for (Element row : this.getTableAttributeRows(table)) {
            Object value = row.getAttribute(column);
            if (valuesFrequencies.containsKey(value)) {
                valuesFrequencies.put(value, (Integer)valuesFrequencies.get(value) + 1);
                continue;
            }
            valuesFrequencies.put(value, 1);
        }
        return valuesFrequencies;
    }

    @Override
    public Column createBooleanMatchesColumn(Table table, Column column, String newColumnTitle, Pattern pattern) {
        if (pattern != null) {
            Column newColumn = this.addAttributeColumn(table, newColumnTitle, Boolean.class);
            if (newColumn == null) {
                return null;
            }
            TimeFormat timeFormat = table.getGraph().getModel().getTimeFormat();
            DateTimeZone timeZone = table.getGraph().getModel().getTimeZone();
            for (Element row : this.getTableAttributeRows(table)) {
                Object value = row.getAttribute(column);
                Matcher matcher = value != null ? pattern.matcher(AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone)) : pattern.matcher("");
                row.setAttribute(newColumn, (Object)matcher.matches());
            }
            return newColumn;
        }
        return null;
    }

    @Override
    public void negateBooleanColumn(Table table, Column column) {
        if (column.getTypeClass().equals(Boolean.class)) {
            this.negateColumnBooleanType(table, column);
        } else if (column.getTypeClass().equals(Boolean[].class)) {
            this.negateColumnListBooleanType(table, column);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Column createFoundGroupsListColumn(Table table, Column column, String newColumnTitle, Pattern pattern) {
        if (pattern != null) {
            Column newColumn = this.addAttributeColumn(table, newColumnTitle, String[].class);
            if (newColumn == null) {
                return null;
            }
            ArrayList<String> foundGroups = new ArrayList<String>();
            TimeFormat timeFormat = table.getGraph().getModel().getTimeFormat();
            DateTimeZone timeZone = table.getGraph().getModel().getTimeZone();
            for (Element row : this.getTableAttributeRows(table)) {
                Object value = row.getAttribute(column);
                Matcher matcher = value != null ? pattern.matcher(AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone)) : pattern.matcher("");
                while (matcher.find()) {
                    foundGroups.add(matcher.group());
                }
                if (foundGroups.size() > 0) {
                    row.setAttribute(newColumn, (Object)foundGroups.toArray(new String[0]));
                    foundGroups.clear();
                    continue;
                }
                row.setAttribute(newColumn, null);
            }
            return newColumn;
        }
        return null;
    }

    @Override
    public void clearNodeData(Node node, Column[] columnsToClear) {
        this.clearRowData((Element)node, columnsToClear);
    }

    @Override
    public void clearNodesData(Node[] nodes, Column[] columnsToClear) {
        for (Node n : nodes) {
            this.clearNodeData(n, columnsToClear);
        }
    }

    @Override
    public void clearEdgeData(Edge edge, Column[] columnsToClear) {
        this.clearRowData((Element)edge, columnsToClear);
    }

    @Override
    public void clearEdgesData(Edge[] edges, Column[] columnsToClear) {
        for (Edge e : edges) {
            this.clearEdgeData(e, columnsToClear);
        }
    }

    @Override
    public void clearRowData(Element row, Column[] columnsToClear) {
        if (columnsToClear != null) {
            for (Column column : columnsToClear) {
                if (!this.canClearColumnData(column)) continue;
                row.removeAttribute(column);
            }
        } else {
            Table table = row instanceof Node ? ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable() : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
            for (Column column : table) {
                if (!this.canClearColumnData(column)) continue;
                row.removeAttribute(column);
            }
        }
    }

    @Override
    public void copyNodeDataToOtherNodes(Node node, Node[] otherNodes, Column[] columnsToCopy) {
        this.copyRowDataToOtherRows((Element)node, (Element[])otherNodes, columnsToCopy);
    }

    @Override
    public void copyEdgeDataToOtherEdges(Edge edge, Edge[] otherEdges, Column[] columnsToCopy) {
        this.copyRowDataToOtherRows((Element)edge, (Element[])otherEdges, columnsToCopy);
    }

    @Override
    public void copyRowDataToOtherRows(Element row, Element[] otherRows, Column[] columnsToCopy) {
        if (columnsToCopy != null) {
            for (Column column : columnsToCopy) {
                if (!this.canChangeColumnData(column)) continue;
                for (Element otherRow : otherRows) {
                    Object value = row.getAttribute(column);
                    this.setAttributeValue(value, otherRow, column);
                }
            }
        } else {
            Table table = row instanceof Node ? ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable() : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
            for (Column column : table) {
                if (!this.canChangeColumnData(column)) continue;
                for (Element otherRow : otherRows) {
                    otherRow.removeAttribute(column);
                }
            }
        }
    }

    @Override
    public Element[] getTableAttributeRows(Table table) {
        if (this.isNodeTable(table)) {
            return this.getNodesArray();
        }
        return this.getEdgesArray();
    }

    @Override
    public int getTableRowsCount(Table table) {
        if (this.isNodeTable(table)) {
            return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getNodesCount();
        }
        return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getEdgesCount();
    }

    @Override
    public boolean isNodeTable(Table table) {
        return Node.class.equals((Object)table.getElementClass());
    }

    @Override
    public boolean isEdgeTable(Table table) {
        return Edge.class.equals((Object)table.getElementClass());
    }

    @Override
    public boolean canDeleteColumn(Column column) {
        return !column.isReadOnly() && column.getOrigin() != Origin.PROPERTY;
    }

    @Override
    public boolean isTableColumn(Table table, Column column) {
        return column.getTable() == table;
    }

    @Override
    public boolean isNodeColumn(Column column) {
        return this.isNodeTable(column.getTable());
    }

    @Override
    public boolean isEdgeColumn(Column column) {
        return this.isEdgeTable(column.getTable());
    }

    @Override
    public boolean canChangeColumnData(Column column) {
        return !column.isReadOnly();
    }

    @Override
    public boolean canClearColumnData(Column column) {
        if (this.isEdgeColumn(column) && column.getId().equalsIgnoreCase("weight")) {
            return false;
        }
        return !column.isReadOnly();
    }

    @Override
    public boolean canConvertColumnToDynamic(Column column) {
        if (column.isReadOnly() || AttributeUtils.isDynamicType((Class)column.getTypeClass())) {
            return false;
        }
        try {
            AttributeUtils.getIntervalMapType((Class)column.getTypeClass());
            AttributeUtils.getTimestampMapType((Class)column.getTypeClass());
        }
        catch (Exception e) {
            return false;
        }
        if (this.isNodeColumn(column) || this.isEdgeColumn(column)) {
            return !column.getTitle().equalsIgnoreCase("Label");
        }
        return true;
    }

    @Override
    public BigDecimal[] getNumberOrNumberListColumnStatistics(Table table, Column column) {
        return StatisticsUtils.getAllStatistics((Number[])this.getColumnNumbers(table, column));
    }

    @Override
    public Number[] getColumnNumbers(Table table, Column column) {
        return this.getRowsColumnNumbers(this.getTableAttributeRows(table), column);
    }

    @Override
    public Number[] getRowsColumnNumbers(Element[] rows, Column column) {
        Class type = column.getTypeClass();
        if (!AttributeUtils.isNumberType((Class)type)) {
            throw new IllegalArgumentException("The column has to be a number column");
        }
        boolean isDynamic = AttributeUtils.isDynamicType((Class)type);
        boolean isArray = type.isArray();
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (Element row : rows) {
            Object value = row.getAttribute(column);
            if (value == null) continue;
            if (!isDynamic) {
                if (isArray) {
                    numbers.addAll(this.getArrayNumbers(value));
                    continue;
                }
                Number number = (Number)row.getAttribute(column);
                if (number == null) continue;
                numbers.add(number);
                continue;
            }
            numbers.addAll(this.getDynamicNumberColumnNumbers(row, column));
        }
        return numbers.toArray(new Number[0]);
    }

    @Override
    public Number[] getRowNumbers(Element row, Column[] columns) {
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (Column column : columns) {
            Class type = column.getTypeClass();
            if (!AttributeUtils.isNumberType((Class)type)) {
                throw new IllegalArgumentException("The column has to be a number column");
            }
            Object value = row.getAttribute(column);
            if (value == null) continue;
            if (!AttributeUtils.isDynamicType((Class)type)) {
                if (type.isArray()) {
                    numbers.addAll(this.getArrayNumbers(value));
                    continue;
                }
                Number number = (Number)value;
                if (number == null) continue;
                numbers.add(number);
                continue;
            }
            numbers.addAll(this.getDynamicNumberColumnNumbers(row, column));
        }
        return numbers.toArray(new Number[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importCSVToNodesTable(Graph graph, File file, Character separator, Charset charset, String[] columnNames, Class[] columnTypes, boolean assignNewNodeIds) {
        if (columnNames == null || columnNames.length == 0) {
            return;
        }
        if (columnTypes == null || columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("Column names length must be the same as column types length");
        }
        try (CsvReader reader = null;){
            Table nodesTable = graph.getModel().getNodeTable();
            String idColumn = null;
            HashMap<Column, String> columnHeaders = new HashMap<Column, String>();
            for (int i = 0; i < columnNames.length; ++i) {
                Column column;
                if (columnNames[i].equalsIgnoreCase("id")) {
                    if (idColumn != null) continue;
                    idColumn = columnNames[i];
                    continue;
                }
                if (nodesTable.hasColumn(columnNames[i])) {
                    column = nodesTable.getColumn(columnNames[i]);
                    columnHeaders.put(column, columnNames[i]);
                    continue;
                }
                column = this.addAttributeColumn(nodesTable, columnNames[i], columnTypes[i]);
                if (column == null) continue;
                columnHeaders.put(column, columnNames[i]);
            }
            Set columnList = columnHeaders.keySet();
            GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
            reader = new CsvReader((InputStream)new FileInputStream(file), separator.charValue(), charset);
            reader.setTrimWhitespace(false);
            reader.readHeaders();
            while (reader.readRecord()) {
                Node node;
                if (idColumn != null) {
                    String id = reader.get(idColumn);
                    if (id == null || id.isEmpty()) {
                        node = gec.createNode(null, graph);
                    } else {
                        graph.readLock();
                        node = graph.getNode((Object)id);
                        graph.readUnlock();
                        if (node != null) {
                            if (assignNewNodeIds) {
                                node = gec.createNode(null, graph);
                            }
                        } else {
                            node = gec.createNode(null, id, graph);
                        }
                    }
                } else {
                    node = gec.createNode(null);
                }
                for (Column column : columnList) {
                    this.setAttributeValue(reader.get((String)columnHeaders.get(column)), (Element)node, column);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importCSVToEdgesTable(Graph graph, File file, Character separator, Charset charset, String[] columnNames, Class[] columnTypes, boolean createNewNodes) {
        if (columnNames == null || columnNames.length == 0) {
            return;
        }
        if (columnTypes == null || columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("Column names length must be the same as column types length");
        }
        try (CsvReader reader = null;){
            Table edgesTable = graph.getModel().getEdgeTable();
            Column weightColumn = edgesTable.getColumn("Weight");
            boolean isDynamicWeight = weightColumn.isDynamic();
            String idColumnHeader = null;
            String sourceColumnHeader = null;
            String targetColumnHeader = null;
            String typeColumnHeader = null;
            String weightColumnHeader = null;
            HashMap<Column, String> columnHeaders = new HashMap<Column, String>();
            for (int i = 0; i < columnNames.length; ++i) {
                Column column;
                if (columnNames[i].equalsIgnoreCase("id")) {
                    if (idColumnHeader != null) continue;
                    idColumnHeader = columnNames[i];
                    continue;
                }
                if (columnNames[i].equalsIgnoreCase("source") && sourceColumnHeader == null) {
                    sourceColumnHeader = columnNames[i];
                    continue;
                }
                if (columnNames[i].equalsIgnoreCase("target") && targetColumnHeader == null) {
                    targetColumnHeader = columnNames[i];
                    continue;
                }
                if (columnNames[i].equalsIgnoreCase("type") && typeColumnHeader == null) {
                    typeColumnHeader = columnNames[i];
                    continue;
                }
                if (edgesTable.hasColumn(columnNames[i])) {
                    column = edgesTable.getColumn(columnNames[i]);
                    columnHeaders.put(column, columnNames[i]);
                    if (!column.equals(weightColumn)) continue;
                    weightColumnHeader = columnNames[i];
                    continue;
                }
                column = this.addAttributeColumn(edgesTable, columnNames[i], columnTypes[i]);
                if (column == null) continue;
                columnHeaders.put(column, columnNames[i]);
            }
            Set columnList = columnHeaders.keySet();
            GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
            reader = new CsvReader((InputStream)new FileInputStream(file), separator.charValue(), charset);
            reader.setTrimWhitespace(false);
            reader.readHeaders();
            int recordNumber = 0;
            while (reader.readRecord()) {
                String type;
                Edge edge = null;
                ++recordNumber;
                String sourceId = reader.get(sourceColumnHeader);
                String targetId = reader.get(targetColumnHeader);
                if (sourceId == null || sourceId.trim().isEmpty() || targetId == null || targetId.trim().isEmpty()) {
                    Logger.getLogger("").log(Level.WARNING, "Ignoring record {0} due to empty source and/or target node ids", recordNumber);
                    continue;
                }
                graph.readLock();
                Node source = graph.getNode((Object)sourceId);
                graph.readUnlock();
                if (source == null) {
                    if (!createNewNodes) continue;
                    if (source == null) {
                        source = gec.createNode(null, sourceId, graph);
                    }
                }
                graph.readLock();
                Node target = graph.getNode((Object)targetId);
                graph.readUnlock();
                if (target == null) {
                    if (!createNewNodes) continue;
                    if (target == null) {
                        target = gec.createNode(null, targetId, graph);
                    }
                }
                boolean directed = typeColumnHeader != null ? ((type = reader.get(typeColumnHeader)) != null ? !type.equalsIgnoreCase("undirected") : true) : true;
                if (idColumnHeader != null) {
                    String id = reader.get(idColumnHeader);
                    if (id == null || id.isEmpty()) {
                        edge = gec.createEdge(source, target, directed);
                    } else {
                        Edge edgeById = graph.getEdge((Object)id);
                        if (edgeById == null) {
                            edge = gec.createEdge(id, source, target, directed);
                        }
                        if (edge == null) {
                            edge = gec.createEdge(source, target, directed);
                        }
                    }
                } else {
                    edge = gec.createEdge(source, target, directed);
                }
                if (edge != null) {
                    for (Column column : columnList) {
                        this.setAttributeValue(reader.get((String)columnHeaders.get(column)), (Element)edge, column);
                    }
                    continue;
                }
                edge = graph.getEdge(source, target);
                if (edge == null && (edge = graph.getEdge(target, source)) != null && edge.isDirected()) {
                    edge = null;
                }
                if (edge == null || isDynamicWeight) continue;
                if (weightColumnHeader != null) {
                    String weight = reader.get(weightColumnHeader);
                    try {
                        Float weightFloat = Float.valueOf(Float.parseFloat(weight));
                        edge.setWeight(edge.getWeight() + (double)weightFloat.floatValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        edge.setWeight(edge.getWeight() + 1.0);
                    }
                    continue;
                }
                edge.setWeight(edge.getWeight() + 1.0);
            }
        }
    }

    @Override
    public void mergeRowsValues(Column[] columns, AttributeRowsMergeStrategy[] mergeStrategies, Element[] rows, Element selectedRow, Element resultRow) {
        if (columns.length != mergeStrategies.length) {
            throw new IllegalArgumentException("The number of columns must be equal to the number of merge strategies provided");
        }
        if (selectedRow == null) {
            selectedRow = rows[0];
        }
        int i = 0;
        for (Column column : columns) {
            Object value;
            AttributeRowsMergeStrategy mergeStrategy = mergeStrategies[i];
            if (mergeStrategy != null) {
                mergeStrategy.setup(rows, selectedRow, column);
                if (mergeStrategy.canExecute()) {
                    mergeStrategy.execute();
                    value = mergeStrategy.getReducedValue();
                } else {
                    value = selectedRow.getAttribute(column);
                }
            } else {
                value = selectedRow.getAttribute(column);
            }
            this.setAttributeValue(value, resultRow, column);
            ++i;
        }
    }

    @Override
    public List<List<Node>> detectNodeDuplicatesByColumn(Column column, boolean caseSensitive) {
        HashMap valuesMap = new HashMap();
        Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
        TimeFormat timeFormat = graph.getModel().getTimeFormat();
        DateTimeZone timeZone = graph.getModel().getTimeZone();
        for (Node node : graph.getNodes().toArray()) {
            Object value = node.getAttribute(column);
            if (value == null) continue;
            String strValue = AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone);
            if (!caseSensitive) {
                strValue = strValue.toLowerCase();
            }
            if (valuesMap.containsKey(strValue)) {
                ((List)valuesMap.get(strValue)).add(node);
                continue;
            }
            ArrayList<Node> newGroup = new ArrayList<Node>();
            newGroup.add(node);
            valuesMap.put(strValue, newGroup);
        }
        ArrayList<List<Node>> groupsList = new ArrayList<List<Node>>();
        for (List group : valuesMap.values()) {
            if (group.size() <= 1) continue;
            groupsList.add(group);
        }
        return groupsList;
    }

    private Node[] getNodesArray() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph().getNodes().toArray();
    }

    private Edge[] getEdgesArray() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph().getEdges().toArray();
    }

    private void negateColumnBooleanType(Table table, Column column) {
        for (Element row : this.getTableAttributeRows(table)) {
            Object value = row.getAttribute(column);
            if (value == null) continue;
            Boolean newValue = (Boolean)value == false;
            row.setAttribute(column, (Object)newValue);
        }
    }

    private void negateColumnListBooleanType(Table table, Column column) {
        for (Element row : this.getTableAttributeRows(table)) {
            Object value = row.getAttribute(column);
            if (value == null) continue;
            Boolean[] list = (Boolean[])value;
            Boolean[] newValues = new Boolean[list.length];
            for (int i = 0; i < list.length; ++i) {
                newValues[i] = list[i] == false;
            }
            row.setAttribute(column, (Object)newValues);
        }
    }

    private List<Number> getDynamicNumberColumnNumbers(Element row, Column column) {
        Class type = column.getTypeClass();
        if (!AttributeUtils.isNumberType((Class)type) || !AttributeUtils.isDynamicType((Class)type)) {
            throw new IllegalArgumentException("Column must be a dynamic number column");
        }
        if (TimestampMap.class.isAssignableFrom(type)) {
            TimestampMap timestampMap = (TimestampMap)row.getAttribute(column);
            if (timestampMap == null) {
                return new ArrayList<Number>();
            }
            Number[] dynamicNumbers = (Number[])timestampMap.toValuesArray();
            return Arrays.asList(dynamicNumbers);
        }
        if (IntervalMap.class.isAssignableFrom(type)) {
            IntervalMap intervalMap = (IntervalMap)row.getAttribute(column);
            if (intervalMap == null) {
                return new ArrayList<Number>();
            }
            Number[] dynamicNumbers = (Number[])intervalMap.toValuesArray();
            return Arrays.asList(dynamicNumbers);
        }
        throw new IllegalArgumentException("Unsupported dynamic type class " + type.getCanonicalName());
    }

    private List<Number> getArrayNumbers(Object arr) {
        int length = Array.getLength(arr);
        ArrayList<Number> result = new ArrayList<Number>();
        for (int i = 0; i < length; ++i) {
            result.add((Number)Array.get(arr, i));
        }
        return result;
    }
}

