/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;

public class SupportedColumnTypeWrapper
implements Comparable<SupportedColumnTypeWrapper> {
    private final Class<?> type;

    public SupportedColumnTypeWrapper(Class type) {
        this.type = type;
    }

    public String toString() {
        if (AttributeUtils.isArrayType(this.type)) {
            return String.format("%s list", this.type.getComponentType().getSimpleName());
        }
        return this.type.getSimpleName();
    }

    public Class<?> getType() {
        return this.type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.type != null ? this.type.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportedColumnTypeWrapper other = (SupportedColumnTypeWrapper)obj;
        return this.type == other.type || this.type != null && this.type.equals(other.type);
    }

    @Override
    public int compareTo(SupportedColumnTypeWrapper other) {
        boolean isDynamicOther;
        boolean isArrayOther;
        boolean isArray = this.type.isArray();
        if (isArray != (isArrayOther = other.type.isArray())) {
            if (isArray) {
                return 1;
            }
            return -1;
        }
        boolean isDynamic = AttributeUtils.isDynamicType(this.type);
        if (isDynamic != (isDynamicOther = AttributeUtils.isDynamicType(other.type))) {
            if (isDynamic) {
                return 1;
            }
            return -1;
        }
        return this.type.getSimpleName().compareTo(other.type.getSimpleName());
    }

    public static List<SupportedColumnTypeWrapper> buildOrderedSupportedTypesList(GraphModel graphModel) {
        ArrayList<SupportedColumnTypeWrapper> supportedTypesWrappers = new ArrayList<SupportedColumnTypeWrapper>();
        TimeRepresentation timeRepresentation = graphModel.getConfiguration().getTimeRepresentation();
        for (Class type : AttributeUtils.getSupportedTypes()) {
            if (type.equals(Map.class) || type.equals(List.class) || type.equals(Set.class) || !AttributeUtils.isStandardizedType((Class)type) || !SupportedColumnTypeWrapper.isTypeAvailable(type, timeRepresentation)) continue;
            supportedTypesWrappers.add(new SupportedColumnTypeWrapper(type));
        }
        Collections.sort(supportedTypesWrappers);
        return supportedTypesWrappers;
    }

    private static boolean isTypeAvailable(Class<?> type, TimeRepresentation timeRepresentation) {
        if (AttributeUtils.isDynamicType(type)) {
            switch (timeRepresentation) {
                case INTERVAL: {
                    return SupportedColumnTypeWrapper.isIntervalType(type);
                }
                case TIMESTAMP: {
                    return SupportedColumnTypeWrapper.isTimestampType(type);
                }
            }
            throw new IllegalArgumentException("Unknown timeRepresentation");
        }
        return true;
    }

    private static boolean isTimestampType(Class<?> type) {
        return TimestampSet.class.isAssignableFrom(type) || TimestampMap.class.isAssignableFrom(type);
    }

    private static boolean isIntervalType(Class<?> type) {
        return IntervalSet.class.isAssignableFrom(type) || IntervalMap.class.isAssignableFrom(type);
    }
}

