/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.timeline;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.dynamic.DynamicRangeBuilder;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.timeline.GraphObserverThread;
import org.gephi.timeline.TimelineModelImpl;
import org.gephi.timeline.api.TimelineChart;
import org.gephi.timeline.api.TimelineController;
import org.gephi.timeline.api.TimelineModel;
import org.gephi.timeline.api.TimelineModelEvent;
import org.gephi.timeline.api.TimelineModelListener;
import org.openide.util.Lookup;

public class TimelineControllerImpl
implements TimelineController {
    private final List<TimelineModelListener> listeners = new ArrayList<TimelineModelListener>();
    private TimelineModelImpl model;
    private GraphObserverThread observerThread;
    private GraphModel graphModel;
    private ScheduledExecutorService playExecutor;
    private FilterModel filterModel;
    private FilterController filterController;

    public TimelineControllerImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        this.filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                TimelineControllerImpl.this.model = (TimelineModelImpl)workspace.getLookup().lookup(TimelineModelImpl.class);
                TimelineControllerImpl.this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
                if (TimelineControllerImpl.this.model == null) {
                    TimelineControllerImpl.this.model = new TimelineModelImpl(TimelineControllerImpl.this.graphModel);
                    workspace.add((Object)TimelineControllerImpl.this.model);
                }
                TimelineControllerImpl.this.observerThread = new GraphObserverThread(TimelineControllerImpl.this, TimelineControllerImpl.this.model);
                TimelineControllerImpl.this.setup();
                TimelineControllerImpl.this.observerThread.start();
                TimelineControllerImpl.this.filterModel = TimelineControllerImpl.this.filterController.getModel(workspace);
            }

            public void unselect(Workspace workspace) {
                TimelineControllerImpl.this.unsetup();
                if (TimelineControllerImpl.this.observerThread != null) {
                    TimelineControllerImpl.this.observerThread.stopThread();
                }
                TimelineControllerImpl.this.filterModel = null;
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                TimelineControllerImpl.this.model = null;
                TimelineControllerImpl.this.graphModel = null;
                TimelineControllerImpl.this.filterModel = null;
                if (TimelineControllerImpl.this.observerThread != null) {
                    TimelineControllerImpl.this.observerThread.stopThread();
                }
                TimelineControllerImpl.this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.MODEL, null, null));
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.model = (TimelineModelImpl)pc.getCurrentWorkspace().getLookup().lookup(TimelineModelImpl.class);
            this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(pc.getCurrentWorkspace());
            if (this.model == null) {
                this.model = new TimelineModelImpl(this.graphModel);
                pc.getCurrentWorkspace().add((Object)this.model);
            }
            this.setup();
        }
    }

    @Override
    public synchronized TimelineModel getModel(Workspace workspace) {
        return (TimelineModel)workspace.getLookup().lookup(TimelineModel.class);
    }

    @Override
    public synchronized TimelineModel getModel() {
        return this.model;
    }

    private void setup() {
        this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.MODEL, this.model, null));
    }

    private void unsetup() {
    }

    @Override
    public void setTimeFormat(TimeFormat timeFormat) {
        this.graphModel.setTimeFormat(timeFormat);
    }

    protected boolean setMinMax(double min, double max) {
        if (this.model != null) {
            if (min > max) {
                throw new IllegalArgumentException("min should be less than max");
            }
            if (min == max) {
                return false;
            }
            double previousBoundsMin = this.model.getCustomMin();
            double previousBoundsMax = this.model.getCustomMax();
            if (this.model.getCustomMin() == this.model.getPreviousMin()) {
                this.model.setCustomMin(min);
            } else if (this.model.getCustomMin() < min) {
                this.model.setCustomMin(min);
            }
            if (this.model.getCustomMax() == this.model.getPreviousMax()) {
                this.model.setCustomMax(max);
            } else if (this.model.getCustomMax() > max) {
                this.model.setCustomMax(max);
            }
            this.model.setPreviousMin(min);
            this.model.setPreviousMax(max);
            if (this.model.hasValidBounds()) {
                this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.MIN_MAX, this.model, new double[]{min, max}));
                if (this.model.getCustomMax() != max || this.model.getCustomMin() != min) {
                    this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.CUSTOM_BOUNDS, this.model, new double[]{min, max}));
                }
            }
            if ((Double.isInfinite(previousBoundsMax) || Double.isInfinite(previousBoundsMin)) && this.model.hasValidBounds()) {
                this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.VALID_BOUNDS, this.model, true));
            } else if (!(Double.isInfinite(previousBoundsMax) || Double.isInfinite(previousBoundsMin) || this.model.hasValidBounds())) {
                this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.VALID_BOUNDS, this.model, false));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setCustomBounds(double min, double max) {
        if (this.model != null && (this.model.getCustomMin() != min || this.model.getCustomMax() != max)) {
            if (min >= max) {
                throw new IllegalArgumentException("min should be less than max");
            }
            if (min < this.model.getMin() || max > this.model.getMax()) {
                throw new IllegalArgumentException("Min and max should be in the bounds");
            }
            if (this.model.getIntervalStart() < min || this.model.getIntervalEnd() > max) {
                // empty if block
            }
            double[] val = new double[]{min, max};
            this.model.setCustomMin(min);
            this.model.setCustomMax(max);
            this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.CUSTOM_BOUNDS, this.model, val));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.model != null) {
            if (enabled != this.model.isEnabled() && this.model.hasValidBounds()) {
                this.model.setEnabled(enabled);
                this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.ENABLED, this.model, enabled));
            }
            if (!enabled) {
                this.setInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            }
        }
    }

    @Override
    public void setInterval(double from, double to) {
        if (this.model != null && (this.model.getIntervalStart() != from || this.model.getIntervalEnd() != to)) {
            Query[] dynamicQueries;
            Query query;
            if (from >= to) {
                throw new IllegalArgumentException("from should be less than to");
            }
            if (!(Double.isInfinite(from) && Double.isInfinite(to) || !(from < this.model.getCustomMin()) && !(to > this.model.getCustomMax()))) {
                throw new IllegalArgumentException("From and to should be in the bounds");
            }
            this.model.setInterval(from, to);
            Query dynamicQuery = null;
            boolean selecting = false;
            if (this.filterModel.getCurrentQuery() != null) {
                query = this.filterModel.getCurrentQuery();
                dynamicQueries = query.getQueries(DynamicRangeBuilder.DynamicRangeFilter.class);
                if (dynamicQueries.length > 0) {
                    dynamicQuery = query;
                    selecting = this.filterModel.isSelecting();
                }
            } else if (this.filterModel.getQueries().length == 1 && (dynamicQueries = (query = this.filterModel.getQueries()[0]).getQueries(DynamicRangeBuilder.DynamicRangeFilter.class)).length > 0) {
                dynamicQuery = query;
            }
            if (Double.isInfinite(from) && Double.isInfinite(to)) {
                if (dynamicQuery != null) {
                    this.filterController.remove(dynamicQuery);
                }
            } else {
                DynamicRangeBuilder rangeBuilder;
                FilterBuilder[] fb;
                if (dynamicQuery == null && (fb = (rangeBuilder = (DynamicRangeBuilder)this.filterModel.getLibrary().getLookup().lookup(DynamicRangeBuilder.class)).getBuilders(this.filterModel.getWorkspace())).length > 0) {
                    dynamicQuery = this.filterController.createQuery(fb[0]);
                    this.filterController.add(dynamicQuery);
                }
                if (dynamicQuery != null) {
                    dynamicQuery.getFilter().getProperties()[0].setValue((Object)new Range((Number)from, (Number)to));
                    if (selecting) {
                        this.filterController.selectVisible(dynamicQuery);
                    } else {
                        this.filterController.filterVisible(dynamicQuery);
                    }
                    this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.INTERVAL, this.model, new double[]{from, to}));
                }
            }
        }
    }

    @Override
    public String[] getDynamicGraphColumns() {
        if (this.graphModel != null) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String k : this.graphModel.getGraph().getAttributeKeys()) {
                Object a = this.graphModel.getGraph().getAttribute(k);
                if (!(a instanceof IntervalMap) && !(a instanceof TimestampMap)) continue;
                columns.add(k);
            }
            return columns.toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public void selectColumn(final String column) {
        if (this.model != null && (this.model.getChart() != null || column != null || this.model.getChart() != null && !this.model.getChart().getColumn().equals(column))) {
            if (column != null && this.graphModel.getGraph().getAttribute(column) != null) {
                throw new IllegalArgumentException("Not a graph column");
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TimelineChart chart = null;
                    Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraphVisible();
                    if (column != null) {
                        // empty if block
                    }
                    TimelineControllerImpl.this.model.setChart(chart);
                    TimelineControllerImpl.this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.CHART, TimelineControllerImpl.this.model, chart));
                }
            }, "Timeline Chart");
            thread.start();
        }
    }

    protected void fireTimelineModelEvent(TimelineModelEvent event) {
        for (TimelineModelListener listener : this.listeners.toArray(new TimelineModelListener[0])) {
            listener.timelineModelChanged(event);
        }
    }

    @Override
    public synchronized void addListener(TimelineModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeListener(TimelineModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void startPlay() {
        if (this.model != null && !this.model.isPlaying()) {
            this.model.setPlaying(true);
            this.playExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "Timeline animator");
                }
            });
            this.playExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    double min = TimelineControllerImpl.this.model.getCustomMin();
                    double max = TimelineControllerImpl.this.model.getCustomMax();
                    double duration = max - min;
                    double step = duration * TimelineControllerImpl.this.model.getPlayStep() * 0.95;
                    double from = TimelineControllerImpl.this.model.getIntervalStart();
                    double to = TimelineControllerImpl.this.model.getIntervalEnd();
                    boolean bothBounds = TimelineControllerImpl.this.model.getPlayMode().equals((Object)TimelineModel.PlayMode.TWO_BOUNDS);
                    boolean someAction = false;
                    if (bothBounds) {
                        if (step > 0.0 && to < max) {
                            from += step;
                            to += step;
                            someAction = true;
                        } else if (step < 0.0 && from > min) {
                            from += step;
                            to += step;
                            someAction = true;
                        }
                    } else if (step > 0.0 && to < max) {
                        to += step;
                        someAction = true;
                    } else if (step < 0.0 && from > min) {
                        from += step;
                        someAction = true;
                    }
                    if (someAction) {
                        from = Math.max(from, min);
                        to = Math.min(to, max);
                        TimelineControllerImpl.this.setInterval(from, to);
                    } else {
                        TimelineControllerImpl.this.stopPlay();
                    }
                }
            }, this.model.getPlayDelay(), this.model.getPlayDelay(), TimeUnit.MILLISECONDS);
            this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.PLAY_START, this.model, null));
        }
    }

    @Override
    public void stopPlay() {
        if (this.model != null && this.model.isPlaying()) {
            this.model.setPlaying(false);
            this.fireTimelineModelEvent(new TimelineModelEvent(TimelineModelEvent.EventType.PLAY_STOP, this.model, null));
        }
        if (this.playExecutor != null) {
            this.playExecutor.shutdown();
        }
    }

    @Override
    public void setPlaySpeed(int delay) {
        if (this.model != null) {
            this.model.setPlayDelay(delay);
        }
    }

    @Override
    public void setPlayStep(double step) {
        if (this.model != null) {
            this.model.setPlayStep(step);
        }
    }

    @Override
    public void setPlayMode(TimelineModel.PlayMode playMode) {
        if (this.model != null) {
            this.model.setPlayMode(playMode);
        }
    }
}

