/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization;

import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.visualization.GraphLimits;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.api.VisualizationController;
import org.gephi.visualization.api.selection.SelectionManager;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.apiimpl.GraphIO;
import org.gephi.visualization.apiimpl.Scheduler;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.apiimpl.VizEventManager;
import org.gephi.visualization.bridge.DataBridge;
import org.gephi.visualization.events.StandardVizEventManager;
import org.gephi.visualization.opengl.AbstractEngine;
import org.gephi.visualization.opengl.CompatibilityEngine;
import org.gephi.visualization.scheduler.CompatibilityScheduler;
import org.gephi.visualization.screenshot.ScreenshotMaker;
import org.gephi.visualization.swing.GLAbstractListener;
import org.gephi.visualization.swing.GraphCanvas;
import org.gephi.visualization.swing.NewtGraphCanvas;
import org.gephi.visualization.swing.StandardGraphIO;
import org.gephi.visualization.text.TextManager;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class VizController
implements VisualizationController {
    private static VizController instance;
    private GLAbstractListener drawable;
    private AbstractEngine engine;
    private Scheduler scheduler;
    private VizConfig vizConfig;
    private GraphIO graphIO;
    private VizEventManager vizEventManager;
    private GraphLimits limits;
    private DataBridge dataBridge;
    private TextManager textManager;
    private ScreenshotMaker screenshotMaker;
    private SelectionManager selectionManager;
    private VizModel currentModel;

    public static synchronized VizController getInstance() {
        if (instance == null) {
            instance = (VizController)Lookup.getDefault().lookup(VisualizationController.class);
            instance.initInstances();
        }
        return instance;
    }

    public void initInstances() {
        this.vizConfig = new VizConfig();
        this.graphIO = new StandardGraphIO();
        this.engine = new CompatibilityEngine();
        this.vizEventManager = new StandardVizEventManager();
        this.scheduler = new CompatibilityScheduler();
        this.limits = new GraphLimits();
        this.dataBridge = new DataBridge();
        this.textManager = new TextManager();
        this.screenshotMaker = new ScreenshotMaker();
        this.currentModel = new VizModel(true);
        this.selectionManager = new SelectionManager();
        if (!this.vizConfig.isUseGLJPanel()) {
            this.drawable = Utilities.isMac() ? this.createCanvas() : this.createNewtCanvas();
        }
        this.drawable.initArchitecture();
        this.engine.initArchitecture();
        ((CompatibilityScheduler)this.scheduler).initArchitecture();
        ((StandardGraphIO)this.graphIO).initArchitecture();
        this.dataBridge.initArchitecture();
        this.textManager.initArchitecture();
        this.screenshotMaker.initArchitecture();
        this.vizEventManager.initArchitecture();
        this.selectionManager.initArchitecture();
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                if (workspace.getLookup().lookup(VizModel.class) == null) {
                    workspace.add((Object)new VizModel(workspace));
                }
            }

            public void select(Workspace workspace) {
                VizController.this.engine.reinit();
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                VizController.this.engine.reinit();
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.engine.reinit();
        }
    }

    public void refreshWorkspace() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        VizModel model = null;
        if (pc.getCurrentWorkspace() == null) {
            model = new VizModel(true);
        } else {
            model = (VizModel)pc.getCurrentWorkspace().getLookup().lookup(VizModel.class);
            if (model == null) {
                model = new VizModel(pc.getCurrentWorkspace());
                pc.getCurrentWorkspace().add((Object)model);
            }
        }
        if (model != this.currentModel) {
            model.setListeners(this.currentModel.getListeners());
            model.getTextModel().setListeners(this.currentModel.getTextModel().getListeners());
            this.currentModel.setListeners(null);
            this.currentModel.getTextModel().setListeners(null);
            this.currentModel = model;
            this.currentModel.init();
        }
    }

    public void destroy() {
        this.engine.stopDisplay();
        this.drawable.destroy();
        this.engine = null;
        this.scheduler = null;
        this.graphIO = null;
        this.vizEventManager = null;
        this.dataBridge = null;
        this.textManager = null;
        this.screenshotMaker = null;
        this.selectionManager = null;
    }

    public void resetSelection() {
        if (this.selectionManager != null) {
            this.selectionManager.resetSelection();
        }
    }

    public void selectNode(Node node) {
        if (this.selectionManager != null) {
            this.selectionManager.selectNode(node);
        }
    }

    public void selectEdge(Edge edge) {
        if (this.selectionManager != null) {
            this.selectionManager.selectEdge(edge);
        }
    }

    public void selectNodes(Node[] nodes) {
        if (this.selectionManager != null) {
            this.selectionManager.selectNodes(nodes);
        }
    }

    public void selectEdges(Edge[] edges) {
        if (this.selectionManager != null) {
            this.selectionManager.selectEdges(edges);
        }
    }

    public Column[] getEdgeTextColumns() {
        return new Column[0];
    }

    public Column[] getNodeTextColumns() {
        return new Column[0];
    }

    public VizModel getVizModel() {
        return this.currentModel;
    }

    public GraphDrawable getDrawable() {
        return this.drawable;
    }

    public AbstractEngine getEngine() {
        return this.engine;
    }

    public GraphIO getGraphIO() {
        return this.graphIO;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public VizConfig getVizConfig() {
        return this.vizConfig;
    }

    public VizEventManager getVizEventManager() {
        return this.vizEventManager;
    }

    public GraphLimits getLimits() {
        return this.limits;
    }

    public DataBridge getDataBridge() {
        return this.dataBridge;
    }

    public TextManager getTextManager() {
        return this.textManager;
    }

    public ScreenshotMaker getScreenshotMaker() {
        return this.screenshotMaker;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public GraphCanvas createCanvas() {
        GraphCanvas canvas = new GraphCanvas();
        return canvas;
    }

    public NewtGraphCanvas createNewtCanvas() {
        NewtGraphCanvas canvas = new NewtGraphCanvas();
        return canvas;
    }
}

