/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.model.edge;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.lib.gleem.linalg.Vec2f;
import org.gephi.visualization.GraphLimits;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.node.NodeModel;

public class Edge2dModel
extends EdgeModel {
    protected static float ARROW_WIDTH = 1.0f;
    protected static float ARROW_HEIGHT = 1.1f;
    protected static final float WEIGHT_MINIMUM = 0.4f;
    protected static final float WEIGHT_MAXIMUM = 8.0f;
    protected final NodeModel sourceModel;
    protected final NodeModel targetModel;

    public Edge2dModel(Edge edge, NodeModel sourceModel, NodeModel targetModel) {
        super(edge);
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
    }

    @Override
    public void display(GL2 gl, GLU glu, VizModel vizModel) {
        GraphLimits limits;
        boolean selec;
        boolean bl = selec = this.selected || this.isAutoSelected();
        if (!selec && vizModel.isHideNonSelectedEdges()) {
            return;
        }
        if (selec && vizModel.isAutoSelectNeighbor()) {
            this.sourceModel.mark = true;
            this.targetModel.mark = true;
        }
        float weightRatio = (limits = vizModel.getLimits()).getMinWeight() == limits.getMaxWeight() ? 0.4f / limits.getMinWeight() : Math.abs(7.6f / (limits.getMaxWeight() - limits.getMinWeight()));
        float edgeScale = vizModel.getEdgeScale();
        float w = this.getWeight();
        w = ((w - limits.getMinWeight()) * weightRatio + 0.4f) * edgeScale;
        float x1 = this.edge.getSource().x();
        float x2 = this.edge.getTarget().x();
        float y1 = this.edge.getSource().y();
        float y2 = this.edge.getTarget().y();
        float t1 = w;
        float t2 = w;
        float sideVectorX = y1 - y2;
        float sideVectorY = x2 - x1;
        float norm = (float)Math.sqrt(sideVectorX * sideVectorX + sideVectorY * sideVectorY);
        float x1Thick = (sideVectorX /= norm) / 2.0f * t1;
        float x2Thick = sideVectorX / 2.0f * t2;
        float y1Thick = (sideVectorY /= norm) / 2.0f * t1;
        float y2Thick = sideVectorY / 2.0f * t2;
        if (!selec) {
            float b;
            float g;
            float r;
            float a = this.edge.alpha();
            if (a == 0.0f) {
                Node source;
                if (vizModel.isEdgeHasUniColor()) {
                    float[] uni = vizModel.getEdgeUniColor();
                    r = uni[0];
                    g = uni[1];
                    b = uni[2];
                    a = uni[3];
                } else if (this.edge.isDirected()) {
                    source = this.edge.getSource();
                    r = source.r();
                    g = source.g();
                    b = source.b();
                    a = source.alpha();
                } else {
                    source = this.edge.getSource();
                    Node target = this.edge.getTarget();
                    r = (source.r() + target.r()) / 2.0f;
                    g = (source.g() + target.g()) / 2.0f;
                    b = (source.b() + target.b()) / 2.0f;
                    a = (source.alpha() + target.alpha()) / 2.0f;
                }
            } else {
                g = this.edge.g();
                b = this.edge.b();
                r = this.edge.r();
            }
            if (vizModel.getConfig().isLightenNonSelected()) {
                float lightColorFactor = vizModel.getConfig().getLightenNonSelectedFactor();
                a -= (a - 0.01f) * lightColorFactor;
                this.color[0] = r;
                this.color[1] = g;
                this.color[2] = b;
                this.color[3] = a;
                gl.glColor4f(r, g, b, a);
            } else {
                this.color[0] = r;
                this.color[1] = g;
                this.color[2] = b;
                this.color[3] = a;
                gl.glColor4f(r, g, b, a);
            }
        } else {
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (vizModel.isEdgeSelectionColor()) {
                if (this.sourceModel.isSelected() && this.targetModel.isSelected()) {
                    float[] both = vizModel.getEdgeBothSelectionColor();
                    r = both[0];
                    g = both[1];
                    b = both[2];
                } else if (this.sourceModel.isSelected()) {
                    float[] out = vizModel.getEdgeOutSelectionColor();
                    r = out[0];
                    g = out[1];
                    b = out[2];
                } else if (this.targetModel.isSelected()) {
                    float[] in = vizModel.getEdgeInSelectionColor();
                    r = in[0];
                    g = in[1];
                    b = in[2];
                }
            } else {
                r = this.edge.r();
                g = this.edge.g();
                b = this.edge.b();
                if (this.edge.alpha() == 0.0f) {
                    Node node = this.sourceModel.isSelected() ? this.edge.getTarget() : this.edge.getSource();
                    r = node.r();
                    g = node.g();
                    b = node.b();
                }
                r = Math.min(1.0f, 0.5f * r + 0.5f);
                g = Math.min(1.0f, 0.5f * g + 0.5f);
                b = Math.min(1.0f, 0.5f * b + 0.5f);
            }
            this.color[0] = r;
            this.color[1] = g;
            this.color[2] = b;
            this.color[3] = 1.0f;
            gl.glColor4f(r, g, b, 1.0f);
        }
        gl.glVertex2f(x1 + x1Thick, y1 + y1Thick);
        gl.glVertex2f(x1 - x1Thick, y1 - y1Thick);
        gl.glVertex2f(x2 - x2Thick, y2 - y2Thick);
        gl.glVertex2f(x2 - x2Thick, y2 - y2Thick);
        gl.glVertex2f(x2 + x2Thick, y2 + y2Thick);
        gl.glVertex2f(x1 + x1Thick, y1 + y1Thick);
    }

    @Override
    public void displayArrow(GL2 gl, GLU glu, VizModel vizModel) {
        boolean selec;
        boolean bl = selec = this.selected || this.isAutoSelected();
        if (!selec && vizModel.isHideNonSelectedEdges()) {
            return;
        }
        Node nodeFrom = this.edge.getSource();
        Node nodeTo = this.edge.getTarget();
        GraphLimits limits = vizModel.getLimits();
        float weightRatio = limits.getMinWeight() == limits.getMaxWeight() ? 0.4f / limits.getMinWeight() : Math.abs(7.6f / (limits.getMaxWeight() - limits.getMinWeight()));
        float edgeScale = vizModel.getEdgeScale();
        float w = this.getWeight();
        w = ((w - limits.getMinWeight()) * weightRatio + 0.4f) * edgeScale;
        float arrowWidth = ARROW_WIDTH * w * 2.0f;
        float arrowHeight = ARROW_HEIGHT * w * 2.0f;
        float x2 = nodeTo.x();
        float y2 = nodeTo.y();
        float x1 = nodeFrom.x();
        float y1 = nodeFrom.y();
        Vec2f edgeVector = new Vec2f(x2 - x1, y2 - y1);
        edgeVector.normalize();
        double angle = Math.atan2(y2 - y1, x2 - x1);
        float collisionDistance = this.targetModel.getCollisionDistance(angle);
        float targetX = x2 - edgeVector.x() * collisionDistance;
        float targetY = y2 - edgeVector.y() * collisionDistance;
        float baseX = targetX - edgeVector.x() * arrowHeight * 2.0f;
        float baseY = targetY - edgeVector.y() * arrowHeight * 2.0f;
        float sideVectorX = y1 - y2;
        float sideVectorY = x2 - x1;
        float norm = (float)Math.sqrt(sideVectorX * sideVectorX + sideVectorY * sideVectorY);
        gl.glColor4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        gl.glVertex2d((double)(baseX + (sideVectorX /= norm) * arrowWidth), (double)(baseY + (sideVectorY /= norm) * arrowWidth));
        gl.glVertex2d((double)(baseX - sideVectorX * arrowWidth), (double)(baseY - sideVectorY * arrowWidth));
        gl.glVertex2d((double)targetX, (double)targetY);
    }

    @Override
    public boolean isAutoSelected() {
        return this.sourceModel.isSelected() || this.targetModel.isSelected();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public NodeModel getSourceModel() {
        return this.sourceModel;
    }

    @Override
    public NodeModel getTargetModel() {
        return this.targetModel;
    }
}

