/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.opengl;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gephi.visualization.opengl.GraphicalConfigurationException;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class GraphicalConfiguration {
    private static boolean messageDelivered = false;
    private boolean vboSupport = false;
    private boolean pBufferSupport = false;
    private String vendor = "";
    private String renderer = "";
    private String versionStr = "";
    private final GLProfile profile = GLProfile.get((String)"GL2");
    private final GLCapabilities caps = new GLCapabilities(this.profile);
    private final AbstractGraphicsDevice device = GLDrawableFactory.getFactory((GLProfile)this.profile).getDefaultDevice();

    public void checkGeneralCompatibility(GL2 gl) {
        if (messageDelivered) {
            return;
        }
        try {
            this.vendor = gl.glGetString(7936);
            this.renderer = gl.glGetString(7937);
            this.versionStr = gl.glGetString(7938);
            String currentConfig = String.format(NbBundle.getMessage(GraphicalConfiguration.class, (String)"graphicalConfiguration_currentConfig"), this.vendor, this.renderer, this.versionStr);
            if (!gl.isExtensionAvailable("GL_VERSION_1_2")) {
                String err = String.format(NbBundle.getMessage(GraphicalConfiguration.class, (String)"graphicalConfiguration_exception"), this.versionStr, currentConfig);
                throw new GraphicalConfigurationException(err);
            }
            boolean vboExtension = gl.isExtensionAvailable("GL_ARB_vertex_buffer_object");
            boolean vboFunctions = gl.isFunctionAvailable("glGenBuffersARB") && gl.isFunctionAvailable("glBindBufferARB") && gl.isFunctionAvailable("glBufferDataARB") && gl.isFunctionAvailable("glDeleteBuffersARB");
            this.vboSupport = vboExtension && vboFunctions;
            this.pBufferSupport = GLDrawableFactory.getDesktopFactory().canCreateGLPbuffer(this.device, this.profile);
        }
        catch (GraphicalConfigurationException exc) {
            messageDelivered = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), exc.getMessage(), "Configuration", 2);
                    exc.printStackTrace();
                }
            });
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public String getVersionStr() {
        return this.versionStr;
    }

    public boolean isPBufferSupported() {
        return this.pBufferSupport;
    }

    public boolean isVboSupported() {
        return this.vboSupport;
    }
}

